/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.chat;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.ToolSpecification;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.langchain4j.chat.LangChain4jChat;
import org.apache.camel.component.langchain4j.chat.LangChain4jChatComponent;
import org.apache.camel.component.langchain4j.chat.LangChain4jChatConfiguration;
import org.apache.camel.component.langchain4j.chat.LangChain4jChatConsumer;
import org.apache.camel.component.langchain4j.chat.LangChain4jChatProducer;
import org.apache.camel.component.langchain4j.chat.tool.CamelSimpleToolParameter;
import org.apache.camel.component.langchain4j.chat.tool.CamelToolExecutorCache;
import org.apache.camel.component.langchain4j.chat.tool.CamelToolSpecification;
import org.apache.camel.component.langchain4j.chat.tool.NamedJsonSchemaProperty;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.StringHelper;

@UriEndpoint(firstVersion="4.5.0", scheme="langchain4j-chat", title="LangChain4j Chat", syntax="langchain4j-chat:chatId", category={Category.AI}, headersClass=LangChain4jChat.Headers.class)
public class LangChain4jChatEndpoint
extends DefaultEndpoint {
    @Metadata(required=true)
    @UriPath(description="The id")
    private final String chatId;
    @UriParam
    private LangChain4jChatConfiguration configuration;
    @Metadata(label="consumer")
    @UriParam(description="Tool description")
    private String description;
    @Metadata(label="consumer")
    @UriParam(description="List of Tool parameters in the form of parameter.<name>=<type>", prefix="parameter.", multiValue=true, enums="string,integer,number,object,array,boolean,null")
    private Map<String, String> parameters;
    @Metadata(label="consumer,advanced")
    @UriParam(description="Tool's Camel Parameters, programmatically define Tool description and parameters")
    private CamelSimpleToolParameter camelToolParameter;

    public LangChain4jChatEndpoint(String uri, LangChain4jChatComponent component, String chatId, LangChain4jChatConfiguration configuration) {
        super(uri, (Component)component);
        this.chatId = chatId;
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new LangChain4jChatProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ToolSpecification.Builder toolSpecificationBuilder = ToolSpecification.builder();
        toolSpecificationBuilder.name(UUID.randomUUID().toString());
        if (this.camelToolParameter != null) {
            toolSpecificationBuilder.description(this.camelToolParameter.getDescription());
            for (NamedJsonSchemaProperty namedJsonSchemaProperty : this.camelToolParameter.getProperties()) {
                toolSpecificationBuilder.addParameter(namedJsonSchemaProperty.getName(), namedJsonSchemaProperty.getProperties());
            }
        } else if (this.description != null) {
            toolSpecificationBuilder.description(this.description);
            if (this.parameters != null) {
                this.parameters.forEach((name, type) -> toolSpecificationBuilder.addParameter(name, new JsonSchemaProperty[]{JsonSchemaProperty.type((String)type)}));
            }
        } else {
            throw new IllegalArgumentException("In order to use the langchain4j component as a consumer, you need to specify at least description, or a camelToolParameter");
        }
        String simpleDescription = null;
        if (this.description != null) {
            simpleDescription = StringHelper.dashToCamelCase((String)this.description.replace(" ", "-"));
        }
        ToolSpecification toolSpecification = toolSpecificationBuilder.name(simpleDescription).build();
        LangChain4jChatConsumer langChain4jChatConsumer = new LangChain4jChatConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)langChain4jChatConsumer);
        CamelToolSpecification camelToolSpecification = new CamelToolSpecification(toolSpecification, langChain4jChatConsumer);
        CamelToolExecutorCache.getInstance().put(this.chatId, camelToolSpecification);
        return camelToolSpecification.getConsumer();
    }

    public String getChatId() {
        return this.chatId;
    }

    public LangChain4jChatConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public CamelSimpleToolParameter getCamelToolParameter() {
        return this.camelToolParameter;
    }

    public void setCamelToolParameter(CamelSimpleToolParameter camelToolParameter) {
        this.camelToolParameter = camelToolParameter;
    }

    protected void doStop() throws Exception {
        super.doStop();
        CamelToolExecutorCache.getInstance().getTools().clear();
    }
}

