/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.langchain4j.embeddings;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.langchain4j.embeddings.LangChain4jEmbeddings;
import org.apache.camel.component.langchain4j.embeddings.LangChain4jEmbeddingsConfiguration;
import org.apache.camel.component.langchain4j.embeddings.LangChain4jEmbeddingsProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.5.0", scheme="langchain4j-embeddings", title="LangChain4j Embeddings", syntax="langchain4j-embeddings:embeddingId", producerOnly=true, category={Category.AI}, headersClass=LangChain4jEmbeddings.Headers.class)
public class LangChain4jEmbeddingsEndpoint
extends DefaultEndpoint {
    @Metadata(required=true)
    @UriPath(description="The id")
    private final String embeddingId;
    @UriParam
    private LangChain4jEmbeddingsConfiguration configuration;

    public LangChain4jEmbeddingsEndpoint(String endpointUri, Component component, String embeddingId, LangChain4jEmbeddingsConfiguration configuration) {
        super(endpointUri, component);
        this.embeddingId = embeddingId;
        this.configuration = configuration;
    }

    public LangChain4jEmbeddingsConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getEmbeddingId() {
        return this.embeddingId;
    }

    public Producer createProducer() throws Exception {
        return new LangChain4jEmbeddingsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not implemented for this component");
    }
}

