/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.language.LanguageEndpoint;
import org.apache.camel.spi.Language;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@org.apache.camel.spi.annotations.Component(value="language")
public class LanguageComponent
extends DefaultComponent {
    public static final String RESOURCE = "resource:";

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String name = StringHelper.before((String)remaining, (String)":");
        String script = StringHelper.after((String)remaining, (String)":");
        if (name == null && script == null) {
            name = remaining;
        }
        if (ObjectHelper.isEmpty((String)name)) {
            throw new IllegalArgumentException("Illegal syntax. Name of language not given in uri: " + uri);
        }
        Language language = this.getCamelContext().resolveLanguage(name);
        String resourceUri = null;
        String resource = script;
        if (resource != null) {
            boolean resourcePrefix = false;
            if (resource.startsWith(RESOURCE)) {
                resourcePrefix = true;
                resource = resource.substring(RESOURCE.length());
            }
            if (resourcePrefix) {
                resourceUri = resource;
                script = null;
            } else {
                script = URLDecoder.decode(script, StandardCharsets.UTF_8);
                resourceUri = null;
            }
        }
        LanguageEndpoint endpoint = new LanguageEndpoint(uri, (Component)this, language, null, resourceUri);
        endpoint.setScript(script);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }
}

