/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.lucene;

import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.lucene.LuceneSearcher;
import org.apache.camel.processor.lucene.support.Hits;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;

public class LuceneQueryProcessor
implements Processor {
    private File indexDirectory;
    private Analyzer analyzer;
    private IndexSearcher indexSearcher;
    private LuceneSearcher searcher;
    private String searchPhrase;
    private int maxNumberOfHits;
    private int totalHitsThreshold;

    public LuceneQueryProcessor(String indexDirectoryPath, Analyzer analyzer, String defaultSearchPhrase, int maxNumberOfHits, int totalHitsThreshold) {
        this.setAnalyzer(analyzer);
        this.setIndexDirectory(new File(indexDirectoryPath));
        this.setSearchPhrase(defaultSearchPhrase);
        this.setMaxNumberOfHits(maxNumberOfHits);
    }

    public void process(Exchange exchange) throws Exception {
        boolean isReturnLuceneDocs;
        String phrase = (String)exchange.getIn().getHeader("QUERY", String.class);
        String returnLuceneDocs = (String)exchange.getIn().getHeader("RETURN_LUCENE_DOCS", String.class);
        boolean bl = isReturnLuceneDocs = returnLuceneDocs != null && returnLuceneDocs.equalsIgnoreCase("true");
        if (phrase == null) {
            throw new IllegalArgumentException("SearchPhrase for LuceneQueryProcessor not set. Set the Header value: QUERY");
        }
        this.searcher = new LuceneSearcher();
        this.searcher.open(this.indexDirectory, this.analyzer);
        Hits hits = this.searcher.search(phrase, this.maxNumberOfHits, this.totalHitsThreshold, isReturnLuceneDocs);
        exchange.getIn().setBody((Object)hits);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public IndexSearcher getIndexSearcher() {
        return this.indexSearcher;
    }

    public void setIndexSearcher(IndexSearcher indexSearcher) {
        this.indexSearcher = indexSearcher;
    }

    public File getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(File indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public String getSearchPhrase() {
        return this.searchPhrase;
    }

    public void setSearchPhrase(String searchPhrase) {
        this.searchPhrase = searchPhrase;
    }

    public int getMaxNumberOfHits() {
        return this.maxNumberOfHits;
    }

    public void setMaxNumberOfHits(int maxNumberOfHits) {
        this.maxNumberOfHits = maxNumberOfHits;
    }

    public int getTotalHitsThreshold() {
        return this.totalHitsThreshold;
    }

    public void setTotalHitsThreshold(int totalHitsThreshold) {
        this.totalHitsThreshold = totalHitsThreshold;
    }
}

