/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.lzf;

import com.ning.compress.lzf.LZFInputStream;
import com.ning.compress.lzf.LZFOutputStream;
import com.ning.compress.lzf.parallel.PLZFOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.converter.stream.OutputStreamBuilder;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;

@Dataformat(value="lzf")
public class LZFDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private boolean parallelCompression;

    public String getDataFormatName() {
        return "lzf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        PLZFOutputStream compressedOutput = this.parallelCompression ? new PLZFOutputStream(stream) : new LZFOutputStream(stream);
        try {
            IOHelper.copy((InputStream)is, (OutputStream)compressedOutput);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{is, compressedOutput});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{is, compressedOutput});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        LZFInputStream compressedInput = null;
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange((Exchange)exchange);
        try {
            compressedInput = new LZFInputStream(inputStream);
            IOHelper.copy((InputStream)compressedInput, (OutputStream)osb);
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{osb, compressedInput, inputStream});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{osb, compressedInput, inputStream});
        return object;
    }

    public boolean isUsingParallelCompression() {
        return this.parallelCompression;
    }

    public void setUsingParallelCompression(boolean parallelCompression) {
        this.parallelCompression = parallelCompression;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

