/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import javax.mail.search.SearchTerm;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mail.ContentTypeResolver;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailConverters;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.SimpleSearchTerm;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

public class MailComponent
extends UriEndpointComponent {
    private MailConfiguration configuration;
    private ContentTypeResolver contentTypeResolver;

    public MailComponent() {
        super(MailEndpoint.class);
    }

    public MailComponent(MailConfiguration configuration) {
        super(MailEndpoint.class);
        this.configuration = configuration;
    }

    public MailComponent(CamelContext context) {
        super(context, MailEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        URI url = new URI(uri);
        MailConfiguration config = this.getConfiguration().copy();
        config.configure(url);
        this.configureAdditionalJavaMailProperties(config, parameters);
        MailEndpoint endpoint = new MailEndpoint(uri, this, config);
        endpoint.setContentTypeResolver(this.contentTypeResolver);
        this.setProperties(endpoint.getConfiguration(), parameters);
        Map sstParams = IntrospectionSupport.extractProperties(parameters, (String)"searchTerm.");
        if (!sstParams.isEmpty()) {
            SimpleSearchTerm sst = new SimpleSearchTerm();
            this.setProperties(sst, sstParams);
            SearchTerm st = MailConverters.toSearchTerm(sst, this.getCamelContext().getTypeConverter());
            endpoint.setSearchTerm(st);
        }
        ObjectHelper.notEmpty((String)config.getHost(), (String)"host");
        ObjectHelper.notEmpty((String)config.getProtocol(), (String)"protocol");
        return endpoint;
    }

    private void configureAdditionalJavaMailProperties(MailConfiguration config, Map<String, Object> parameters) {
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (!entry.getKey().toString().startsWith("mail.")) continue;
            config.getAdditionalJavaMailProperties().put(entry.getKey(), entry.getValue());
            toRemove.add(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : toRemove) {
            parameters.remove(entry);
        }
    }

    public MailConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new MailConfiguration(this.getCamelContext());
        }
        return this.configuration;
    }

    public void setConfiguration(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    public ContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setContentTypeResolver(ContentTypeResolver contentTypeResolver) {
        this.contentTypeResolver = contentTypeResolver;
    }
}

