/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.SortTerm;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.search.SearchTerm;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailBoxPostProcessAction;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.component.mail.MailSorter;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.component.mail.SearchTermBuilder;
import org.apache.camel.impl.ScheduledBatchPollingConsumer;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailConsumer
extends ScheduledBatchPollingConsumer {
    public static final String POP3_UID = "CamelPop3Uid";
    public static final long DEFAULT_CONSUMER_DELAY = 60000L;
    private static final Logger LOG = LoggerFactory.getLogger(MailConsumer.class);
    private final JavaMailSender sender;
    private Folder folder;
    private Store store;
    private boolean serverCanSort;

    public MailConsumer(MailEndpoint endpoint, Processor processor, JavaMailSender sender) {
        super((Endpoint)endpoint, processor);
        this.sender = sender;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(true);
        }
        if (this.store != null && this.store.isConnected()) {
            this.store.close();
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        int polledMessages = 0;
        this.ensureIsConnected();
        if (this.store == null || this.folder == null) {
            throw new IllegalStateException("MailConsumer did not connect properly to the MailStore: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Polling mailbox folder: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation());
        }
        if (this.getEndpoint().getConfiguration().getFetchSize() == 0) {
            LOG.warn("Fetch size is 0 meaning the configuration is set to poll no new messages at all. Camel will skip this poll.");
            return 0;
        }
        if (!this.folder.isOpen()) {
            this.folder.open(2);
        }
        try {
            int count = this.folder.getMessageCount();
            if (count > 0) {
                javax.mail.Message[] messages = this.retrieveMessages();
                polledMessages = this.processBatch(CastUtils.cast(this.createExchanges(messages)));
                MailBoxPostProcessAction postProcessor = this.getEndpoint().getPostProcessAction();
                if (postProcessor != null) {
                    postProcessor.process(this.folder);
                }
            } else if (count == -1) {
                throw new MessagingException("Folder: " + this.folder.getFullName() + " is closed");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            if (this.getEndpoint().getConfiguration().isCloseFolder() || this.getEndpoint().getConfiguration().isDisconnect()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Close mailbox folder {} from {}", (Object)this.folder.getName(), (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
                }
                try {
                    if (this.folder.isOpen()) {
                        this.folder.close(true);
                    }
                }
                catch (Exception e) {
                    LOG.debug("Could not close mailbox folder: " + this.folder.getName() + ". This exception is ignored.", (Throwable)e);
                }
            }
        }
        boolean disconnect = this.getEndpoint().getConfiguration().isDisconnect();
        if (disconnect) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Disconnecting from {}", (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
            }
            try {
                this.store.close();
            }
            catch (Exception e) {
                LOG.debug("Could not disconnect from {}: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation() + ". This exception is ignored.", (Throwable)e);
            }
            this.store = null;
            this.folder = null;
        }
        return polledMessages;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            LOG.debug("Limiting to maximum messages to poll {} as there was {} messages in this poll.", (Object)this.maxMessagesPerPoll, (Object)total);
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            final javax.mail.Message mail = ((MailMessage)((Object)exchange.getIn(MailMessage.class))).getOriginalMessage();
            if (this.getEndpoint().getConfiguration().isPeek()) {
                this.peekMessage(mail);
            }
            exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onComplete(Exchange exchange) {
                    MailConsumer.this.processCommit(mail, exchange);
                }

                public void onFailure(Exchange exchange) {
                    MailConsumer.this.processRollback(mail, exchange);
                }

                public boolean allowHandover() {
                    return false;
                }

                public String toString() {
                    return "MailConsumerOnCompletion";
                }
            });
            this.processExchange(exchange);
        }
        return total;
    }

    private void peekMessage(javax.mail.Message mail) {
        if (mail.getClass().getSimpleName().startsWith("IMAP")) {
            try {
                LOG.trace("Calling setPeek(true) on mail message {}", (Object)mail);
                IntrospectionSupport.setProperty((Object)mail, (String)"peek", (Object)true);
            }
            catch (Throwable e) {
                LOG.trace("Error setting peak property to true on: " + mail + ". This exception is ignored.", e);
            }
        }
    }

    private javax.mail.Message[] retrieveMessages() throws MessagingException {
        javax.mail.Message[] messages;
        SortTerm[] sortTerm = this.getEndpoint().getSortTerm();
        SearchTerm searchTerm = this.computeSearchTerm();
        if (sortTerm != null && this.serverCanSort) {
            IMAPFolder imapFolder = (IMAPFolder)this.folder;
            messages = searchTerm != null ? imapFolder.getSortedMessages(sortTerm, searchTerm) : imapFolder.getSortedMessages(sortTerm);
        } else {
            messages = searchTerm != null ? this.folder.search(searchTerm) : this.folder.getMessages();
            if (sortTerm != null) {
                MailSorter.sortMessages(messages, sortTerm);
            }
        }
        return messages;
    }

    private SearchTerm computeSearchTerm() {
        if (this.getEndpoint().getSearchTerm() != null) {
            return this.getEndpoint().getSearchTerm();
        }
        if (this.getEndpoint().getConfiguration().isUnseen()) {
            return new SearchTermBuilder().unseen().build();
        }
        return null;
    }

    protected Queue<Exchange> createExchanges(javax.mail.Message[] messages) throws MessagingException {
        int count;
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        int fetchSize = this.getEndpoint().getConfiguration().getFetchSize();
        int n = count = fetchSize == -1 ? messages.length : Math.min(fetchSize, messages.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching {} messages. Total {} messages.", (Object)count, (Object)messages.length);
        }
        for (int i = 0; i < count; ++i) {
            javax.mail.Message message = messages[i];
            if (LOG.isTraceEnabled()) {
                LOG.trace("Mail #{} is of type: {} - {}", new Object[]{i, ObjectHelper.classCanonicalName((Object)message), message});
            }
            if (!message.getFlags().contains(Flags.Flag.DELETED)) {
                String uid;
                Exchange exchange = this.getEndpoint().createExchange(message);
                if (this.getEndpoint().getConfiguration().isMapMailMessage()) {
                    LOG.trace("Mapping #{} from javax.mail.Message to Camel MailMessage", (Object)i);
                    exchange.getIn().getBody();
                    exchange.getIn().getHeaders();
                    exchange.getIn().getAttachments();
                }
                if (this.getEndpoint().getConfiguration().getProtocol().startsWith("pop3") && (uid = this.generatePop3Uid(message)) != null) {
                    exchange.setProperty(POP3_UID, (Object)uid);
                    LOG.trace("POP3 mail message using uid {}", (Object)uid);
                }
                answer.add(exchange);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skipping message as it was flagged as deleted: {}", (Object)MailUtils.dumpMessage(message));
        }
        return answer;
    }

    protected void processExchange(Exchange exchange) throws Exception {
        if (LOG.isDebugEnabled()) {
            MailMessage msg = (MailMessage)exchange.getIn();
            LOG.debug("Processing message: {}", (Object)MailUtils.dumpMessage(msg.getMessage()));
        }
        this.getProcessor().process(exchange);
    }

    protected void processCommit(javax.mail.Message mail, Exchange exchange) {
        try {
            String uid;
            if (!this.folder.isOpen()) {
                this.folder.open(2);
            }
            if ((uid = (String)exchange.removeProperty(POP3_UID)) != null) {
                int count = this.folder.getMessageCount();
                javax.mail.Message found = null;
                LOG.trace("Looking for POP3Message with UID {} from folder with {} mails", (Object)uid, (Object)count);
                for (int i = 1; i <= count; ++i) {
                    javax.mail.Message msg = this.folder.getMessage(i);
                    if (!uid.equals(this.generatePop3Uid(msg))) continue;
                    LOG.debug("Found POP3Message with UID {} from folder with {} mails", (Object)uid, (Object)count);
                    found = msg;
                    break;
                }
                if (found == null) {
                    boolean delete = this.getEndpoint().getConfiguration().isDelete();
                    LOG.warn("POP3message not found in folder. Message cannot be marked as " + (delete ? "DELETED" : "SEEN"));
                } else {
                    mail = found;
                }
            }
            Message in = exchange.getIn();
            MailConfiguration config = this.getEndpoint().getConfiguration();
            String copyTo = (String)in.getHeader("copyTo", (Object)config.getCopyTo(), String.class);
            boolean delete = (Boolean)in.getHeader("delete", (Object)config.isDelete(), Boolean.TYPE);
            if ((config.getProtocol().equals("imap") || config.getProtocol().equals("imaps")) && copyTo != null) {
                LOG.trace("IMAP message needs to be copied to {}", (Object)copyTo);
                Folder destFolder = this.store.getFolder(copyTo);
                if (!destFolder.exists()) {
                    destFolder.create(1);
                }
                this.folder.copyMessages(new javax.mail.Message[]{mail}, destFolder);
                LOG.trace("IMAP message {} copied to {}", (Object)mail, (Object)copyTo);
            }
            if (delete) {
                LOG.trace("Exchange processed, so flagging message as DELETED");
                mail.setFlag(Flags.Flag.DELETED, true);
            } else {
                LOG.trace("Exchange processed, so flagging message as SEEN");
                mail.setFlag(Flags.Flag.SEEN, true);
            }
        }
        catch (MessagingException e) {
            this.getExceptionHandler().handleException("Error occurred during committing mail message: " + mail, exchange, (Throwable)e);
        }
    }

    protected void processRollback(javax.mail.Message mail, Exchange exchange) {
        Exception cause = exchange.getException();
        if (cause != null) {
            LOG.warn("Exchange failed, so rolling back message status: " + exchange, (Throwable)cause);
        } else {
            LOG.warn("Exchange failed, so rolling back message status: " + exchange);
        }
    }

    protected String generatePop3Uid(javax.mail.Message message) {
        String uid = null;
        StringBuilder buffer = new StringBuilder();
        try {
            Enumeration it = message.getAllHeaders();
            while (it.hasMoreElements()) {
                Header header = (Header)it.nextElement();
                buffer.append(header.getName()).append("=").append(header.getValue()).append("\n");
            }
            if (buffer.length() > 0) {
                LOG.trace("Generating UID from the following:\n {}", (Object)buffer);
                uid = UUID.nameUUIDFromBytes(buffer.toString().getBytes()).toString();
            }
        }
        catch (MessagingException e) {
            LOG.warn("Cannot reader headers from mail message. This exception will be ignored.", (Throwable)e);
        }
        return uid;
    }

    private void ensureIsConnected() throws MessagingException {
        MailConfiguration config = this.getEndpoint().getConfiguration();
        boolean connected = false;
        try {
            if (this.store != null && this.store.isConnected()) {
                connected = true;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while testing for is connected to MailStore: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation() + ". Caused by: " + e.getMessage(), (Throwable)e);
        }
        if (!connected) {
            this.store = null;
            this.folder = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connecting to MailStore: {}", (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
            }
            this.store = this.sender.getSession().getStore(config.getProtocol());
            this.store.connect(config.getHost(), config.getPort(), config.getUsername(), config.getPassword());
            this.serverCanSort = MailConsumer.hasSortCapability(this.store);
        }
        if (this.folder == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting folder {}", (Object)config.getFolderName());
            }
            this.folder = this.store.getFolder(config.getFolderName());
            if (this.folder == null || !this.folder.exists()) {
                throw new FolderNotFoundException(this.folder, "Folder not found or invalid: " + config.getFolderName());
            }
        }
    }

    private static boolean hasSortCapability(Store store) throws MessagingException {
        IMAPStore imapStore;
        return store instanceof IMAPStore && (imapStore = (IMAPStore)store).hasCapability("SORT*");
    }

    public MailEndpoint getEndpoint() {
        return (MailEndpoint)super.getEndpoint();
    }
}

