/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.SortTerm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.search.SearchTerm;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailBoxPostProcessAction;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.component.mail.MailSorter;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.component.mail.SearchTermBuilder;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;

public class MailConsumer
extends ScheduledBatchPollingConsumer {
    public static final String MAIL_MESSAGE_UID = "CamelMailMessageId";
    public static final long DEFAULT_CONSUMER_DELAY = 60000L;
    private final JavaMailSender sender;
    private Folder folder;
    private Store store;
    private boolean skipFailedMessage;
    private boolean handleFailedMessage;
    private boolean serverCanSort;

    public MailConsumer(MailEndpoint endpoint, Processor processor, JavaMailSender sender) {
        super((Endpoint)endpoint, processor);
        this.sender = sender;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(true);
        }
        if (this.store != null && this.store.isConnected()) {
            this.store.close();
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        int polledMessages = 0;
        this.ensureIsConnected();
        if (this.store == null || this.folder == null) {
            throw new IllegalStateException("MailConsumer did not connect properly to the MailStore: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Polling mailbox folder: {}", (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
        }
        if (this.getEndpoint().getConfiguration().getFetchSize() == 0) {
            this.log.warn("Fetch size is 0 meaning the configuration is set to poll no new messages at all. Camel will skip this poll.");
            return 0;
        }
        if (!this.folder.isOpen()) {
            this.folder.open(2);
        }
        try {
            int count = this.folder.getMessageCount();
            if (count > 0) {
                List<KeyValueHolder<String, javax.mail.Message>> messages = this.retrieveMessages();
                if (this.getEndpoint().getConfiguration().isPeek()) {
                    for (KeyValueHolder<String, javax.mail.Message> entry : messages) {
                        javax.mail.Message message = (javax.mail.Message)entry.getValue();
                        this.peekMessage(message);
                    }
                }
                polledMessages = this.processBatch(CastUtils.cast(this.createExchanges(messages)));
                MailBoxPostProcessAction postProcessor = this.getEndpoint().getPostProcessAction();
                if (postProcessor != null) {
                    postProcessor.process(this.folder);
                }
            } else if (count == -1) {
                throw new MessagingException("Folder: " + this.folder.getFullName() + " is closed");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            if (this.getEndpoint().getConfiguration().isCloseFolder() || this.getEndpoint().getConfiguration().isDisconnect()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Close mailbox folder {} from {}", (Object)this.folder.getName(), (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
                }
                try {
                    if (this.folder.isOpen()) {
                        this.folder.close(true);
                    }
                }
                catch (Exception e) {
                    this.log.debug("Could not close mailbox folder: " + this.folder.getName() + ". This exception is ignored.", (Throwable)e);
                }
            }
        }
        boolean disconnect = this.getEndpoint().getConfiguration().isDisconnect();
        if (disconnect) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Disconnecting from {}", (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
            }
            try {
                this.store.close();
            }
            catch (Exception e) {
                this.log.debug("Could not disconnect from {}. This exception is ignored.", (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation(), (Object)e);
            }
            this.store = null;
            this.folder = null;
        }
        return polledMessages;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            this.log.debug("Limiting to maximum messages to poll {} as there were {} messages in this poll.", (Object)this.maxMessagesPerPoll, (Object)total);
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            final javax.mail.Message mail = ((MailMessage)((Object)exchange.getIn(MailMessage.class))).getOriginalMessage();
            exchange.addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onComplete(Exchange exchange) {
                    MailConsumer.this.processCommit(mail, exchange);
                }

                public void onFailure(Exchange exchange) {
                    MailConsumer.this.processRollback(mail, exchange);
                }

                public boolean allowHandover() {
                    return false;
                }

                public String toString() {
                    return "MailConsumerOnCompletion";
                }
            });
            this.processExchange(exchange);
        }
        return total;
    }

    private void peekMessage(javax.mail.Message mail) {
        if (mail.getClass().getSimpleName().startsWith("IMAP")) {
            try {
                this.log.trace("Calling setPeek(true) on mail message {}", (Object)mail);
                IntrospectionSupport.setProperty((Object)mail, (String)"peek", (Object)true);
            }
            catch (Throwable e) {
                this.log.trace("Error setting peak property to true on: " + mail + ". This exception is ignored.", e);
            }
        }
    }

    private List<KeyValueHolder<String, javax.mail.Message>> retrieveMessages() throws MessagingException {
        javax.mail.Message[] messages;
        ArrayList<KeyValueHolder<String, javax.mail.Message>> answer = new ArrayList<KeyValueHolder<String, javax.mail.Message>>();
        SortTerm[] sortTerm = this.getEndpoint().getSortTerm();
        SearchTerm searchTerm = this.computeSearchTerm();
        if (sortTerm != null && this.serverCanSort) {
            IMAPFolder imapFolder = (IMAPFolder)this.folder;
            messages = searchTerm != null ? imapFolder.getSortedMessages(sortTerm, searchTerm) : imapFolder.getSortedMessages(sortTerm);
        } else {
            messages = searchTerm != null ? this.folder.search(searchTerm, this.retrieveAllMessages()) : this.retrieveAllMessages();
            if (sortTerm != null) {
                MailSorter.sortMessages(messages, sortTerm);
            }
        }
        for (javax.mail.Message message : messages) {
            String key = this.getEndpoint().getMailUidGenerator().generateUuid(this.getEndpoint(), message);
            if (!this.isValidMessage(key, message)) continue;
            answer.add((KeyValueHolder<String, javax.mail.Message>)new KeyValueHolder((Object)key, (Object)message));
        }
        return answer;
    }

    private javax.mail.Message[] retrieveAllMessages() throws MessagingException {
        int total = this.folder.getMessageCount();
        ArrayList<javax.mail.Message> msgs = new ArrayList<javax.mail.Message>();
        for (int i = 1; i <= total; ++i) {
            try {
                javax.mail.Message msg = this.folder.getMessage(i);
                msgs.add(msg);
                continue;
            }
            catch (Exception e) {
                if (this.skipFailedMessage) {
                    this.log.debug("Skipping failed message at index " + i + " due " + e.getMessage(), (Throwable)e);
                    continue;
                }
                if (this.handleFailedMessage) {
                    this.handleException(e);
                    continue;
                }
                throw e;
            }
        }
        return msgs.toArray(new javax.mail.Message[msgs.size()]);
    }

    private boolean isValidMessage(String key, javax.mail.Message msg) {
        boolean answer = true;
        if (this.getEndpoint().getIdempotentRepository() != null && !this.getEndpoint().getIdempotentRepository().add(key)) {
            this.log.trace("This consumer is idempotent and the mail message has been consumed before matching idempotentKey: {}. Will skip this message: {}", (Object)key, (Object)msg);
            answer = false;
        }
        this.log.debug("Message: {} with key: {} is valid: {}", new Object[]{msg, key, answer});
        return answer;
    }

    private SearchTerm computeSearchTerm() {
        if (this.getEndpoint().getSearchTerm() != null) {
            return this.getEndpoint().getSearchTerm();
        }
        if (this.getEndpoint().getConfiguration().isUnseen()) {
            return new SearchTermBuilder().unseen().build();
        }
        return null;
    }

    protected Queue<Exchange> createExchanges(List<KeyValueHolder<String, javax.mail.Message>> messages) throws MessagingException {
        int count;
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        int fetchSize = this.getEndpoint().getConfiguration().getFetchSize();
        int n = count = fetchSize == -1 ? messages.size() : Math.min(fetchSize, messages.size());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Fetching {} messages. Total {} messages.", (Object)count, (Object)messages.size());
        }
        for (int i = 0; i < count; ++i) {
            try {
                KeyValueHolder<String, javax.mail.Message> holder = messages.get(i);
                String key = (String)holder.getKey();
                javax.mail.Message message = (javax.mail.Message)holder.getValue();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Mail #{} is of type: {} - {}", new Object[]{i, ObjectHelper.classCanonicalName((Object)message), message});
                }
                if (!message.getFlags().contains(Flags.Flag.DELETED)) {
                    Exchange exchange = this.getEndpoint().createExchange(message);
                    if (this.getEndpoint().getConfiguration().isMapMailMessage()) {
                        this.log.trace("Mapping #{} from javax.mail.Message to Camel MailMessage", (Object)i);
                        exchange.getIn().getBody();
                        exchange.getIn().getHeaders();
                        try {
                            HashMap<String, Attachment> att = new HashMap<String, Attachment>();
                            this.getEndpoint().getBinding().extractAttachmentsFromMail(message, att);
                            if (!att.isEmpty()) {
                                ((AttachmentMessage)exchange.getIn(AttachmentMessage.class)).setAttachmentObjects(att);
                            }
                        }
                        catch (IOException | MessagingException e) {
                            throw new RuntimeCamelException("Error accessing attachments due to: " + e.getMessage(), e);
                        }
                    }
                    exchange.setProperty(MAIL_MESSAGE_UID, (Object)key);
                    answer.add(exchange);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Skipping message as it was flagged as deleted: {}", (Object)MailUtils.dumpMessage(message));
                continue;
            }
            catch (Exception e) {
                if (this.skipFailedMessage) {
                    this.log.debug("Skipping failed message at index " + i + " due " + e.getMessage(), (Throwable)e);
                    continue;
                }
                if (this.handleFailedMessage) {
                    this.handleException(e);
                    continue;
                }
                throw e;
            }
        }
        return answer;
    }

    protected void processExchange(Exchange exchange) throws Exception {
        if (this.log.isDebugEnabled()) {
            MailMessage msg = (MailMessage)exchange.getIn();
            this.log.debug("Processing message: {}", (Object)MailUtils.dumpMessage(msg.getMessage()));
        }
        this.getProcessor().process(exchange);
    }

    protected void processCommit(javax.mail.Message mail, Exchange exchange) {
        try {
            if (!this.folder.isOpen()) {
                this.folder.open(2);
            }
            String uid = (String)exchange.removeProperty(MAIL_MESSAGE_UID);
            if (this.getEndpoint().getConfiguration().getProtocol().startsWith("pop3")) {
                int count = this.folder.getMessageCount();
                javax.mail.Message found = null;
                this.log.trace("Looking for POP3Message with UID {} from folder with {} mails", (Object)uid, (Object)count);
                for (int i = 1; i <= count; ++i) {
                    javax.mail.Message msg = this.folder.getMessage(i);
                    if (!uid.equals(this.getEndpoint().getMailUidGenerator().generateUuid(this.getEndpoint(), msg))) continue;
                    this.log.debug("Found POP3Message with UID {} from folder with {} mails", (Object)uid, (Object)count);
                    found = msg;
                    break;
                }
                if (found == null) {
                    boolean delete = this.getEndpoint().getConfiguration().isDelete();
                    this.log.warn("POP3message not found in folder. Message cannot be marked as " + (delete ? "DELETED" : "SEEN"));
                } else {
                    mail = found;
                }
            }
            Message in = exchange.getIn();
            MailConfiguration config = this.getEndpoint().getConfiguration();
            String copyTo = (String)in.getHeader("copyTo", (Object)config.getCopyTo(), String.class);
            boolean delete = (Boolean)in.getHeader("delete", (Object)config.isDelete(), Boolean.TYPE);
            if ((config.getProtocol().equals("imap") || config.getProtocol().equals("imaps")) && copyTo != null) {
                this.log.trace("IMAP message needs to be copied to {}", (Object)copyTo);
                Folder destFolder = this.store.getFolder(copyTo);
                if (!destFolder.exists()) {
                    destFolder.create(1);
                }
                this.folder.copyMessages(new javax.mail.Message[]{mail}, destFolder);
                this.log.trace("IMAP message {} copied to {}", (Object)mail, (Object)copyTo);
            }
            if (delete) {
                this.log.trace("Exchange processed, so flagging message as DELETED");
                mail.setFlag(Flags.Flag.DELETED, true);
            } else {
                this.log.trace("Exchange processed, so flagging message as SEEN");
                mail.setFlag(Flags.Flag.SEEN, true);
            }
            if (this.getEndpoint().getIdempotentRepository() != null) {
                if (this.getEndpoint().isIdempotentRepositoryRemoveOnCommit()) {
                    this.getEndpoint().getIdempotentRepository().remove(uid);
                } else {
                    this.getEndpoint().getIdempotentRepository().confirm(uid);
                }
            }
        }
        catch (MessagingException e) {
            this.getExceptionHandler().handleException("Error occurred during committing mail message: " + mail, exchange, (Throwable)e);
        }
    }

    protected void processRollback(javax.mail.Message mail, Exchange exchange) {
        Exception cause;
        String uid = (String)exchange.removeProperty(MAIL_MESSAGE_UID);
        if (this.getEndpoint().getIdempotentRepository() != null) {
            this.getEndpoint().getIdempotentRepository().remove(uid);
        }
        if ((cause = exchange.getException()) != null) {
            this.log.warn("Exchange failed, so rolling back message status: {}", (Object)exchange, (Object)cause);
        } else {
            this.log.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    private void ensureIsConnected() throws MessagingException {
        MailConfiguration config = this.getEndpoint().getConfiguration();
        boolean connected = false;
        try {
            if (this.store != null && this.store.isConnected()) {
                connected = true;
            }
        }
        catch (Exception e) {
            this.log.debug("Exception while testing for is connected to MailStore: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation() + ". Caused by: " + e.getMessage(), (Throwable)e);
        }
        if (!connected) {
            this.store = null;
            this.folder = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Connecting to MailStore: {}", (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
            }
            this.store = this.sender.getSession().getStore(config.getProtocol());
            this.store.connect(config.getHost(), config.getPort(), config.getUsername(), config.getPassword());
            this.serverCanSort = MailConsumer.hasSortCapability(this.store);
        }
        if (this.folder == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Getting folder {}", (Object)config.getFolderName());
            }
            this.folder = this.store.getFolder(config.getFolderName());
            if (this.folder == null || !this.folder.exists()) {
                throw new FolderNotFoundException(this.folder, "Folder not found or invalid: " + config.getFolderName());
            }
        }
    }

    private static boolean hasSortCapability(Store store) throws MessagingException {
        IMAPStore imapStore;
        return store instanceof IMAPStore && (imapStore = (IMAPStore)store).hasCapability("SORT*");
    }

    public MailEndpoint getEndpoint() {
        return (MailEndpoint)super.getEndpoint();
    }

    public boolean isSkipFailedMessage() {
        return this.skipFailedMessage;
    }

    public void setSkipFailedMessage(boolean skipFailedMessage) {
        this.skipFailedMessage = skipFailedMessage;
    }

    public boolean isHandleFailedMessage() {
        return this.handleFailedMessage;
    }

    public void setHandleFailedMessage(boolean handleFailedMessage) {
        this.handleFailedMessage = handleFailedMessage;
    }
}

