/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.Date;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;
import org.apache.camel.component.mail.NowSearchTerm;

public class SearchTermBuilder {
    private SearchTerm term;

    public SearchTerm build() {
        return this.term;
    }

    public SearchTermBuilder unseen() {
        return this.unseen(Op.and);
    }

    public SearchTermBuilder unseen(Op op) {
        FlagTerm st = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder header(String headerName, String pattern) {
        return this.header(Op.and, headerName, pattern);
    }

    public SearchTermBuilder header(Op op, String headerName, String pattern) {
        HeaderTerm st = new HeaderTerm(headerName, pattern);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder subject(String pattern) {
        return this.subject(Op.and, pattern);
    }

    public SearchTermBuilder subject(Op op, String pattern) {
        SubjectTerm st = new SubjectTerm(pattern);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder body(String pattern) {
        return this.body(Op.and, pattern);
    }

    public SearchTermBuilder body(Op op, String pattern) {
        BodyTerm st = new BodyTerm(pattern);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder from(String pattern) {
        return this.from(Op.and, pattern);
    }

    public SearchTermBuilder from(Op op, String pattern) {
        FromStringTerm st = new FromStringTerm(pattern);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder recipient(Message.RecipientType type, String pattern) {
        return this.recipient(Op.and, type, pattern);
    }

    public SearchTermBuilder recipient(Op op, Message.RecipientType type, String pattern) {
        RecipientStringTerm st = new RecipientStringTerm(type, pattern);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder flag(Flags flags, boolean set) {
        return this.flag(Op.and, flags, set);
    }

    public SearchTermBuilder flag(Op op, Flags flags, boolean set) {
        FlagTerm st = new FlagTerm(flags, set);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder sent(Comparison comparison, Date date) {
        return this.sent(Op.and, comparison, date);
    }

    public SearchTermBuilder sent(Op op, Comparison comparison, Date date) {
        SentDateTerm st = new SentDateTerm(comparison.asNum(), date);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder sentNow(Comparison comparison, long offset) {
        return this.sentNow(Op.and, comparison, offset);
    }

    public SearchTermBuilder sentNow(Op op, Comparison comparison, long offset) {
        NowSearchTerm st = new NowSearchTerm(comparison.asNum(), true, offset);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder received(Comparison comparison, Date date) {
        return this.received(Op.and, comparison, date);
    }

    public SearchTermBuilder received(Op op, Comparison comparison, Date date) {
        ReceivedDateTerm st = new ReceivedDateTerm(comparison.asNum(), date);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder receivedNow(Comparison comparison, long offset) {
        return this.sentNow(Op.and, comparison, offset);
    }

    public SearchTermBuilder receivedNow(Op op, Comparison comparison, long offset) {
        NowSearchTerm st = new NowSearchTerm(comparison.asNum(), false, offset);
        this.addTerm(op, (SearchTerm)st);
        return this;
    }

    public SearchTermBuilder and(SearchTerm term) {
        this.addTerm(Op.and, term);
        return this;
    }

    public SearchTermBuilder or(SearchTerm term) {
        this.addTerm(Op.or, term);
        return this;
    }

    public SearchTermBuilder not(SearchTerm term) {
        this.addTerm(Op.not, term);
        return this;
    }

    private void addTerm(Op op, SearchTerm newTerm) {
        this.term = this.term == null ? newTerm : (op == Op.and ? new AndTerm(this.term, newTerm) : (op == Op.or ? new OrTerm(this.term, newTerm) : new AndTerm(this.term, (SearchTerm)new NotTerm(newTerm))));
    }

    public static enum Op {
        and,
        or,
        not;

    }

    public static enum Comparison {
        LE,
        LT,
        EQ,
        NE,
        GT,
        GE;


        int asNum() {
            switch (this) {
                case LE: {
                    return 1;
                }
                case LT: {
                    return 2;
                }
                case EQ: {
                    return 3;
                }
                case NE: {
                    return 4;
                }
                case GT: {
                    return 5;
                }
                case GE: {
                    return 6;
                }
            }
            throw new IllegalArgumentException("Unknown comparison " + this);
        }
    }
}

