/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.Map;
import org.apache.camel.CamelConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.main.MainCommandLineSupport;
import org.apache.camel.main.MainRegistry;
import org.apache.camel.spi.Registry;

public class Main
extends MainCommandLineSupport {
    protected static Main instance;
    protected final MainRegistry registry = new MainRegistry();

    public Main() {
    }

    public Main(Class<?> mainClass) {
        this.configure().withBasePackageScan(mainClass.getPackageName());
    }

    @SafeVarargs
    public Main(Class<?> mainClass, Class<CamelConfiguration> ... configurationClasses) {
        super(configurationClasses);
        this.configure().withBasePackageScan(mainClass.getPackageName());
    }

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main();
        int code = main.run(args);
        if (code != 0) {
            System.exit(code);
        }
    }

    public static Main getInstance() {
        return instance;
    }

    public void bind(String name, Object bean) {
        this.registry.bind(name, bean);
    }

    public Object lookup(String name) {
        return this.registry.lookupByName(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return (T)this.registry.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.registry.findByTypeWithName(type);
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.initCamelContext();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.getCamelContext() != null) {
            try {
                this.getCamelContext().start();
            }
            finally {
                if (this.getCamelContext().isVetoStarted()) {
                    this.completed();
                }
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.getCamelContext() != null) {
            this.getCamelContext().stop();
        }
    }

    @Override
    protected ProducerTemplate findOrCreateCamelTemplate() {
        if (this.getCamelContext() != null) {
            return this.getCamelContext().createProducerTemplate();
        }
        return null;
    }

    @Override
    protected CamelContext createCamelContext() {
        DefaultCamelContext answer = new DefaultCamelContext(false);
        answer.setRegistry((Registry)this.registry);
        return answer;
    }
}

