/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.CamelConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Configuration;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.PropertiesLookupListener;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StartupStep;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.main.DefaultConfigurationConfigurer;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.main.HealthConfigurationProperties;
import org.apache.camel.main.MainAutowiredLifecycleStrategy;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainHelper;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainRoutesLoader;
import org.apache.camel.main.MainSupportModelConfigurer;
import org.apache.camel.main.PropertiesRouteTemplateParametersSource;
import org.apache.camel.main.PropertyOptionKey;
import org.apache.camel.main.RestConfigurationProperties;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.spi.AutowiredLifecycleStrategy;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RouteTemplateParameterSource;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultContextReloadStrategy;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.startup.LoggingStartupStepRecorder;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.LocationHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.vault.VaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMainSupport
extends BaseService {
    public static final String DEFAULT_PROPERTY_PLACEHOLDER_LOCATION = "classpath:application.properties;optional=true";
    public static final String INITIAL_PROPERTIES_LOCATION = "camel.main.initial-properties-location";
    public static final String OVERRIDE_PROPERTIES_LOCATION = "camel.main.override-properties-location";
    public static final String PROPERTY_PLACEHOLDER_LOCATION = "camel.main.property-placeholder-location";
    private static final Logger LOG = LoggerFactory.getLogger(BaseMainSupport.class);
    protected final List<MainListener> listeners = new ArrayList<MainListener>();
    protected volatile CamelContext camelContext;
    protected MainConfigurationProperties mainConfigurationProperties = new MainConfigurationProperties();
    protected OrderedLocationProperties wildcardProperties = new OrderedLocationProperties();
    protected RoutesCollector routesCollector = new DefaultRoutesCollector();
    protected String propertyPlaceholderLocations;
    protected String defaultPropertyPlaceholderLocation = "classpath:application.properties;optional=true";
    protected Properties initialProperties;
    protected Properties overrideProperties;
    protected boolean standalone = true;
    protected final MainHelper helper;

    protected BaseMainSupport() {
        this.helper = new MainHelper();
    }

    protected BaseMainSupport(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.helper = new MainHelper();
    }

    public MainConfigurationProperties configure() {
        return this.mainConfigurationProperties;
    }

    public RoutesCollector getRoutesCollector() {
        return this.routesCollector;
    }

    public void setRoutesCollector(RoutesCollector routesCollector) {
        this.routesCollector = routesCollector;
    }

    public String getPropertyPlaceholderLocations() {
        return this.propertyPlaceholderLocations;
    }

    public void setPropertyPlaceholderLocations(String location) {
        this.propertyPlaceholderLocations = location;
    }

    public String getDefaultPropertyPlaceholderLocation() {
        return this.defaultPropertyPlaceholderLocation;
    }

    public void setDefaultPropertyPlaceholderLocation(String defaultPropertyPlaceholderLocation) {
        this.defaultPropertyPlaceholderLocation = defaultPropertyPlaceholderLocation;
    }

    public Properties getInitialProperties() {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public void setInitialProperties(Map<String, Object> initialProperties) {
        this.initialProperties = new OrderedProperties();
        this.initialProperties.putAll(initialProperties);
    }

    public void addProperty(String key, String value) {
        this.addInitialProperty(key, value);
    }

    public void addInitialProperty(String key, String value) {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        this.initialProperties.setProperty(key, value);
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public void setOverrideProperties(Map<String, Object> initialProperties) {
        this.overrideProperties = new OrderedProperties();
        this.overrideProperties.putAll(initialProperties);
    }

    public void addOverrideProperty(String key, String value) {
        if (this.overrideProperties == null) {
            this.overrideProperties = new OrderedProperties();
        }
        this.overrideProperties.setProperty(key, value);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void addMainListener(MainListener listener) {
        this.listeners.add(listener);
    }

    public void removeMainListener(MainListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - void declaration
     */
    protected void loadConfigurations(CamelContext camelContext) throws Exception {
        String basePackage = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBasePackageScan();
        if (basePackage != null) {
            PackageScanClassResolver pscr = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPackageScanClassResolver();
            Set set = pscr.findImplementations(CamelConfiguration.class, new String[]{basePackage});
            Set found2 = pscr.findAnnotated(Configuration.class, new String[]{basePackage});
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            linkedHashSet.addAll(set);
            linkedHashSet.addAll(found2);
            for (Class clazz : linkedHashSet) {
                Object config = camelContext.getInjector().newInstance(clazz);
                if (!(config instanceof CamelConfiguration)) continue;
                LOG.debug("Discovered CamelConfiguration class: {}", (Object)clazz);
                CamelConfiguration cc = (CamelConfiguration)config;
                this.mainConfigurationProperties.addConfiguration(cc);
            }
        }
        if (this.mainConfigurationProperties.getConfigurationClasses() != null) {
            void var6_12;
            String[] configClasses;
            String[] stringArray = configClasses = this.mainConfigurationProperties.getConfigurationClasses().split(",");
            int n = stringArray.length;
            boolean bl = false;
            while (var6_12 < n) {
                String configClass = stringArray[var6_12];
                Class configClazz = camelContext.getClassResolver().resolveClass(configClass, CamelConfiguration.class);
                boolean mainClass = false;
                try {
                    configClazz.getDeclaredMethod("main", String[].class);
                    mainClass = true;
                }
                catch (NoSuchMethodException cc) {
                    // empty catch block
                }
                if (!mainClass) {
                    CamelConfiguration config = (CamelConfiguration)camelContext.getInjector().newInstance(configClazz);
                    this.mainConfigurationProperties.addConfiguration(config);
                }
                ++var6_12;
            }
        }
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        Set set = camelContext.getRegistry().findByType(CamelConfiguration.class);
        for (CamelConfiguration camelConfiguration : set) {
            postProcessor.postProcessBeforeInitialization((Object)camelConfiguration, camelConfiguration.getClass().getName());
            postProcessor.postProcessAfterInitialization((Object)camelConfiguration, camelConfiguration.getClass().getName());
        }
        for (Object object : this.mainConfigurationProperties.getConfigurations()) {
            postProcessor.postProcessBeforeInitialization(object, object.getClass().getName());
            postProcessor.postProcessAfterInitialization(object, object.getClass().getName());
        }
        for (CamelConfiguration camelConfiguration : this.mainConfigurationProperties.getConfigurations()) {
            camelConfiguration.configure(camelContext);
        }
        for (CamelConfiguration camelConfiguration : set) {
            camelConfiguration.configure(camelContext);
        }
    }

    protected void configurePropertiesService(CamelContext camelContext) throws Exception {
        Optional<String> location;
        Properties op;
        Optional<String> location2;
        Properties ip;
        PropertiesComponent pc = camelContext.getPropertiesComponent();
        if (pc.getLocations().isEmpty()) {
            String locations = this.propertyPlaceholderLocations;
            if (locations == null) {
                locations = MainHelper.lookupPropertyFromSysOrEnv(PROPERTY_PLACEHOLDER_LOCATION).orElse(this.defaultPropertyPlaceholderLocation);
            }
            if (locations != null) {
                locations = locations.trim();
            }
            if (!Objects.equals(locations, "false")) {
                pc.addLocation(locations);
                if (DEFAULT_PROPERTY_PLACEHOLDER_LOCATION.equals(locations)) {
                    LOG.debug("Using properties from: {}", (Object)locations);
                } else {
                    LOG.info("Using properties from: {}", (Object)locations);
                }
            }
        }
        if (((ip = this.initialProperties) == null || ip.isEmpty()) && (location2 = MainHelper.lookupPropertyFromSysOrEnv(INITIAL_PROPERTIES_LOCATION)).isPresent()) {
            try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)location2.get());){
                ip = new Properties();
                ip.load(is);
            }
        }
        if (ip != null) {
            pc.setInitialProperties(ip);
        }
        if (((op = this.overrideProperties) == null || op.isEmpty()) && (location = MainHelper.lookupPropertyFromSysOrEnv(OVERRIDE_PROPERTIES_LOCATION)).isPresent()) {
            try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)location.get());){
                op = new Properties();
                op.load(is);
            }
        }
        if (op != null) {
            pc.setOverrideProperties(op);
        }
    }

    protected void configureLifecycle(CamelContext camelContext) throws Exception {
    }

    protected void configureVault(CamelContext camelContext) throws Exception {
        PeriodTaskScheduler scheduler;
        DefaultContextReloadStrategy reloader;
        Runnable r;
        long period;
        Optional task;
        VaultConfiguration vc = camelContext.getVaultConfiguration();
        if (vc == null) {
            return;
        }
        if (vc.aws().isRefreshEnabled() && (task = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPeriodTaskResolver().newInstance("aws-secret-refresh", Runnable.class)).isPresent()) {
            period = vc.aws().getRefreshPeriod();
            r = (Runnable)task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration((long)period, (boolean)false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader = new DefaultContextReloadStrategy();
                camelContext.addService((Object)reloader);
            }
            scheduler = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getPeriodTaskScheduler();
            scheduler.schedulePeriodTask(r, period);
        }
        if (vc.gcp().isRefreshEnabled() && (task = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPeriodTaskResolver().newInstance("gcp-secret-refresh", Runnable.class)).isPresent()) {
            period = vc.gcp().getRefreshPeriod();
            r = (Runnable)task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration((long)period, (boolean)false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader = new DefaultContextReloadStrategy();
                camelContext.addService((Object)reloader);
            }
            scheduler = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getPeriodTaskScheduler();
            scheduler.schedulePeriodTask(r, period);
        }
        if (vc.azure().isRefreshEnabled() && (task = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPeriodTaskResolver().newInstance("azure-secret-refresh", Runnable.class)).isPresent()) {
            period = vc.azure().getRefreshPeriod();
            r = (Runnable)task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration((long)period, (boolean)false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader = new DefaultContextReloadStrategy();
                camelContext.addService((Object)reloader);
            }
            scheduler = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getPeriodTaskScheduler();
            scheduler.schedulePeriodTask(r, period);
        }
    }

    protected void autoconfigure(CamelContext camelContext) throws Exception {
        OrderedLocationProperties autoConfiguredProperties = new OrderedLocationProperties();
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFailFast(camelContext, autoConfiguredProperties);
            this.autoConfigurationPropertiesComponent(camelContext, autoConfiguredProperties);
            this.autoConfigurationSingleOption(camelContext, autoConfiguredProperties, "camel.main.routesIncludePattern", value -> {
                this.mainConfigurationProperties.setRoutesIncludePattern((String)value);
                return null;
            });
            this.autoConfigurationSingleOption(camelContext, autoConfiguredProperties, "camel.main.routesCompileDirectory", value -> {
                this.mainConfigurationProperties.setRoutesCompileDirectory((String)value);
                return null;
            });
            this.autoConfigurationSingleOption(camelContext, autoConfiguredProperties, "camel.main.routesCompileLoadFirst", value -> {
                boolean bool = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)value);
                this.mainConfigurationProperties.setRoutesCompileLoadFirst(bool);
                return null;
            });
            if (camelContext.isModeline().booleanValue() || this.mainConfigurationProperties.isModeline()) {
                this.modelineRoutes(camelContext);
            }
            this.autoConfigurationMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        }
        this.doConfigureCamelContextFromMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        this.loadConfigurations(camelContext);
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFromProperties(camelContext, autoConfiguredProperties);
            this.autowireWildcardProperties(camelContext);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
            boolean header = false;
            for (Map.Entry entry : autoConfiguredProperties.entrySet()) {
                String k = entry.getKey().toString();
                Object v = entry.getValue();
                String loc = LocationHelper.locationSummary((OrderedLocationProperties)autoConfiguredProperties, (String)k);
                boolean debug = loc.contains("[camel-main]");
                if (debug && !LOG.isDebugEnabled()) continue;
                if (!header) {
                    LOG.info("Auto-configuration summary");
                    header = true;
                }
                if (SensitiveUtils.containsSensitive((String)k)) {
                    if (debug) {
                        LOG.debug("    {} {}=xxxxxx", (Object)loc, (Object)k);
                        continue;
                    }
                    LOG.info("    {} {}=xxxxxx", (Object)loc, (Object)k);
                    continue;
                }
                if (debug) {
                    LOG.debug("    {} {}={}", new Object[]{loc, k, v});
                    continue;
                }
                LOG.info("    {} {}={}", new Object[]{loc, k, v});
            }
        }
        this.helper.bootstrapDone();
    }

    protected void configureStartupRecorder(CamelContext camelContext) {
        StartupStepRecorder fr;
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        Object value = prop.remove("camel.main.startupRecorder");
        if (ObjectHelper.isNotEmpty((Object)value)) {
            this.mainConfigurationProperties.setStartupRecorder(value.toString());
        }
        if (ObjectHelper.isNotEmpty((Object)(value = prop.remove("camel.main.startupRecorderRecording")))) {
            this.mainConfigurationProperties.setStartupRecorderRecording("true".equalsIgnoreCase(value.toString()));
        }
        if (ObjectHelper.isNotEmpty((Object)(value = prop.remove("camel.main.startupRecorderProfile")))) {
            this.mainConfigurationProperties.setStartupRecorderProfile(CamelContextHelper.parseText((CamelContext)camelContext, (String)value.toString()));
        }
        if (ObjectHelper.isNotEmpty((Object)(value = prop.remove("camel.main.startupRecorderDuration")))) {
            this.mainConfigurationProperties.setStartupRecorderDuration(Long.parseLong(value.toString()));
        }
        if (ObjectHelper.isNotEmpty((Object)(value = prop.remove("camel.main.startupRecorderMaxDepth")))) {
            this.mainConfigurationProperties.setStartupRecorderMaxDepth(Integer.parseInt(value.toString()));
        }
        if ("off".equals(this.mainConfigurationProperties.getStartupRecorder()) || "false".equals(this.mainConfigurationProperties.getStartupRecorder())) {
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getStartupStepRecorder().setEnabled(false);
        } else if ("logging".equals(this.mainConfigurationProperties.getStartupRecorder())) {
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setStartupStepRecorder((StartupStepRecorder)new LoggingStartupStepRecorder());
        } else if (("jfr".equals(this.mainConfigurationProperties.getStartupRecorder()) || "java-flight-recorder".equals(this.mainConfigurationProperties.getStartupRecorder()) || this.mainConfigurationProperties.getStartupRecorder() == null) && (fr = (StartupStepRecorder)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBootstrapFactoryFinder().newInstance("startup-step-recorder", StartupStepRecorder.class).orElse(null)) != null) {
            LOG.debug("Discovered startup recorder: {} from classpath", (Object)fr);
            fr.setRecording(this.mainConfigurationProperties.isStartupRecorderRecording());
            fr.setStartupRecorderDuration(this.mainConfigurationProperties.getStartupRecorderDuration());
            fr.setRecordingProfile(this.mainConfigurationProperties.getStartupRecorderProfile());
            fr.setMaxDepth(this.mainConfigurationProperties.getStartupRecorderMaxDepth());
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setStartupStepRecorder(fr);
        }
    }

    protected void configurePackageScan(CamelContext camelContext) {
        if (this.mainConfigurationProperties.isBasePackageScanEnabled()) {
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setBasePackageScan(this.mainConfigurationProperties.getBasePackageScan());
            if (this.mainConfigurationProperties.getBasePackageScan() != null) {
                LOG.info("Classpath scanning enabled from base package: {}", (Object)this.mainConfigurationProperties.getBasePackageScan());
            }
        }
    }

    protected void configureRoutesLoader(CamelContext camelContext) {
        ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setRoutesLoader((RoutesLoader)new MainRoutesLoader(this.mainConfigurationProperties));
    }

    protected void modelineRoutes(CamelContext camelContext) throws Exception {
        RoutesConfigurer configurer = new RoutesConfigurer();
        if (this.mainConfigurationProperties.isRoutesCollectorEnabled()) {
            configurer.setRoutesCollector(this.routesCollector);
        }
        configurer.setBeanPostProcessor(((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor());
        configurer.setRoutesBuilders(this.mainConfigurationProperties.getRoutesBuilders());
        configurer.setRoutesBuilderClasses(this.mainConfigurationProperties.getRoutesBuilderClasses());
        if (this.mainConfigurationProperties.isBasePackageScanEnabled()) {
            configurer.setBasePackageScan(this.mainConfigurationProperties.getBasePackageScan());
        }
        configurer.setJavaRoutesExcludePattern(this.mainConfigurationProperties.getJavaRoutesExcludePattern());
        configurer.setJavaRoutesIncludePattern(this.mainConfigurationProperties.getJavaRoutesIncludePattern());
        configurer.setRoutesExcludePattern(this.mainConfigurationProperties.getRoutesExcludePattern());
        configurer.setRoutesIncludePattern(this.mainConfigurationProperties.getRoutesIncludePattern());
        configurer.configureModeline(camelContext);
    }

    protected void configureRoutes(CamelContext camelContext) throws Exception {
        RoutesConfigurer configurer = new RoutesConfigurer();
        if (this.mainConfigurationProperties.isRoutesCollectorEnabled()) {
            configurer.setRoutesCollector(this.routesCollector);
        }
        configurer.setBeanPostProcessor(((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor());
        configurer.setRoutesBuilders(this.mainConfigurationProperties.getRoutesBuilders());
        configurer.setRoutesBuilderClasses(this.mainConfigurationProperties.getRoutesBuilderClasses());
        if (this.mainConfigurationProperties.isBasePackageScanEnabled()) {
            configurer.setBasePackageScan(this.mainConfigurationProperties.getBasePackageScan());
        }
        configurer.setJavaRoutesExcludePattern(this.mainConfigurationProperties.getJavaRoutesExcludePattern());
        configurer.setJavaRoutesIncludePattern(this.mainConfigurationProperties.getJavaRoutesIncludePattern());
        configurer.setRoutesExcludePattern(this.mainConfigurationProperties.getRoutesExcludePattern());
        configurer.setRoutesIncludePattern(this.mainConfigurationProperties.getRoutesIncludePattern());
        configurer.configureRoutes(camelContext);
    }

    protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        StartupStep step;
        final OrderedLocationProperties propertyPlaceholders = new OrderedLocationProperties();
        camelContext.getLifecycleStrategies().removeIf(s -> s instanceof AutowiredLifecycleStrategy);
        camelContext.addLifecycleStrategy((LifecycleStrategy)new MainAutowiredLifecycleStrategy(camelContext));
        this.configurePropertiesService(camelContext);
        PropertiesComponent pc = camelContext.getPropertiesComponent();
        pc.addPropertiesLookupListener((PropertiesLookupListener)new PropertyPlaceholderListener(propertyPlaceholders));
        this.configureStartupRecorder(camelContext);
        this.configurePackageScan(camelContext);
        this.configureRoutesLoader(camelContext);
        camelContext.build();
        for (MainListener listener : this.listeners) {
            listener.beforeInitialize(this);
        }
        for (MainListener listener : this.listeners) {
            listener.beforeConfigure(this);
        }
        StartupStepRecorder recorder = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getStartupStepRecorder();
        if (this.standalone) {
            step = recorder.beginStep(BaseMainSupport.class, "autoconfigure", "Auto Configure");
            this.autoconfigure(camelContext);
            recorder.endStep(step);
        }
        this.configureLifecycle(camelContext);
        this.configureVault(camelContext);
        if (this.standalone) {
            step = recorder.beginStep(BaseMainSupport.class, "configureRoutes", "Collect Routes");
            this.configureRoutes(camelContext);
            recorder.endStep(step);
        }
        for (MainListener listener : this.listeners) {
            listener.afterConfigure(this);
            listener.configure(camelContext);
        }
        if (this.standalone && this.mainConfigurationProperties.isAutoConfigurationLogSummary()) {
            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new SimpleEventNotifierSupport(){

                public boolean isEnabled(CamelEvent event) {
                    return event instanceof CamelEvent.CamelContextRoutesStartedEvent;
                }

                public void notify(CamelEvent event) throws Exception {
                    if (!propertyPlaceholders.isEmpty()) {
                        LOG.info("Property-placeholders summary");
                        for (Map.Entry entry : propertyPlaceholders.entrySet()) {
                            String k = entry.getKey().toString();
                            Object v = entry.getValue();
                            Object dv = propertyPlaceholders.getDefaultValue((Object)k);
                            boolean same = ObjectHelper.equal(v, (Object)dv);
                            boolean skip = "templateId".equals(k);
                            if (same || skip) continue;
                            String loc = LocationHelper.locationSummary((OrderedLocationProperties)propertyPlaceholders, (String)k);
                            if (SensitiveUtils.containsSensitive((String)k)) {
                                LOG.info("    {} {}=xxxxxx", (Object)loc, (Object)k);
                                continue;
                            }
                            LOG.info("    {} {}={}", new Object[]{loc, k, v});
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void autoConfigurationFailFast(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Object val;
        Object failFast;
        Object jvmEnabled;
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        LOG.debug("Properties from Camel properties component:");
        for (String key : prop.stringPropertyNames()) {
            LOG.debug("    {}={}", (Object)key, (Object)prop.getProperty(key));
        }
        Object envEnabled = prop.remove((Object)"camel.main.autoConfigurationEnvironmentVariablesEnabled");
        if (ObjectHelper.isNotEmpty((Object)envEnabled)) {
            this.mainConfigurationProperties.setAutoConfigurationEnvironmentVariablesEnabled(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)envEnabled.toString()));
            String loc = prop.getLocation((Object)"camel.main.autoConfigurationEnvironmentVariablesEnabled");
            autoConfiguredProperties.put(loc, (Object)"camel.main.autoConfigurationEnvironmentVariablesEnabled", (Object)envEnabled.toString());
        }
        if (ObjectHelper.isNotEmpty((Object)(jvmEnabled = prop.remove((Object)"camel.main.autoConfigurationSystemPropertiesEnabled")))) {
            this.mainConfigurationProperties.setAutoConfigurationSystemPropertiesEnabled(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)jvmEnabled.toString()));
            String loc = prop.getLocation((Object)"camel.main.autoConfigurationSystemPropertiesEnabled");
            autoConfiguredProperties.put(loc, (Object)"camel.autoConfigurationSystemPropertiesEnabled", (Object)jvmEnabled.toString());
        }
        Properties propENV = null;
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map)propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String string : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)string, (Object)propENV.getProperty(string));
            }
        }
        Properties propJVM = null;
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map)propJVM);
            LOG.debug("Properties from JVM system properties:");
            for (String key : propJVM.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
            }
        }
        String string = "ENV";
        Object object = failFast = propENV != null ? propENV.remove("camel.main.autoconfigurationfailfast") : null;
        if (ObjectHelper.isNotEmpty((Map)propJVM) && ObjectHelper.isNotEmpty((Object)(val = propJVM.remove("camel.main.autoconfigurationfailfast")))) {
            String string2 = "SYS";
            failFast = val;
        }
        if (ObjectHelper.isNotEmpty((Object)failFast)) {
            void var8_13;
            this.mainConfigurationProperties.setAutoConfigurationFailFast(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)failFast.toString()));
            autoConfiguredProperties.put((String)var8_13, (Object)"camel.main.autoConfigurationFailFast", (Object)failFast.toString());
        } else {
            String string3 = prop.getLocation((Object)"camel.main.autoConfigurationFailFast");
            failFast = prop.remove((Object)"camel.main.autoConfigurationFailFast");
            if (ObjectHelper.isNotEmpty((Object)failFast)) {
                this.mainConfigurationProperties.setAutoConfigurationFailFast(CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)failFast.toString()));
                autoConfiguredProperties.put(string3, (Object)"camel.main.autoConfigurationFailFast", (Object)failFast.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void autoConfigurationSingleOption(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties, String optionName, Function<String, Object> setter) {
        Object val;
        Object value;
        String lowerOptionName = optionName.toLowerCase(Locale.US);
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        LOG.debug("Properties from Camel properties component:");
        for (Object key : prop.stringPropertyNames()) {
            LOG.debug("    {}={}", key, (Object)prop.getProperty((String)key));
        }
        Properties propENV = null;
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll("ENV", propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String string : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)string, (Object)propENV.getProperty(string));
            }
        }
        Properties propJVM = null;
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
            LOG.debug("Properties from JVM system properties:");
            for (String key : propJVM.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
            }
        }
        String string = "ENV";
        Object object = value = propENV != null ? propENV.remove(lowerOptionName) : null;
        if (ObjectHelper.isNotEmpty((Map)propJVM) && ObjectHelper.isNotEmpty((Object)(val = propJVM.remove(optionName)))) {
            String string2 = "SYS";
            value = val;
        }
        if (ObjectHelper.isEmpty((Object)value)) {
            String string3 = prop.getLocation((Object)optionName);
            value = prop.remove((Object)optionName);
        }
        if (ObjectHelper.isEmpty((Object)value)) {
            value = this.getInitialProperties().getProperty(optionName);
            String string4 = "initial";
        }
        if (ObjectHelper.isNotEmpty((Object)value)) {
            void var9_18;
            String str = CamelContextHelper.parseText((CamelContext)camelContext, (String)value.toString());
            setter.apply(str);
            autoConfiguredProperties.put((String)var9_18, (Object)optionName, (Object)value.toString());
        }
    }

    protected void doConfigureCamelContextFromMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        boolean hc;
        Properties propJVM;
        Properties propENV;
        if (ObjectHelper.isNotEmpty((String)config.getFileConfigurations())) {
            String[] locs;
            for (String loc : locs = config.getFileConfigurations().split(",")) {
                String pattern;
                File[] files;
                String path = FileUtil.onlyPath((String)loc);
                if (path == null || (files = new File(path).listFiles(arg_0 -> BaseMainSupport.lambda$doConfigureCamelContextFromMainConfiguration$7(pattern = loc.length() > path.length() ? loc.substring(path.length() + 1) : null, arg_0))) == null) continue;
                for (File file : files) {
                    Properties props = new Properties();
                    try (FileInputStream is = new FileInputStream(file);){
                        props.load(is);
                    }
                    if (props.isEmpty()) continue;
                    if (this.overrideProperties == null) {
                        this.overrideProperties = new Properties();
                        PropertiesComponent pc = camelContext.getPropertiesComponent();
                        pc.setOverrideProperties(this.overrideProperties);
                    }
                    LOG.info("Loaded additional {} properties from file: {}", (Object)props.size(), (Object)file);
                    this.overrideProperties.putAll((Map<?, ?>)props);
                }
            }
        }
        DefaultConfigurationConfigurer.configure(camelContext, config);
        DefaultConfigurationConfigurer.afterConfigure(camelContext);
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll("ENV", propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String key : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
            LOG.debug("Properties from JVM system properties:");
            for (String key : propJVM.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
            }
        }
        OrderedLocationProperties contextProperties = new OrderedLocationProperties();
        OrderedLocationProperties resilience4jProperties = new OrderedLocationProperties();
        OrderedLocationProperties faultToleranceProperties = new OrderedLocationProperties();
        OrderedLocationProperties restProperties = new OrderedLocationProperties();
        OrderedLocationProperties vaultProperties = new OrderedLocationProperties();
        OrderedLocationProperties threadPoolProperties = new OrderedLocationProperties();
        OrderedLocationProperties healthProperties = new OrderedLocationProperties();
        OrderedLocationProperties lraProperties = new OrderedLocationProperties();
        OrderedLocationProperties routeTemplateProperties = new OrderedLocationProperties();
        OrderedLocationProperties beansProperties = new OrderedLocationProperties();
        OrderedLocationProperties devConsoleProperties = new OrderedLocationProperties();
        OrderedLocationProperties globalOptions = new OrderedLocationProperties();
        for (String key : prop.stringPropertyNames()) {
            String option;
            String value;
            String loc = prop.getLocation((Object)key);
            if (key.startsWith("camel.context.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                MainHelper.validateOptionAndValue(key, option, value);
                contextProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (key.startsWith("camel.resilience4j.")) {
                value = prop.getProperty(key);
                option = key.substring(19);
                MainHelper.validateOptionAndValue(key, option, value);
                resilience4jProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (key.startsWith("camel.faulttolerance.")) {
                value = prop.getProperty(key);
                option = key.substring(21);
                MainHelper.validateOptionAndValue(key, option, value);
                faultToleranceProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (key.startsWith("camel.rest.")) {
                value = prop.getProperty(key);
                option = key.substring(11);
                MainHelper.validateOptionAndValue(key, option, value);
                restProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (key.startsWith("camel.vault.")) {
                value = prop.getProperty(key);
                option = key.substring(12);
                MainHelper.validateOptionAndValue(key, option, value);
                vaultProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (key.startsWith("camel.threadpool.")) {
                value = prop.getProperty(key);
                option = key.substring(17);
                MainHelper.validateOptionAndValue(key, option, value);
                threadPoolProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (key.startsWith("camel.health.")) {
                value = prop.getProperty(key);
                option = key.substring(13);
                MainHelper.validateOptionAndValue(key, option, value);
                healthProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (key.startsWith("camel.lra.")) {
                value = prop.getProperty(key);
                option = key.substring(10);
                MainHelper.validateOptionAndValue(key, option, value);
                lraProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (key.startsWith("camel.routeTemplate")) {
                value = prop.getProperty(key);
                option = key.substring(19);
                MainHelper.validateOptionAndValue(key, option, value);
                routeTemplateProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (key.startsWith("camel.devConsole.")) {
                value = prop.getProperty(key);
                option = key.substring(17);
                MainHelper.validateOptionAndValue(key, option, value);
                devConsoleProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (key.startsWith("camel.beans.")) {
                value = prop.getProperty(key);
                option = key.substring(12);
                MainHelper.validateOptionAndValue(key, option, value);
                beansProperties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
                continue;
            }
            if (!key.startsWith("camel.globalOptions.")) continue;
            value = prop.getProperty(key);
            option = key.substring(20);
            MainHelper.validateOptionAndValue(key, option, value);
            globalOptions.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
        }
        if (!globalOptions.isEmpty()) {
            for (String name2 : globalOptions.stringPropertyNames()) {
                String value = globalOptions.getProperty(name2);
                this.mainConfigurationProperties.addGlobalOption(name2, value);
            }
        }
        if (!beansProperties.isEmpty()) {
            LOG.debug("Creating and binding beans to registry from loaded properties: {}", (Object)beansProperties.size());
            this.bindBeansToRegistry(camelContext, beansProperties, "camel.beans.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), this.mainConfigurationProperties.isAutoConfigurationLogSummary(), true, autoConfiguredProperties);
        }
        if (!contextProperties.isEmpty()) {
            LOG.debug("Auto-configuring CamelContext from loaded properties: {}", (Object)contextProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, camelContext, contextProperties, "camel.context.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!restProperties.isEmpty() || this.mainConfigurationProperties.hasRestConfiguration()) {
            RestConfigurationProperties rest = this.mainConfigurationProperties.rest();
            LOG.debug("Auto-configuring Rest DSL from loaded properties: {}", (Object)restProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, (Object)rest, restProperties, "camel.rest.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            camelContext.setRestConfiguration((RestConfiguration)rest);
        }
        if (!vaultProperties.isEmpty() || this.mainConfigurationProperties.hasVaultConfiguration()) {
            LOG.debug("Auto-configuring Vault from loaded properties: {}", (Object)vaultProperties.size());
            this.setVaultProperties(camelContext, vaultProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!threadPoolProperties.isEmpty() || this.mainConfigurationProperties.hasThreadPoolConfiguration()) {
            LOG.debug("Auto-configuring Thread Pool from loaded properties: {}", (Object)threadPoolProperties.size());
            MainSupportModelConfigurer.setThreadPoolProperties(camelContext, this.mainConfigurationProperties, threadPoolProperties, autoConfiguredProperties);
        }
        boolean bl = hc = this.mainConfigurationProperties.health().getEnabled() != null;
        if (hc || !healthProperties.isEmpty() || this.mainConfigurationProperties.hasHealthCheckConfiguration()) {
            LOG.debug("Auto-configuring HealthCheck from loaded properties: {}", (Object)healthProperties.size());
            this.setHealthCheckProperties(camelContext, healthProperties, autoConfiguredProperties);
        }
        if (!routeTemplateProperties.isEmpty()) {
            LOG.debug("Auto-configuring Route templates from loaded properties: {}", (Object)routeTemplateProperties.size());
            this.setRouteTemplateProperties(camelContext, routeTemplateProperties, autoConfiguredProperties);
        }
        if (!lraProperties.isEmpty() || this.mainConfigurationProperties.hasLraConfiguration()) {
            LOG.debug("Auto-configuring Saga LRA from loaded properties: {}", (Object)lraProperties.size());
            this.setLraCheckProperties(camelContext, lraProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!devConsoleProperties.isEmpty()) {
            LOG.debug("Auto-configuring Dev Console from loaded properties: {}", (Object)devConsoleProperties.size());
            this.setDevConsoleProperties(camelContext, devConsoleProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        MainSupportModelConfigurer.configureModelCamelContext(camelContext, this.mainConfigurationProperties, autoConfiguredProperties, resilience4jProperties, faultToleranceProperties);
        if (!beansProperties.isEmpty()) {
            beansProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.beans.{}={}", k, v));
        }
        if (!contextProperties.isEmpty()) {
            contextProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.context.{}={}", k, v));
        }
        if (!resilience4jProperties.isEmpty()) {
            resilience4jProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.resilience4j.{}={}", k, v));
        }
        if (!faultToleranceProperties.isEmpty()) {
            faultToleranceProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.faulttolerance.{}={}", k, v));
        }
        if (!restProperties.isEmpty()) {
            restProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.rest.{}={}", k, v));
        }
        if (!vaultProperties.isEmpty()) {
            vaultProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.vault.{}={}", k, v));
        }
        if (!threadPoolProperties.isEmpty()) {
            threadPoolProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.threadpool.{}={}", k, v));
        }
        if (!healthProperties.isEmpty()) {
            healthProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.health.{}={}", k, v));
        }
        if (!routeTemplateProperties.isEmpty()) {
            routeTemplateProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.routetemplate.{}={}", k, v));
        }
        if (!lraProperties.isEmpty()) {
            lraProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.lra.{}={}", k, v));
        }
        DefaultConfigurationConfigurer.afterPropertiesSet(camelContext);
    }

    private void setRouteTemplateProperties(CamelContext camelContext, OrderedLocationProperties routeTemplateProperties, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        PropertiesRouteTemplateParametersSource source = new PropertiesRouteTemplateParametersSource();
        for (Map.Entry entry : routeTemplateProperties.entrySet()) {
            String key = entry.getKey().toString();
            String id = StringHelper.between((String)key, (String)"[", (String)"]");
            key = StringHelper.after((String)key, (String)"].");
            source.addParameter(id, key, entry.getValue());
        }
        camelContext.getRegistry().bind("CamelMainRouteTemplateParametersSource", RouteTemplateParameterSource.class, (Object)source);
        TreeMap<String, Object> sorted = new TreeMap<String, Object>(routeTemplateProperties.asMap());
        sorted.forEach((k, v) -> {
            String loc = routeTemplateProperties.getLocation(k);
            autoConfiguredProperties.put(loc, (Object)("camel.routeTemplate" + k), (Object)v.toString());
        });
        routeTemplateProperties.clear();
    }

    private void setHealthCheckProperties(CamelContext camelContext, OrderedLocationProperties healthCheckProperties, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        HealthCheck hc;
        HealthConfigurationProperties health = this.mainConfigurationProperties.health();
        MainHelper.setPropertiesOnTarget(camelContext, health, healthCheckProperties, "camel.health.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        if (health.getEnabled() != null && !health.getEnabled().booleanValue()) {
            return;
        }
        HealthCheckRegistry hcr = (HealthCheckRegistry)camelContext.getExtension(HealthCheckRegistry.class);
        if (hcr == null) {
            if (health.getEnabled() != null && health.getEnabled().booleanValue()) {
                LOG.warn("Cannot find HealthCheckRegistry from classpath. Add camel-health to classpath.");
            }
            return;
        }
        if (health.getEnabled() != null) {
            hcr.setEnabled(health.getEnabled().booleanValue());
        }
        if (health.getExcludePattern() != null) {
            hcr.setExcludePattern(health.getExcludePattern());
        }
        if (health.getExposureLevel() != null) {
            hcr.setExposureLevel(health.getExposureLevel());
        }
        if (health.getInitialState() != null) {
            hcr.setInitialState((HealthCheck.State)camelContext.getTypeConverter().convertTo(HealthCheck.State.class, (Object)health.getInitialState()));
        }
        if (hcr.isEnabled() && (hc = (HealthCheck)hcr.resolveById("context")) != null) {
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("routes").orElse((HealthCheckRepository)hcr.resolveById("routes"))) != null) {
            if (health.getRoutesEnabled() != null) {
                hc.setEnabled(health.getRoutesEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("components").orElse((HealthCheckRepository)hcr.resolveById("components"))) != null) {
            if (health.getComponentsEnabled() != null) {
                hc.setEnabled(health.getComponentsEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("consumers").orElse((HealthCheckRepository)hcr.resolveById("consumers"))) != null) {
            if (health.getConsumersEnabled() != null) {
                hc.setEnabled(health.getConsumersEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("registry").orElse((HealthCheckRepository)hcr.resolveById("registry"))) != null) {
            if (health.getRegistryEnabled() != null) {
                hc.setEnabled(health.getRegistryEnabled().booleanValue());
            }
            hcr.register((Object)hc);
        }
    }

    private void setLraCheckProperties(CamelContext camelContext, OrderedLocationProperties lraProperties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        boolean enabled;
        Object obj = lraProperties.remove((Object)"enabled");
        if (ObjectHelper.isNotEmpty((Object)obj)) {
            String loc = lraProperties.getLocation((Object)"enabled");
            autoConfiguredProperties.put(loc, (Object)"camel.lra.enabled", (Object)obj.toString());
        }
        boolean bl = enabled = obj != null ? CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)obj.toString()) : true;
        if (enabled) {
            CamelSagaService css = BaseMainSupport.resolveLraSagaService(camelContext);
            MainHelper.setPropertiesOnTarget(camelContext, css, lraProperties, "camel.lra.", failIfNotSet, true, autoConfiguredProperties);
        }
    }

    private void setDevConsoleProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        LinkedHashSet keys = new LinkedHashSet(properties.keySet());
        for (String key : keys) {
            String name = StringHelper.before((String)key, (String)".");
            DevConsole console = ((DevConsoleRegistry)camelContext.getExtension(DevConsoleRegistry.class)).resolveById(name);
            if (console == null) {
                throw new IllegalArgumentException("Cannot resolve DevConsole with id: " + name);
            }
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + ".");
            MainHelper.setPropertiesOnTarget(camelContext, console, config, "camel.devConsole." + name + ".", failIfNotSet, true, autoConfiguredProperties);
        }
    }

    private void setVaultProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        if (this.mainConfigurationProperties.hasVaultConfiguration()) {
            camelContext.setVaultConfiguration((VaultConfiguration)this.mainConfigurationProperties.vault());
        }
        VaultConfiguration target = camelContext.getVaultConfiguration();
        LinkedHashSet keys = new LinkedHashSet(properties.keySet());
        for (String key : keys) {
            String name = StringHelper.before((String)key, (String)".");
            if ("aws".equalsIgnoreCase(name)) {
                target = target.aws();
            }
            if ("gcp".equalsIgnoreCase(name)) {
                target = target.gcp();
            }
            if ("azure".equalsIgnoreCase(name)) {
                target = target.azure();
            }
            if ("hashicorp".equalsIgnoreCase(name)) {
                target = target.hashicorp();
            }
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + ".");
            MainHelper.setPropertiesOnTarget(camelContext, target, config, "camel.vault." + name + ".", failIfNotSet, true, autoConfiguredProperties);
        }
    }

    private void bindBeansToRegistry(CamelContext camelContext, OrderedLocationProperties properties, String optionPrefix, boolean failIfNotSet, boolean logSummary, boolean ignoreCase, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        OrderedLocationProperties config;
        Object bean;
        LinkedHashSet keys = new LinkedHashSet(properties.keySet());
        Set beansDot = properties.keySet().stream().map(k -> StringHelper.before((String)k.toString(), (String)".", (String)k.toString())).filter(k -> k.indexOf(91) == -1).collect(Collectors.toSet());
        Set beansMap = properties.keySet().stream().map(k -> StringHelper.before((String)k.toString(), (String)"[", (String)k.toString())).filter(k -> k.indexOf(46) == -1).collect(Collectors.toSet());
        for (String key : keys) {
            if (key.indexOf(46) != -1 || key.indexOf(91) != -1) continue;
            String name = key;
            Object value = properties.remove((Object)key);
            Object bean2 = PropertyBindingSupport.resolveBean((CamelContext)camelContext, (Object)value);
            if (bean2 == null) {
                throw new IllegalArgumentException("Cannot create/resolve bean with name " + name + " from value: " + value);
            }
            if (logSummary) {
                LOG.info("Binding bean: {} (type: {}) to the registry", (Object)key, (Object)ObjectHelper.classCanonicalName((Object)bean2));
            } else {
                LOG.debug("Binding bean: {} (type: {}) to the registry", (Object)key, (Object)ObjectHelper.classCanonicalName((Object)bean2));
            }
            camelContext.getRegistry().bind(name, bean2);
        }
        for (String name : beansMap) {
            if (camelContext.getRegistry().lookupByName(name) != null) continue;
            bean = new LinkedHashMap();
            if (logSummary) {
                LOG.info("Binding bean: {} (type: {}) to the registry", (Object)name, (Object)ObjectHelper.classCanonicalName((Object)bean));
            } else {
                LOG.debug("Binding bean: {} (type: {}) to the registry", (Object)name, (Object)ObjectHelper.classCanonicalName((Object)bean));
            }
            camelContext.getRegistry().bind(name, bean);
        }
        for (String name : beansDot) {
            bean = camelContext.getRegistry().lookupByName(name);
            if (bean == null) {
                throw new IllegalArgumentException("Cannot resolve bean with name " + name);
            }
            config = MainHelper.extractProperties(properties, name + ".");
            MainHelper.setPropertiesOnTarget(camelContext, bean, config, optionPrefix + name + ".", failIfNotSet, ignoreCase, autoConfiguredProperties);
        }
        for (String name : beansMap) {
            bean = camelContext.getRegistry().lookupByName(name);
            if (bean == null) {
                throw new IllegalArgumentException("Cannot resolve bean with name " + name);
            }
            config = MainHelper.extractProperties(properties, name + "[", "]");
            MainHelper.setPropertiesOnTarget(camelContext, bean, config, optionPrefix + name + ".", failIfNotSet, ignoreCase, autoConfiguredProperties);
        }
    }

    protected void autoConfigurationPropertiesComponent(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Properties propJVM;
        Properties propENV;
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll("ENV", propENV);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
        }
        OrderedLocationProperties properties = new OrderedLocationProperties();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.component.properties.")) continue;
            int dot = key.indexOf(46, 26);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            MainHelper.validateOptionAndValue(key, option, value);
            String loc = prop.getLocation((Object)key);
            properties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring properties component from loaded properties: {}", (Object)properties.size());
            MainHelper.setPropertiesOnTarget(camelContext, camelContext.getPropertiesComponent(), properties, "camel.component.properties.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.component.properties.{}={} on object: {}", new Object[]{k, v, camelContext.getPropertiesComponent()}));
        }
    }

    protected void autoConfigurationMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Properties propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."});
            propENV.remove(INITIAL_PROPERTIES_LOCATION.replace('-', '.'));
            propENV.remove(OVERRIDE_PROPERTIES_LOCATION.replace('-', '.'));
            propENV.remove(PROPERTY_PLACEHOLDER_LOCATION.replace('-', '.'));
            if (!propENV.isEmpty()) {
                prop.putAll("ENV", propENV);
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled()) {
            Properties propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."});
            propJVM.remove(INITIAL_PROPERTIES_LOCATION);
            propJVM.remove(StringHelper.dashToCamelCase((String)INITIAL_PROPERTIES_LOCATION));
            propJVM.remove(OVERRIDE_PROPERTIES_LOCATION);
            propJVM.remove(StringHelper.dashToCamelCase((String)OVERRIDE_PROPERTIES_LOCATION));
            propJVM.remove(PROPERTY_PLACEHOLDER_LOCATION);
            propJVM.remove(StringHelper.dashToCamelCase((String)PROPERTY_PLACEHOLDER_LOCATION));
            if (!propJVM.isEmpty()) {
                prop.putAll("SYS", propJVM);
            }
        }
        OrderedLocationProperties properties = new OrderedLocationProperties();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.main.")) continue;
            String value = prop.getProperty(key);
            String option = key.substring(11);
            MainHelper.validateOptionAndValue(key, option, value);
            String loc = prop.getLocation((Object)key);
            properties.put(loc, (Object)MainHelper.optionKey(option), (Object)value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring main from loaded properties: {}", (Object)properties.size());
            MainHelper.setPropertiesOnTarget(camelContext, config, properties, "camel.main.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.main.{}={} on bean: {}", new Object[]{k, v, config}));
        }
    }

    protected void autoConfigurationFromProperties(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Properties propJVM;
        OrderedLocationProperties prop = new OrderedLocationProperties();
        OrderedLocationProperties propPC = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        prop.putAll(propPC);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Map<String, String> env = MainHelper.filterEnvVariables(new String[]{"camel.component.", "camel.dataformat.", "camel.language."});
            LOG.debug("Gathered {} ENV variables to configure components, dataformats, languages", (Object)env.size());
            OrderedProperties propENV = new OrderedProperties();
            this.helper.addComponentEnvVariables(env, (Properties)propENV, false);
            this.helper.addDataFormatEnvVariables(env, (Properties)propENV, false);
            this.helper.addLanguageEnvVariables(env, (Properties)propENV, false);
            if (!env.isEmpty()) {
                LOG.debug("Remaining {} ENV variables to configure custom components, dataformats, languages", (Object)env.size());
                this.helper.addComponentEnvVariables(env, (Properties)propENV, true);
                this.helper.addDataFormatEnvVariables(env, (Properties)propENV, true);
                this.helper.addLanguageEnvVariables(env, (Properties)propENV, true);
            }
            if (!propENV.isEmpty()) {
                prop.putAll("ENV", (Properties)propENV);
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.", "camel.dataformat.", "camel.language."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
        }
        LinkedHashMap<PropertyOptionKey, OrderedLocationProperties> properties = new LinkedHashMap<PropertyOptionKey, OrderedLocationProperties>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.contains("*")) continue;
            String loc = prop.getLocation((Object)key);
            this.wildcardProperties.put(loc, (Object)key, (Object)prop.getProperty(key));
        }
        for (String key : this.wildcardProperties.stringPropertyNames()) {
            prop.remove((Object)key);
        }
        for (String key : prop.stringPropertyNames()) {
            MainHelper.computeProperties("camel.component.", key, prop, properties, name -> {
                Component target = camelContext.getComponent(name);
                if (target == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find component with name " + name + ". Make sure you have the component on the classpath");
                }
                return Collections.singleton(target);
            });
            MainHelper.computeProperties("camel.dataformat.", key, prop, properties, name -> {
                DataFormat target = camelContext.resolveDataFormat(name);
                if (target == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find dataformat with name " + name + ". Make sure you have the dataformat on the classpath");
                }
                return Collections.singleton(target);
            });
            MainHelper.computeProperties("camel.language.", key, prop, properties, name -> {
                Language target;
                try {
                    target = camelContext.resolveLanguage(name);
                }
                catch (NoSuchLanguageException e) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find language with name " + name + ". Make sure you have the language on the classpath");
                }
                return Collections.singleton(target);
            });
        }
        if (!properties.isEmpty()) {
            long total = properties.values().stream().mapToLong(Map::size).sum();
            LOG.debug("Auto-configuring {} components/dataformat/languages from loaded properties: {}", (Object)properties.size(), (Object)total);
        }
        for (Map.Entry entry : properties.entrySet()) {
            MainHelper.setPropertiesOnTarget(camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (OrderedLocationProperties)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                PropertyOptionKey pok = (PropertyOptionKey)entry.getKey();
                OrderedLocationProperties values = (OrderedLocationProperties)entry.getValue();
                values.forEach((k, v) -> {
                    String stringValue = v != null ? v.toString() : null;
                    LOG.warn("Property ({}={}) not auto-configured with name: {} on bean: {} with value: {}", new Object[]{pok.getOptionPrefix() + "." + k, stringValue, k, pok.getInstance(), stringValue});
                });
            }
        }
    }

    protected void autowireWildcardProperties(CamelContext camelContext) {
        if (this.wildcardProperties.isEmpty()) {
            return;
        }
        for (String name : camelContext.getComponentNames()) {
            Component comp = camelContext.getComponent(name);
            this.doAutowireWildcardProperties(name, comp);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onComponentAdd(String name, Component component) {
                BaseMainSupport.this.doAutowireWildcardProperties(name, component);
            }
        });
    }

    protected void doAutowireWildcardProperties(String name, Component component) {
        LinkedHashMap<PropertyOptionKey, OrderedLocationProperties> properties = new LinkedHashMap<PropertyOptionKey, OrderedLocationProperties>();
        OrderedLocationProperties autoConfiguredProperties = new OrderedLocationProperties();
        String match = ("camel.component." + name).toLowerCase(Locale.ENGLISH);
        for (String string : this.wildcardProperties.stringPropertyNames()) {
            String mKey = string.substring(0, string.indexOf(42)).toLowerCase(Locale.ENGLISH);
            if (!match.startsWith(mKey)) continue;
            MainHelper.computeProperties("camel.component.", string, this.wildcardProperties, properties, s -> Collections.singleton(component));
        }
        try {
            for (Map.Entry entry : properties.entrySet()) {
                MainHelper.setPropertiesOnTarget(this.camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (OrderedLocationProperties)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            }
            if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
                boolean header = false;
                for (Map.Entry entry : autoConfiguredProperties.entrySet()) {
                    String k = entry.getKey().toString();
                    Object v = entry.getValue();
                    String loc = LocationHelper.locationSummary((OrderedLocationProperties)autoConfiguredProperties, (String)k);
                    boolean debug = loc.contains("[camel-main]");
                    if (debug && !LOG.isDebugEnabled()) continue;
                    if (!header) {
                        LOG.info("Auto-configuration component {} summary", (Object)name);
                        header = true;
                    }
                    if (SensitiveUtils.containsSensitive((String)k)) {
                        if (debug) {
                            LOG.debug("    {} {}=xxxxxx", (Object)loc, (Object)k);
                            continue;
                        }
                        LOG.info("    {} {}=xxxxxx", (Object)loc, (Object)k);
                        continue;
                    }
                    if (debug) {
                        LOG.debug("    {} {}={}", new Object[]{loc, k, v});
                        continue;
                    }
                    LOG.info("    {} {}={}", new Object[]{loc, k, v});
                }
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    private static CamelSagaService resolveLraSagaService(CamelContext camelContext) throws Exception {
        CamelSagaService answer = (CamelSagaService)camelContext.getRegistry().findSingleByType(CamelSagaService.class);
        if (answer == null) {
            answer = (CamelSagaService)((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBootstrapFactoryFinder().newInstance("lra-saga-service", CamelSagaService.class).orElseThrow(() -> new IllegalArgumentException("Cannot find LRASagaService on classpath. Add camel-lra to classpath."));
            camelContext.addService((Object)answer, true, false);
        }
        return answer;
    }

    private static /* synthetic */ boolean lambda$doConfigureCamelContextFromMainConfiguration$7(String pattern, File f) {
        return StringHelper.matches((String)pattern, (String)f.getName());
    }

    private static final class PropertyPlaceholderListener
    implements PropertiesLookupListener {
        private final OrderedLocationProperties olp;

        public PropertyPlaceholderListener(OrderedLocationProperties olp) {
            this.olp = olp;
        }

        public void onLookup(String name, String value, String defaultValue, String source) {
            if (source == null) {
                source = "unknown";
            }
            this.olp.put(source, (Object)name, (Object)value, (Object)defaultValue);
        }
    }
}

