/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoutesCollector
implements RoutesCollector {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Collection<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
        ArrayList<RoutesBuilder> routes = new ArrayList<RoutesBuilder>();
        AntPathMatcher matcher = new AntPathMatcher();
        Collection<RoutesBuilder> additional = this.collectAdditionalRoutesFromRegistry(camelContext, excludePattern, includePattern);
        if (additional != null) {
            routes.addAll(additional);
        }
        Collection<LambdaRouteBuilder> lrbs = this.findByType(camelContext, LambdaRouteBuilder.class);
        for (final LambdaRouteBuilder lrb : lrbs) {
            RouteBuilder rb = new RouteBuilder(){

                public void configure() throws Exception {
                    lrb.accept((Object)this);
                }
            };
            routes.add((RoutesBuilder)rb);
        }
        Collection<RoutesBuilder> builders = this.findByType(camelContext, RoutesBuilder.class);
        for (RoutesBuilder routesBuilder : builders) {
            String[] parts;
            boolean abs = Modifier.isAbstract(routesBuilder.getClass().getModifiers());
            if (abs) continue;
            String name = routesBuilder.getClass().getName();
            name = name.replace('.', '/');
            boolean match = !"false".equals(includePattern);
            String exclude = camelContext.getCamelContextExtension().getTestExcludeRoutes();
            if (match && ObjectHelper.isNotEmpty((String)exclude)) {
                exclude = exclude.replace('.', '/');
                for (String part : parts = exclude.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            if (match && ObjectHelper.isNotEmpty((String)excludePattern)) {
                for (String part : parts = excludePattern.split(",")) {
                    match = !matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                    if (!match) break;
                }
            }
            if (match && ObjectHelper.isNotEmpty((String)includePattern)) {
                for (String part : parts = includePattern.split(",")) {
                    match = matcher.match(part, name);
                    this.log.trace("Java RoutesBuilder: {} include filter: {} -> {}", new Object[]{name, part, match});
                    if (match) break;
                }
            }
            this.log.debug("Java RoutesBuilder: {} accepted by include/exclude filter: {}", (Object)name, (Object)match);
            if (!match) continue;
            routes.add(routesBuilder);
        }
        return routes;
    }

    @Override
    public Collection<RoutesBuilder> collectRoutesFromDirectory(CamelContext camelContext, String excludePattern, String includePattern) {
        ArrayList<RoutesBuilder> answer = new ArrayList<RoutesBuilder>();
        String[] includes = includePattern != null ? includePattern.split(",") : null;
        StopWatch watch = new StopWatch();
        Collection<Resource> accepted = this.findRouteResourcesFromDirectory(camelContext, excludePattern, includePattern);
        try {
            Collection builders = PluginHelper.getRoutesLoader((CamelContext)camelContext).findRoutesBuilders(accepted);
            if (!builders.isEmpty()) {
                this.log.debug("Found {} route builder from locations: {}", (Object)builders.size(), (Object)includes);
                answer.addAll(builders);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
        if (!answer.isEmpty()) {
            this.log.debug("Loaded {} ({} millis) additional RoutesBuilder from: {}, pattern: {}", new Object[]{answer.size(), watch.taken(), includes, includePattern});
        } else {
            this.log.debug("No additional RoutesBuilder discovered from: {}", (Object)includePattern);
        }
        return answer;
    }

    @Override
    public Collection<Resource> findRouteResourcesFromDirectory(CamelContext camelContext, String excludePattern, String includePattern) {
        String[] excludes;
        PackageScanResourceResolver resolver = PluginHelper.getPackageScanResourceResolver((CamelContext)camelContext);
        String[] includes = includePattern != null ? includePattern.split(",") : null;
        String[] stringArray = excludes = excludePattern != null ? excludePattern.split(",") : null;
        if (includes == null || ObjectHelper.equal((Object)"false", (Object)includePattern)) {
            this.log.debug("Include pattern is empty/false, no routes will be discovered from resources");
            return new ArrayList<Resource>();
        }
        ArrayList<Resource> accepted = new ArrayList<Resource>();
        for (String include : includes) {
            this.log.debug("Finding additional routes from: {}", (Object)include);
            try {
                for (Resource resource : resolver.findResources(include)) {
                    if (!"false".equals(excludePattern) && AntPathMatcher.INSTANCE.anyMatch(excludes, resource.getLocation())) continue;
                    accepted.add(resource);
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        return accepted;
    }

    protected Collection<RoutesBuilder> collectAdditionalRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
        return null;
    }

    protected <T> Collection<T> findByType(CamelContext camelContext, Class<T> type) {
        return camelContext.getRegistry().findByType(type);
    }
}

