/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import java.util.Date;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.mbean.ManagedCounterMBean;

public interface ManagedPerformanceCounterMBean
extends ManagedCounterMBean {
    @ManagedAttribute(description="Number of completed exchanges")
    public long getExchangesCompleted();

    @ManagedAttribute(description="Number of failed exchanges")
    public long getExchangesFailed();

    @ManagedAttribute(description="Number of inflight exchanges")
    public long getExchangesInflight();

    @ManagedAttribute(description="Number of failures handled")
    public long getFailuresHandled();

    @ManagedAttribute(description="Number of redeliveries (internal only)")
    public long getRedeliveries();

    @ManagedAttribute(description="Number of external initiated redeliveries (such as from JMS broker)")
    public long getExternalRedeliveries();

    @ManagedAttribute(description="Min Processing Time [milliseconds]")
    public long getMinProcessingTime();

    @ManagedAttribute(description="Mean Processing Time [milliseconds]")
    public long getMeanProcessingTime();

    @ManagedAttribute(description="Max Processing Time [milliseconds]")
    public long getMaxProcessingTime();

    @ManagedAttribute(description="Total Processing Time [milliseconds]")
    public long getTotalProcessingTime();

    @ManagedAttribute(description="Last Processing Time [milliseconds]")
    public long getLastProcessingTime();

    @ManagedAttribute(description="Delta Processing Time [milliseconds]")
    public long getDeltaProcessingTime();

    @ManagedAttribute(description="Last Exchange Completed Timestamp")
    public Date getLastExchangeCompletedTimestamp();

    @ManagedAttribute(description="Last Exchange Completed ExchangeId")
    public String getLastExchangeCompletedExchangeId();

    @ManagedAttribute(description="First Exchange Completed Timestamp")
    public Date getFirstExchangeCompletedTimestamp();

    @ManagedAttribute(description="First Exchange Completed ExchangeId")
    public String getFirstExchangeCompletedExchangeId();

    @ManagedAttribute(description="Last Exchange Failed Timestamp")
    public Date getLastExchangeFailureTimestamp();

    @ManagedAttribute(description="Last Exchange Failed ExchangeId")
    public String getLastExchangeFailureExchangeId();

    @ManagedAttribute(description="First Exchange Failed Timestamp")
    public Date getFirstExchangeFailureTimestamp();

    @ManagedAttribute(description="First Exchange Failed ExchangeId")
    public String getFirstExchangeFailureExchangeId();

    @ManagedAttribute(description="Statistics enabled")
    public boolean isStatisticsEnabled();

    @ManagedAttribute(description="Statistics enabled")
    public void setStatisticsEnabled(boolean var1);

    @ManagedOperation(description="Dumps the statistics as XML")
    public String dumpStatsAsXml(boolean var1);
}

