/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.mbean.ManagedPerformanceCounterMBean;

public interface ManagedCamelContextMBean
extends ManagedPerformanceCounterMBean {
    @ManagedAttribute(description="Camel ID")
    public String getCamelId();

    @ManagedAttribute(description="Camel Description")
    public String getCamelDescription();

    @ManagedAttribute(description="Camel ManagementName")
    public String getManagementName();

    @ManagedAttribute(description="Camel Version")
    public String getCamelVersion();

    @ManagedAttribute(description="Camel State")
    public String getState();

    @ManagedAttribute(description="Uptime [human readable text]")
    public String getUptime();

    @ManagedAttribute(description="Uptime [milliseconds]")
    public long getUptimeMillis();

    @ManagedAttribute(description="Camel Management StatisticsLevel")
    public String getManagementStatisticsLevel();

    @ManagedAttribute(description="Camel Global Options")
    public Map<String, String> getGlobalOptions();

    @ManagedAttribute(description="ClassResolver class name")
    public String getClassResolver();

    @ManagedAttribute(description="PackageScanClassResolver class name")
    public String getPackageScanClassResolver();

    @ManagedAttribute(description="ApplicationContext class name")
    public String getApplicationContextClassName();

    @ManagedAttribute(description="HeadersMapFactory class name")
    public String getHeadersMapFactoryClassName();

    @ManagedOperation(description="Gets the value of a Camel global option")
    public String getGlobalOption(String var1) throws Exception;

    @ManagedOperation(description="Sets the value of a Camel global option")
    public void setGlobalOption(String var1, String var2) throws Exception;

    @ManagedAttribute(description="Tracing")
    public Boolean getTracing();

    @ManagedAttribute(description="Tracing")
    public void setTracing(Boolean var1);

    @ManagedAttribute(description="Total number of routes")
    public Integer getTotalRoutes();

    @ManagedAttribute(description="Current number of started routes")
    public Integer getStartedRoutes();

    @ManagedAttribute(description="Shutdown timeout")
    public void setTimeout(long var1);

    @ManagedAttribute(description="Shutdown timeout")
    public long getTimeout();

    @ManagedAttribute(description="Shutdown timeout time unit")
    public void setTimeUnit(TimeUnit var1);

    @ManagedAttribute(description="Shutdown timeout time unit")
    public TimeUnit getTimeUnit();

    @ManagedAttribute(description="Whether to force shutdown now when a timeout occurred")
    public void setShutdownNowOnTimeout(boolean var1);

    @ManagedAttribute(description="Whether to force shutdown now when a timeout occurred")
    public boolean isShutdownNowOnTimeout();

    @ManagedAttribute(description="Average load over the last minute")
    public String getLoad01();

    @ManagedAttribute(description="Average load over the last five minutes")
    public String getLoad05();

    @ManagedAttribute(description="Average load over the last fifteen minutes")
    public String getLoad15();

    @ManagedAttribute(description="Throughput message/second")
    public String getThroughput();

    @ManagedAttribute(description="Whether breadcrumbs is in use")
    public boolean isUseBreadcrumb();

    @ManagedAttribute(description="Whether allowing access to the original message during routing")
    public boolean isAllowUseOriginalMessage();

    @ManagedAttribute(description="Whether message history is enabled")
    public boolean isMessageHistory();

    @ManagedAttribute(description="Whether security mask for Logging is enabled")
    public boolean isLogMask();

    @ManagedAttribute(description="Whether MDC logging is supported")
    public boolean isUseMDCLogging();

    @ManagedAttribute(description="Whether Message DataType is enabled")
    public boolean isUseDataType();

    @ManagedOperation(description="Start Camel")
    public void start() throws Exception;

    @ManagedOperation(description="Stop Camel (shutdown)")
    public void stop() throws Exception;

    @ManagedOperation(description="Restart Camel (stop and then start)")
    public void restart() throws Exception;

    @ManagedOperation(description="Suspend Camel")
    public void suspend() throws Exception;

    @ManagedOperation(description="Resume Camel")
    public void resume() throws Exception;

    @ManagedOperation(description="Starts all the routes which currently is not started")
    public void startAllRoutes() throws Exception;

    @ManagedOperation(description="Whether its possible to send to the endpoint (eg the endpoint has a producer)")
    public boolean canSendToEndpoint(String var1);

    @ManagedOperation(description="Send body (in only)")
    public void sendBody(String var1, Object var2) throws Exception;

    @ManagedOperation(description="Send body (String type) (in only)")
    public void sendStringBody(String var1, String var2) throws Exception;

    @ManagedOperation(description="Send body and headers (in only)")
    public void sendBodyAndHeaders(String var1, Object var2, Map<String, Object> var3) throws Exception;

    @ManagedOperation(description="Request body (in out)")
    public Object requestBody(String var1, Object var2) throws Exception;

    @ManagedOperation(description="Request body (String type) (in out)")
    public Object requestStringBody(String var1, String var2) throws Exception;

    @ManagedOperation(description="Request body and headers (in out)")
    public Object requestBodyAndHeaders(String var1, Object var2, Map<String, Object> var3) throws Exception;

    @ManagedOperation(description="Dumps the rests as XML")
    public String dumpRestsAsXml() throws Exception;

    @ManagedOperation(description="Dumps the rests as XML")
    public String dumpRestsAsXml(boolean var1) throws Exception;

    @ManagedOperation(description="Dumps the routes as XML")
    public String dumpRoutesAsXml() throws Exception;

    @ManagedOperation(description="Dumps the routes as XML")
    public String dumpRoutesAsXml(boolean var1) throws Exception;

    @ManagedOperation(description="Dumps the routes as XML")
    public String dumpRoutesAsXml(boolean var1, boolean var2) throws Exception;

    @ManagedOperation(description="Dumps the CamelContext and routes stats as XML")
    public String dumpRoutesStatsAsXml(boolean var1, boolean var2) throws Exception;

    @ManagedOperation(description="Dumps the CamelContext and routes and steps stats as XML")
    public String dumpStepStatsAsXml(boolean var1) throws Exception;

    @ManagedOperation(description="Dumps the routes coverage as XML")
    public String dumpRoutesCoverageAsXml() throws Exception;

    @ManagedOperation(description="Dumps the route templates as XML")
    public String dumpRouteTemplatesAsXml() throws Exception;

    @ManagedOperation(description="Dumps all routes with mappings between node ids and their source location/line-number (currently only XML and YAML routes supported) as XML")
    @Deprecated
    public String dumpRoutesSourceLocationsAsXml() throws Exception;

    @ManagedOperation(description="Creates the endpoint by the given URI")
    public boolean createEndpoint(String var1) throws Exception;

    @ManagedOperation(description="Removes endpoints by the given pattern")
    public int removeEndpoints(String var1) throws Exception;

    @ManagedOperation(description="Reset counters")
    public void reset(boolean var1) throws Exception;

    @ManagedOperation(description="The names of the components currently registered")
    public Set<String> componentNames() throws Exception;

    @ManagedOperation(description="The names of the languages currently registered")
    public Set<String> languageNames() throws Exception;

    @ManagedOperation(description="The names of the data formats currently registered")
    public Set<String> dataFormatNames() throws Exception;
}

