/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultManagementStrategy;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementStrategyFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ManagementStrategy create(CamelContext context) {
        if (!Boolean.getBoolean("org.apache.camel.jmx.disabled")) {
            try {
                return new ManagedManagementStrategy(context, new DefaultManagementAgent(context));
            }
            catch (Exception e) {
                this.log.warn("Cannot create JMX lifecycle strategy. Will fallback and disable JMX.", (Throwable)e);
            }
        }
        return new DefaultManagementStrategy(context);
    }
}

