/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.NamedNode;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.api.management.mbean.ManagedStepMBean;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.management.mbean.ModelCamelContextHelper;
import org.apache.camel.management.mbean.RouteCoverageXmlParser;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.JSonSchemaHelper;
import org.apache.camel.util.XmlLineNumberParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@ManagedResource(description="Managed CamelContext")
public class ManagedCamelContext
extends ManagedPerformanceCounter
implements TimerListener,
ManagedCamelContextMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedCamelContext.class);
    private final ModelCamelContext context;
    private final LoadTriplet load = new LoadTriplet();
    private final String jmxDomain;

    public ManagedCamelContext(ModelCamelContext context) {
        this.context = context;
        this.jmxDomain = context.getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean enabled = this.context.getManagementStrategy().getManagementAgent() != null && this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public String getCamelId() {
        return this.context.getName();
    }

    public String getManagementName() {
        return this.context.getManagementName();
    }

    public String getCamelVersion() {
        return this.context.getVersion();
    }

    public String getState() {
        return this.context.getStatus().name();
    }

    public String getUptime() {
        return this.context.getUptime();
    }

    public long getUptimeMillis() {
        return this.context.getUptimeMillis();
    }

    public String getManagementStatisticsLevel() {
        if (this.context.getManagementStrategy().getManagementAgent() != null) {
            return this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel().name();
        }
        return null;
    }

    public String getClassResolver() {
        return this.context.getClassResolver().getClass().getName();
    }

    public String getPackageScanClassResolver() {
        return this.context.getPackageScanClassResolver().getClass().getName();
    }

    public String getApplicationContextClassName() {
        if (this.context.getApplicationContextClassLoader() != null) {
            return this.context.getApplicationContextClassLoader().getClass().getName();
        }
        return null;
    }

    public String getHeadersMapFactoryClassName() {
        return this.context.getHeadersMapFactory().getClass().getName();
    }

    public Map<String, String> getGlobalOptions() {
        if (this.context.getGlobalOptions().isEmpty()) {
            return null;
        }
        return this.context.getGlobalOptions();
    }

    public String getGlobalOption(String key) throws Exception {
        return this.context.getGlobalOption(key);
    }

    public void setGlobalOption(String key, String value) throws Exception {
        this.context.getGlobalOptions().put(key, value);
    }

    public Boolean getTracing() {
        return this.context.isTracing();
    }

    public void setTracing(Boolean tracing) {
        this.context.setTracing(tracing);
    }

    public Integer getInflightExchanges() {
        return (int)super.getExchangesInflight();
    }

    public Integer getTotalRoutes() {
        return this.context.getRoutes().size();
    }

    public Integer getStartedRoutes() {
        int started = 0;
        for (Route route : this.context.getRoutes()) {
            if (!this.context.getRouteController().getRouteStatus(route.getId()).isStarted()) continue;
            ++started;
        }
        return started;
    }

    public void setTimeout(long timeout) {
        this.context.getShutdownStrategy().setTimeout(timeout);
    }

    public long getTimeout() {
        return this.context.getShutdownStrategy().getTimeout();
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.context.getShutdownStrategy().setTimeUnit(timeUnit);
    }

    public TimeUnit getTimeUnit() {
        return this.context.getShutdownStrategy().getTimeUnit();
    }

    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(shutdownNowOnTimeout);
    }

    public boolean isShutdownNowOnTimeout() {
        return this.context.getShutdownStrategy().isShutdownNowOnTimeout();
    }

    public String getLoad01() {
        double load1 = this.load.getLoad1();
        if (Double.isNaN(load1)) {
            return "";
        }
        return String.format("%.2f", load1);
    }

    public String getLoad05() {
        double load5 = this.load.getLoad5();
        if (Double.isNaN(load5)) {
            return "";
        }
        return String.format("%.2f", load5);
    }

    public String getLoad15() {
        double load15 = this.load.getLoad15();
        if (Double.isNaN(load15)) {
            return "";
        }
        return String.format("%.2f", load15);
    }

    public boolean isUseBreadcrumb() {
        return this.context.isUseBreadcrumb();
    }

    public boolean isAllowUseOriginalMessage() {
        return this.context.isAllowUseOriginalMessage();
    }

    public boolean isMessageHistory() {
        return this.context.isMessageHistory() != null ? this.context.isMessageHistory() : false;
    }

    public boolean isLogMask() {
        return this.context.isLogMask() != null ? this.context.isLogMask() : false;
    }

    public boolean isUseMDCLogging() {
        return this.context.isUseMDCLogging();
    }

    public boolean isUseDataType() {
        return this.context.isUseDataType();
    }

    public void onTimer() {
        this.load.update(this.getInflightExchanges());
    }

    public void start() throws Exception {
        if (this.context.isSuspended()) {
            this.context.resume();
        } else {
            this.context.start();
        }
    }

    public void stop() throws Exception {
        this.context.stop();
    }

    public void restart() throws Exception {
        this.context.stop();
        this.context.start();
    }

    public void suspend() throws Exception {
        this.context.suspend();
    }

    public void resume() throws Exception {
        if (!this.context.isSuspended()) {
            throw new IllegalStateException("CamelContext is not suspended");
        }
        this.context.resume();
    }

    public void startAllRoutes() throws Exception {
        this.context.getRouteController().startAllRoutes();
    }

    public boolean canSendToEndpoint(String endpointUri) {
        try {
            Endpoint endpoint = this.context.getEndpoint(endpointUri);
            if (endpoint != null) {
                Producer producer = endpoint.createProducer();
                return producer != null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBody(String endpointUri, Object body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        try {
            template.sendBody(endpointUri, body);
        }
        finally {
            template.stop();
        }
    }

    public void sendStringBody(String endpointUri, String body) throws Exception {
        this.sendBody(endpointUri, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        try {
            template.sendBodyAndHeaders(endpointUri, body, headers);
        }
        finally {
            template.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object requestBody(String endpointUri, Object body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        Object answer = null;
        try {
            answer = template.requestBody(endpointUri, body);
        }
        finally {
            template.stop();
        }
        return answer;
    }

    public Object requestStringBody(String endpointUri, String body) throws Exception {
        return this.requestBody(endpointUri, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        Object answer = null;
        try {
            answer = template.requestBodyAndHeaders(endpointUri, body, headers);
        }
        finally {
            template.stop();
        }
        return answer;
    }

    public String dumpRestsAsXml() throws Exception {
        return this.dumpRestsAsXml(false);
    }

    public String dumpRestsAsXml(boolean resolvePlaceholders) throws Exception {
        List rests = this.context.getRestDefinitions();
        if (rests.isEmpty()) {
            return null;
        }
        RestsDefinition def = new RestsDefinition();
        def.setRests(rests);
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)def);
        if (resolvePlaceholders) {
            final AtomicBoolean changed = new AtomicBoolean();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            Document dom = XmlLineNumberParser.parseXml((InputStream)is, (XmlLineNumberParser.XmlTextTransformer)new XmlLineNumberParser.XmlTextTransformer(){

                public String transform(String text) {
                    try {
                        String after = ManagedCamelContext.this.getContext().resolvePropertyPlaceholders(text);
                        if (!changed.get()) {
                            changed.set(!text.equals(after));
                        }
                        return after;
                    }
                    catch (Exception e) {
                        return text;
                    }
                }
            });
            if (changed.get()) {
                xml = (String)this.context.getTypeConverter().mandatoryConvertTo(String.class, (Object)dom);
                RestsDefinition copy = (RestsDefinition)ModelHelper.createModelFromXml((CamelContext)this.context, (String)xml, RestsDefinition.class);
                xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)copy);
            }
        }
        return xml;
    }

    public String dumpRoutesAsXml() throws Exception {
        return this.dumpRoutesAsXml(false);
    }

    public String dumpRoutesAsXml(boolean resolvePlaceholders) throws Exception {
        List routes = this.context.getRouteDefinitions();
        if (routes.isEmpty()) {
            return null;
        }
        RoutesDefinition def = new RoutesDefinition();
        def.setRoutes(routes);
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)def);
        if (resolvePlaceholders) {
            final AtomicBoolean changed = new AtomicBoolean();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            Document dom = XmlLineNumberParser.parseXml((InputStream)is, (XmlLineNumberParser.XmlTextTransformer)new XmlLineNumberParser.XmlTextTransformer(){

                public String transform(String text) {
                    try {
                        String after = ManagedCamelContext.this.getContext().resolvePropertyPlaceholders(text);
                        if (!changed.get()) {
                            changed.set(!text.equals(after));
                        }
                        return after;
                    }
                    catch (Exception e) {
                        return text;
                    }
                }
            });
            if (changed.get()) {
                xml = (String)this.context.getTypeConverter().mandatoryConvertTo(String.class, (Object)dom);
                RoutesDefinition copy = (RoutesDefinition)ModelHelper.createModelFromXml((CamelContext)this.context, (String)xml, RoutesDefinition.class);
                xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)copy);
            }
        }
        return xml;
    }

    public void addOrUpdateRoutesFromXml(String xml) throws Exception {
        this.addOrUpdateRoutesFromXml(xml, false);
    }

    public void addOrUpdateRoutesFromXml(String xml, boolean urlDecode) throws Exception {
        if (urlDecode) {
            xml = URLDecoder.decode(xml, "UTF-8");
        }
        InputStream is = (InputStream)this.context.getTypeConverter().mandatoryConvertTo(InputStream.class, (Object)xml);
        try {
            this.context.addRouteDefinitions(is);
        }
        catch (Exception e) {
            String msg = "Error updating routes from xml: " + xml + " due: " + e.getMessage();
            LOG.warn(msg, (Throwable)e);
            throw e;
        }
    }

    public String dumpRoutesStatsAsXml(boolean fullStats, boolean includeProcessors) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextStat").append(String.format(" id=\"%s\" state=\"%s\"", this.getCamelId(), this.getState()));
        String stat = this.dumpStatsAsXml(fullStats);
        sb.append(" exchangesInflight=\"").append(this.getInflightExchanges()).append("\"");
        sb.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> routes = server.queryNames(query, null);
            ArrayList<ManagedProcessorMBean> processors = new ArrayList<ManagedProcessorMBean>();
            if (includeProcessors) {
                query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
                Set<ObjectName> names = server.queryNames(query, null);
                for (ObjectName on : names) {
                    ManagedProcessorMBean processor = (ManagedProcessorMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProcessorMBean.class);
                    processors.add(processor);
                }
            }
            processors.sort(new OrderProcessorMBeans());
            sb.append("  <routeStats>\n");
            for (ObjectName on : routes) {
                ManagedRouteMBean route = (ManagedRouteMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedRouteMBean.class);
                sb.append("    <routeStat").append(String.format(" id=\"%s\" state=\"%s\"", route.getRouteId(), route.getState()));
                stat = route.dumpStatsAsXml(fullStats);
                sb.append(" exchangesInflight=\"").append(route.getExchangesInflight()).append("\"");
                sb.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
                if (includeProcessors) {
                    sb.append("      <processorStats>\n");
                    for (ManagedProcessorMBean processor : processors) {
                        if (!route.getRouteId().equals(processor.getRouteId())) continue;
                        sb.append("        <processorStat").append(String.format(" id=\"%s\" index=\"%s\" state=\"%s\"", processor.getProcessorId(), processor.getIndex(), processor.getState()));
                        stat = processor.dumpStatsAsXml(fullStats);
                        sb.append(" exchangesInflight=\"").append(processor.getExchangesInflight()).append("\"");
                        sb.append(" ").append(stat.substring(7)).append("\n");
                    }
                    sb.append("      </processorStats>\n");
                }
                sb.append("    </routeStat>\n");
            }
            sb.append("  </routeStats>\n");
        }
        sb.append("</camelContextStat>");
        return sb.toString();
    }

    public String dumpStepStatsAsXml(boolean fullStats) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextStat").append(String.format(" id=\"%s\" state=\"%s\"", this.getCamelId(), this.getState()));
        String stat = this.dumpStatsAsXml(fullStats);
        sb.append(" exchangesInflight=\"").append(this.getInflightExchanges()).append("\"");
        sb.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> routes = server.queryNames(query, null);
            ArrayList<Object> steps = new ArrayList<Object>();
            query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=steps,*");
            Set<ObjectName> names = server.queryNames(query, null);
            for (ObjectName on : names) {
                ManagedStepMBean step = (ManagedStepMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedStepMBean.class);
                steps.add(step);
            }
            steps.sort(new OrderProcessorMBeans());
            sb.append("  <routeStats>\n");
            for (ObjectName on : routes) {
                ManagedRouteMBean route = (ManagedRouteMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedRouteMBean.class);
                sb.append("    <routeStat").append(String.format(" id=\"%s\" state=\"%s\"", route.getRouteId(), route.getState()));
                stat = route.dumpStatsAsXml(fullStats);
                sb.append(" exchangesInflight=\"").append(route.getExchangesInflight()).append("\"");
                sb.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
                sb.append("      <stepStats>\n");
                for (ManagedProcessorMBean managedProcessorMBean : steps) {
                    if (route.getRouteId().equals(managedProcessorMBean.getRouteId())) {
                        sb.append("        <stepStat").append(String.format(" id=\"%s\" index=\"%s\" state=\"%s\"", managedProcessorMBean.getProcessorId(), managedProcessorMBean.getIndex(), managedProcessorMBean.getState()));
                        stat = managedProcessorMBean.dumpStatsAsXml(fullStats);
                        sb.append(" exchangesInflight=\"").append(managedProcessorMBean.getExchangesInflight()).append("\"");
                        sb.append(" ").append(stat.substring(7)).append("\n");
                    }
                    sb.append("      </stepStats>\n");
                }
                sb.append("    </stepStat>\n");
            }
            sb.append("  </routeStats>\n");
        }
        sb.append("</camelContextStat>");
        return sb.toString();
    }

    public String dumpRoutesCoverageAsXml() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextRouteCoverage").append(String.format(" id=\"%s\" exchangesTotal=\"%s\" totalProcessingTime=\"%s\"", this.getCamelId(), this.getExchangesTotal(), this.getTotalProcessingTime())).append(">\n");
        String xml = this.dumpRoutesAsXml();
        if (xml != null) {
            Document dom = RouteCoverageXmlParser.parseXml((CamelContext)this.context, new ByteArrayInputStream(xml.getBytes()));
            String converted = (String)this.context.getTypeConverter().convertTo(String.class, (Object)dom);
            sb.append(converted);
        }
        sb.append("\n</camelContextRouteCoverage>");
        return sb.toString();
    }

    public boolean createEndpoint(String uri) throws Exception {
        if (this.context.hasEndpoint(uri) != null) {
            return false;
        }
        Endpoint endpoint = this.context.getEndpoint(uri);
        if (endpoint != null) {
            ObjectName on = this.context.getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForEndpoint(endpoint);
            if (on != null && !this.context.getManagementStrategy().getManagementAgent().isRegistered(on)) {
                Object me = this.context.getManagementStrategy().getManagementObjectStrategy().getManagedObjectForEndpoint((CamelContext)this.context, endpoint);
                this.context.getManagementStrategy().getManagementAgent().register(me, on);
            }
            return true;
        }
        return false;
    }

    public int removeEndpoints(String pattern) throws Exception {
        Collection removed = this.context.removeEndpoints(pattern);
        return removed.size();
    }

    public Map<String, Properties> findEips() throws Exception {
        return ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).findEips();
    }

    public List<String> findEipNames() throws Exception {
        Map<String, Properties> map = this.findEips();
        return new ArrayList<String>(map.keySet());
    }

    public TabularData listEips() throws Exception {
        try {
            Map eips = ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).findEips();
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listEipsTabularType());
            for (Map.Entry entry : eips.entrySet()) {
                String name = (String)entry.getKey();
                String title = (String)((Properties)entry.getValue()).get("title");
                String description = (String)((Properties)entry.getValue()).get("description");
                String label = (String)((Properties)entry.getValue()).get("label");
                String type = (String)((Properties)entry.getValue()).get("class");
                String status = ModelCamelContextHelper.isEipInUse((CamelContext)this.context, name) ? "in use" : "on classpath";
                CompositeType ct = CamelOpenMBeanTypes.listEipsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"name", "title", "description", "label", "status", "type"}, new Object[]{name, title, description, label, status, type});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public Map<String, Properties> findComponents() throws Exception {
        Map answer = ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).findComponents();
        for (Map.Entry entry : answer.entrySet()) {
            if (entry.getValue() == null) continue;
            ((Properties)entry.getValue()).remove("component");
            ((Properties)entry.getValue()).remove("components");
        }
        return answer;
    }

    public String createRouteStaticEndpointJson() {
        return this.createRouteStaticEndpointJson(true);
    }

    public String createRouteStaticEndpointJson(boolean includeDynamic) {
        return ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).createRouteStaticEndpointJson(null, includeDynamic);
    }

    public List<String> findComponentNames() throws Exception {
        Map<String, Properties> map = this.findComponents();
        return new ArrayList<String>(map.keySet());
    }

    public TabularData listComponents() throws Exception {
        try {
            Map components = ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).findComponents();
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listComponentsTabularType());
            for (Map.Entry entry : components.entrySet()) {
                String name = (String)entry.getKey();
                String title = null;
                String syntax = null;
                String description = null;
                String label = null;
                String deprecated = null;
                String secret = null;
                String status = this.context.hasComponent(name) != null ? "in use" : "on classpath";
                String type = (String)((Properties)entry.getValue()).get("class");
                String groupId = null;
                String artifactId = null;
                String version = null;
                String defaultName = ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).resolveComponentDefaultName(type);
                String target = defaultName != null ? defaultName : name;
                String json = ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).getComponentParameterJsonSchema(target);
                List rows = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
                for (Map row : rows) {
                    if (row.containsKey("title")) {
                        title = (String)row.get("title");
                        continue;
                    }
                    if (row.containsKey("syntax")) {
                        syntax = (String)row.get("syntax");
                        continue;
                    }
                    if (row.containsKey("description")) {
                        description = (String)row.get("description");
                        continue;
                    }
                    if (row.containsKey("label")) {
                        label = (String)row.get("label");
                        continue;
                    }
                    if (row.containsKey("deprecated")) {
                        deprecated = (String)row.get("deprecated");
                        continue;
                    }
                    if (row.containsKey("secret")) {
                        secret = (String)row.get("secret");
                        continue;
                    }
                    if (row.containsKey("javaType")) {
                        type = (String)row.get("javaType");
                        continue;
                    }
                    if (row.containsKey("groupId")) {
                        groupId = (String)row.get("groupId");
                        continue;
                    }
                    if (row.containsKey("artifactId")) {
                        artifactId = (String)row.get("artifactId");
                        continue;
                    }
                    if (!row.containsKey("version")) continue;
                    version = (String)row.get("version");
                }
                CompositeType ct = CamelOpenMBeanTypes.listComponentsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"name", "title", "syntax", "description", "label", "deprecated", "secret", "status", "type", "groupId", "artifactId", "version"}, new Object[]{name, title, syntax, description, label, deprecated, secret, status, type, groupId, artifactId, version});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public String componentParameterJsonSchema(String componentName) throws Exception {
        return ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).getComponentParameterJsonSchema(componentName);
    }

    public String dataFormatParameterJsonSchema(String dataFormatName) throws Exception {
        return ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).getDataFormatParameterJsonSchema(dataFormatName);
    }

    public String languageParameterJsonSchema(String languageName) throws Exception {
        return ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).getLanguageParameterJsonSchema(languageName);
    }

    public String eipParameterJsonSchema(String eipName) throws Exception {
        return ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).getEipParameterJsonSchema(eipName);
    }

    public String explainEipJson(String nameOrId, boolean includeAllOptions) {
        return ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).explainEipJson(nameOrId, includeAllOptions);
    }

    public String explainComponentJson(String componentName, boolean includeAllOptions) throws Exception {
        return ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).explainComponentJson(componentName, includeAllOptions);
    }

    public String explainEndpointJson(String uri, boolean includeAllOptions) throws Exception {
        return ((CatalogCamelContext)this.context.adapt(CatalogCamelContext.class)).explainEndpointJson(uri, includeAllOptions);
    }

    public void reset(boolean includeRoutes) throws Exception {
        MBeanServer server;
        this.reset();
        if (includeRoutes && (server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer()) != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> names = server.queryNames(query, null);
            for (ObjectName name : names) {
                server.invoke(name, "reset", new Object[]{true}, new String[]{"boolean"});
            }
        }
    }

    private static final class OrderProcessorMBeans
    implements Comparator<ManagedProcessorMBean> {
        private OrderProcessorMBeans() {
        }

        @Override
        public int compare(ManagedProcessorMBean o1, ManagedProcessorMBean o2) {
            return o1.getIndex().compareTo(o2.getIndex());
        }
    }
}

