/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedDataFormatMBean;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.JSonSchemaHelper;

@ManagedResource(description="Managed DataFormat")
public class ManagedDataFormat
implements ManagedInstance,
ManagedDataFormatMBean {
    private final CamelContext camelContext;
    private final DataFormat dataFormat;

    public ManagedDataFormat(CamelContext camelContext, DataFormat dataFormat) {
        this.camelContext = camelContext;
        this.dataFormat = dataFormat;
    }

    public void init(ManagementStrategy strategy) {
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public String getName() {
        if (this.dataFormat instanceof DataFormatName) {
            return ((DataFormatName)this.dataFormat).getDataFormatName();
        }
        return null;
    }

    public String getCamelId() {
        return this.camelContext.getName();
    }

    public String getCamelManagementName() {
        return this.camelContext.getManagementName();
    }

    public String getState() {
        if (this.dataFormat instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)this.dataFormat).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    public String informationJson() {
        String dataFormatName = this.getName();
        if (dataFormatName != null) {
            return ((CatalogCamelContext)this.camelContext.adapt(CatalogCamelContext.class)).explainDataFormatJson(dataFormatName, this.dataFormat, true);
        }
        return null;
    }

    public TabularData explain(boolean allOptions) {
        String dataFormatName = this.getName();
        if (dataFormatName != null) {
            try {
                TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.explainDataFormatTabularType());
                String json = ((CatalogCamelContext)this.camelContext.adapt(CatalogCamelContext.class)).explainDataFormatJson(dataFormatName, this.dataFormat, allOptions);
                List rows = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
                for (Map row : rows) {
                    String name = (String)row.get("name");
                    String kind = (String)row.get("kind");
                    String label = row.get("label") != null ? (String)row.get("label") : "";
                    String type = (String)row.get("type");
                    String javaType = (String)row.get("javaType");
                    String deprecated = row.get("deprecated") != null ? (String)row.get("deprecated") : "";
                    String secret = row.get("secret") != null ? (String)row.get("secret") : "";
                    String value = row.get("value") != null ? (String)row.get("value") : "";
                    String defaultValue = row.get("defaultValue") != null ? (String)row.get("defaultValue") : "";
                    String description = row.get("description") != null ? (String)row.get("description") : "";
                    CompositeType ct = CamelOpenMBeanTypes.explainDataFormatsCompositeType();
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"option", "kind", "label", "type", "java type", "deprecated", "secret", "value", "default value", "description"}, new Object[]{name, kind, label, type, javaType, deprecated, secret, value, defaultValue, description});
                    answer.put(data);
                }
                return answer;
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return null;
    }

    public DataFormat getInstance() {
        return this.dataFormat;
    }
}

