/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedPerformanceCounterMBean;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.management.mbean.ManagedCounter;
import org.apache.camel.management.mbean.Statistic;
import org.apache.camel.management.mbean.StatisticCounter;
import org.apache.camel.management.mbean.StatisticDelta;
import org.apache.camel.management.mbean.StatisticMaximum;
import org.apache.camel.management.mbean.StatisticMinimum;
import org.apache.camel.management.mbean.StatisticValue;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.ExchangeHelper;

@ManagedResource(description="Managed PerformanceCounter")
public abstract class ManagedPerformanceCounter
extends ManagedCounter
implements PerformanceCounter,
ManagedPerformanceCounterMBean {
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private Statistic exchangesCompleted;
    private Statistic exchangesFailed;
    private Statistic exchangesInflight;
    private Statistic failuresHandled;
    private Statistic redeliveries;
    private Statistic externalRedeliveries;
    private Statistic minProcessingTime;
    private Statistic maxProcessingTime;
    private Statistic totalProcessingTime;
    private Statistic lastProcessingTime;
    private Statistic deltaProcessingTime;
    private Statistic meanProcessingTime;
    private Statistic firstExchangeCompletedTimestamp;
    private String firstExchangeCompletedExchangeId;
    private Statistic firstExchangeFailureTimestamp;
    private String firstExchangeFailureExchangeId;
    private Statistic lastExchangeCompletedTimestamp;
    private String lastExchangeCompletedExchangeId;
    private Statistic lastExchangeFailureTimestamp;
    private String lastExchangeFailureExchangeId;
    private boolean statisticsEnabled = true;

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.exchangesCompleted = new StatisticCounter();
        this.exchangesFailed = new StatisticCounter();
        this.exchangesInflight = new StatisticCounter();
        this.failuresHandled = new StatisticCounter();
        this.redeliveries = new StatisticCounter();
        this.externalRedeliveries = new StatisticCounter();
        this.minProcessingTime = new StatisticMinimum();
        this.maxProcessingTime = new StatisticMaximum();
        this.totalProcessingTime = new StatisticCounter();
        this.lastProcessingTime = new StatisticValue();
        this.deltaProcessingTime = new StatisticDelta();
        this.meanProcessingTime = new StatisticValue();
        this.firstExchangeCompletedTimestamp = new StatisticValue();
        this.firstExchangeFailureTimestamp = new StatisticValue();
        this.lastExchangeCompletedTimestamp = new StatisticValue();
        this.lastExchangeFailureTimestamp = new StatisticValue();
    }

    @Override
    public void reset() {
        super.reset();
        this.exchangesCompleted.reset();
        this.exchangesFailed.reset();
        this.failuresHandled.reset();
        this.redeliveries.reset();
        this.externalRedeliveries.reset();
        this.minProcessingTime.reset();
        this.maxProcessingTime.reset();
        this.totalProcessingTime.reset();
        this.lastProcessingTime.reset();
        this.deltaProcessingTime.reset();
        this.meanProcessingTime.reset();
        this.firstExchangeCompletedTimestamp.reset();
        this.firstExchangeCompletedExchangeId = null;
        this.firstExchangeFailureTimestamp.reset();
        this.firstExchangeFailureExchangeId = null;
        this.lastExchangeCompletedTimestamp.reset();
        this.lastExchangeCompletedExchangeId = null;
        this.lastExchangeFailureTimestamp.reset();
        this.lastExchangeFailureExchangeId = null;
    }

    public long getExchangesCompleted() {
        return this.exchangesCompleted.getValue();
    }

    public long getExchangesFailed() {
        return this.exchangesFailed.getValue();
    }

    public long getExchangesInflight() {
        return this.exchangesInflight.getValue();
    }

    public long getFailuresHandled() {
        return this.failuresHandled.getValue();
    }

    public long getRedeliveries() {
        return this.redeliveries.getValue();
    }

    public long getExternalRedeliveries() {
        return this.externalRedeliveries.getValue();
    }

    public long getMinProcessingTime() {
        return this.minProcessingTime.getValue();
    }

    public long getMeanProcessingTime() {
        return this.meanProcessingTime.getValue();
    }

    public long getMaxProcessingTime() {
        return this.maxProcessingTime.getValue();
    }

    public long getTotalProcessingTime() {
        return this.totalProcessingTime.getValue();
    }

    public long getLastProcessingTime() {
        return this.lastProcessingTime.getValue();
    }

    public long getDeltaProcessingTime() {
        return this.deltaProcessingTime.getValue();
    }

    public Date getLastExchangeCompletedTimestamp() {
        long value = this.lastExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    public String getLastExchangeCompletedExchangeId() {
        return this.lastExchangeCompletedExchangeId;
    }

    public Date getFirstExchangeCompletedTimestamp() {
        long value = this.firstExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    public String getFirstExchangeCompletedExchangeId() {
        return this.firstExchangeCompletedExchangeId;
    }

    public Date getLastExchangeFailureTimestamp() {
        long value = this.lastExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    public String getLastExchangeFailureExchangeId() {
        return this.lastExchangeFailureExchangeId;
    }

    public Date getFirstExchangeFailureTimestamp() {
        long value = this.firstExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    public String getFirstExchangeFailureExchangeId() {
        return this.firstExchangeFailureExchangeId;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @Override
    public void processExchange(Exchange exchange) {
        this.exchangesInflight.increment();
    }

    @Override
    public void completedExchange(Exchange exchange, long time) {
        this.increment();
        this.exchangesCompleted.increment();
        this.exchangesInflight.decrement();
        if (ExchangeHelper.isFailureHandled((Exchange)exchange)) {
            this.failuresHandled.increment();
        }
        if (exchange.isExternalRedelivered()) {
            this.externalRedeliveries.increment();
        }
        this.minProcessingTime.updateValue(time);
        this.maxProcessingTime.updateValue(time);
        this.totalProcessingTime.updateValue(time);
        this.lastProcessingTime.updateValue(time);
        this.deltaProcessingTime.updateValue(time);
        long now = System.currentTimeMillis();
        if (!this.firstExchangeCompletedTimestamp.isUpdated()) {
            this.firstExchangeCompletedTimestamp.updateValue(now);
        }
        this.lastExchangeCompletedTimestamp.updateValue(now);
        if (this.firstExchangeCompletedExchangeId == null) {
            this.firstExchangeCompletedExchangeId = exchange.getExchangeId();
        }
        this.lastExchangeCompletedExchangeId = exchange.getExchangeId();
        long mean = 0L;
        long completed = this.exchangesCompleted.getValue();
        if (completed > 0L) {
            mean = this.totalProcessingTime.getValue() / completed;
        }
        this.meanProcessingTime.updateValue(mean);
    }

    @Override
    public void failedExchange(Exchange exchange) {
        this.increment();
        this.exchangesFailed.increment();
        this.exchangesInflight.decrement();
        if (ExchangeHelper.isRedelivered((Exchange)exchange)) {
            this.redeliveries.increment();
        }
        if (exchange.isExternalRedelivered()) {
            this.externalRedeliveries.increment();
        }
        long now = System.currentTimeMillis();
        if (!this.firstExchangeFailureTimestamp.isUpdated()) {
            this.firstExchangeFailureTimestamp.updateValue(now);
        }
        this.lastExchangeFailureTimestamp.updateValue(now);
        if (this.firstExchangeFailureExchangeId == null) {
            this.firstExchangeFailureExchangeId = exchange.getExchangeId();
        }
        this.lastExchangeFailureExchangeId = exchange.getExchangeId();
    }

    public String dumpStatsAsXml(boolean fullStats) {
        StringBuilder sb = new StringBuilder();
        sb.append("<stats ");
        sb.append(String.format("exchangesCompleted=\"%s\"", this.exchangesCompleted.getValue()));
        sb.append(String.format(" exchangesFailed=\"%s\"", this.exchangesFailed.getValue()));
        sb.append(String.format(" failuresHandled=\"%s\"", this.failuresHandled.getValue()));
        sb.append(String.format(" redeliveries=\"%s\"", this.redeliveries.getValue()));
        sb.append(String.format(" externalRedeliveries=\"%s\"", this.externalRedeliveries.getValue()));
        sb.append(String.format(" minProcessingTime=\"%s\"", this.minProcessingTime.getValue()));
        sb.append(String.format(" maxProcessingTime=\"%s\"", this.maxProcessingTime.getValue()));
        sb.append(String.format(" totalProcessingTime=\"%s\"", this.totalProcessingTime.getValue()));
        sb.append(String.format(" lastProcessingTime=\"%s\"", this.lastProcessingTime.getValue()));
        sb.append(String.format(" deltaProcessingTime=\"%s\"", this.deltaProcessingTime.getValue()));
        sb.append(String.format(" meanProcessingTime=\"%s\"", this.meanProcessingTime.getValue()));
        if (fullStats) {
            sb.append(String.format(" startTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.startTimestamp.getTime())));
            sb.append(String.format(" resetTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.resetTimestamp.getTime())));
            sb.append(String.format(" firstExchangeCompletedTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.firstExchangeCompletedTimestamp.getValue())));
            sb.append(String.format(" firstExchangeCompletedExchangeId=\"%s\"", ManagedPerformanceCounter.nullSafe(this.firstExchangeCompletedExchangeId)));
            sb.append(String.format(" firstExchangeFailureTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.firstExchangeFailureTimestamp.getValue())));
            sb.append(String.format(" firstExchangeFailureExchangeId=\"%s\"", ManagedPerformanceCounter.nullSafe(this.firstExchangeFailureExchangeId)));
            sb.append(String.format(" lastExchangeCompletedTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.lastExchangeCompletedTimestamp.getValue())));
            sb.append(String.format(" lastExchangeCompletedExchangeId=\"%s\"", ManagedPerformanceCounter.nullSafe(this.lastExchangeCompletedExchangeId)));
            sb.append(String.format(" lastExchangeFailureTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.lastExchangeFailureTimestamp.getValue())));
            sb.append(String.format(" lastExchangeFailureExchangeId=\"%s\"", ManagedPerformanceCounter.nullSafe(this.lastExchangeFailureExchangeId)));
        }
        sb.append("/>");
        return sb.toString();
    }

    private static String dateAsString(long value) {
        if (value <= 0L) {
            return "";
        }
        return new SimpleDateFormat(TIMESTAMP_FORMAT).format(value);
    }

    private static String nullSafe(String s) {
        return s != null ? s : "";
    }
}

