/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.NamedNode;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.api.management.mbean.ManagedStepMBean;
import org.apache.camel.management.mbean.LoadThroughput;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.management.mbean.RouteCoverageXmlParser;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.UnitOfWork;
import org.w3c.dom.Document;

@ManagedResource(description="Managed CamelContext")
public class ManagedCamelContext
extends ManagedPerformanceCounter
implements TimerListener,
ManagedCamelContextMBean {
    private final CamelContext context;
    private final LoadTriplet load = new LoadTriplet();
    private final LoadThroughput thp = new LoadThroughput();
    private final String jmxDomain;

    public ManagedCamelContext(CamelContext context) {
        this.context = context;
        this.jmxDomain = context.getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean enabled = this.context.getManagementStrategy().getManagementAgent() != null && this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    @Override
    public void completedExchange(Exchange exchange, long time) {
        UnitOfWork uow = exchange.getUnitOfWork();
        if (uow != null) {
            int level = uow.routeStackLevel();
            if (level <= 1) {
                super.completedExchange(exchange, time);
            }
        } else {
            super.completedExchange(exchange, time);
        }
    }

    @Override
    public void failedExchange(Exchange exchange) {
        UnitOfWork uow = exchange.getUnitOfWork();
        if (uow != null) {
            int level = uow.routeStackLevel();
            if (level <= 1) {
                super.failedExchange(exchange);
            }
        } else {
            super.failedExchange(exchange);
        }
    }

    @Override
    public void processExchange(Exchange exchange, String type) {
        UnitOfWork uow = exchange.getUnitOfWork();
        if (uow != null) {
            int level = uow.routeStackLevel();
            if (level <= 1) {
                super.processExchange(exchange, type);
            }
        } else {
            super.processExchange(exchange, type);
        }
    }

    public CamelContext getContext() {
        return this.context;
    }

    public String getCamelId() {
        return this.context.getName();
    }

    public String getCamelDescription() {
        return this.context.getDescription();
    }

    public String getManagementName() {
        return this.context.getManagementName();
    }

    public String getCamelVersion() {
        return this.context.getVersion();
    }

    public String getState() {
        return this.context.getStatus().name();
    }

    public String getUptime() {
        return this.context.getUptime();
    }

    public long getUptimeMillis() {
        return this.context.getUptimeMillis();
    }

    public String getManagementStatisticsLevel() {
        if (this.context.getManagementStrategy().getManagementAgent() != null) {
            return this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel().name();
        }
        return null;
    }

    public String getClassResolver() {
        return this.context.getClassResolver().getClass().getName();
    }

    public String getPackageScanClassResolver() {
        return ((ExtendedCamelContext)this.context.adapt(ExtendedCamelContext.class)).getPackageScanClassResolver().getClass().getName();
    }

    public String getApplicationContextClassName() {
        if (this.context.getApplicationContextClassLoader() != null) {
            return this.context.getApplicationContextClassLoader().getClass().getName();
        }
        return null;
    }

    public String getHeadersMapFactoryClassName() {
        return ((ExtendedCamelContext)this.context.adapt(ExtendedCamelContext.class)).getHeadersMapFactory().getClass().getName();
    }

    public Map<String, String> getGlobalOptions() {
        if (this.context.getGlobalOptions().isEmpty()) {
            return null;
        }
        return this.context.getGlobalOptions();
    }

    public String getGlobalOption(String key) throws Exception {
        return this.context.getGlobalOption(key);
    }

    public void setGlobalOption(String key, String value) throws Exception {
        this.context.getGlobalOptions().put(key, value);
    }

    public Boolean getTracing() {
        return this.context.isTracing();
    }

    public void setTracing(Boolean tracing) {
        this.context.setTracing(tracing);
    }

    public Integer getInflightExchanges() {
        return (int)super.getExchangesInflight();
    }

    public Integer getTotalRoutes() {
        return this.context.getRoutesSize();
    }

    public Integer getStartedRoutes() {
        int started = 0;
        for (Route route : this.context.getRoutes()) {
            if (!this.context.getRouteController().getRouteStatus(route.getId()).isStarted()) continue;
            ++started;
        }
        return started;
    }

    public void setTimeout(long timeout) {
        this.context.getShutdownStrategy().setTimeout(timeout);
    }

    public long getTimeout() {
        return this.context.getShutdownStrategy().getTimeout();
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.context.getShutdownStrategy().setTimeUnit(timeUnit);
    }

    public TimeUnit getTimeUnit() {
        return this.context.getShutdownStrategy().getTimeUnit();
    }

    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(shutdownNowOnTimeout);
    }

    public boolean isShutdownNowOnTimeout() {
        return this.context.getShutdownStrategy().isShutdownNowOnTimeout();
    }

    public String getLoad01() {
        double load1 = this.load.getLoad1();
        if (Double.isNaN(load1)) {
            return "";
        }
        return String.format("%.2f", load1);
    }

    public String getLoad05() {
        double load5 = this.load.getLoad5();
        if (Double.isNaN(load5)) {
            return "";
        }
        return String.format("%.2f", load5);
    }

    public String getLoad15() {
        double load15 = this.load.getLoad15();
        if (Double.isNaN(load15)) {
            return "";
        }
        return String.format("%.2f", load15);
    }

    public String getThroughput() {
        double d = this.thp.getThroughput();
        if (Double.isNaN(d)) {
            return "";
        }
        return String.format("%.2f", d);
    }

    public boolean isUseBreadcrumb() {
        return this.context.isUseBreadcrumb();
    }

    public boolean isAllowUseOriginalMessage() {
        return this.context.isAllowUseOriginalMessage();
    }

    public boolean isMessageHistory() {
        return this.context.isMessageHistory() != null ? this.context.isMessageHistory() : false;
    }

    public boolean isLogMask() {
        return this.context.isLogMask() != null ? this.context.isLogMask() : false;
    }

    public boolean isUseMDCLogging() {
        return this.context.isUseMDCLogging();
    }

    public boolean isUseDataType() {
        return this.context.isUseDataType();
    }

    public void onTimer() {
        this.load.update(this.getInflightExchanges());
        this.thp.update(this.getExchangesTotal());
    }

    public void start() throws Exception {
        if (this.context.isSuspended()) {
            this.context.resume();
        } else {
            this.context.start();
        }
    }

    public void stop() throws Exception {
        this.context.stop();
    }

    public void restart() throws Exception {
        this.context.stop();
        this.context.start();
    }

    public void suspend() throws Exception {
        this.context.suspend();
    }

    public void resume() throws Exception {
        if (!this.context.isSuspended()) {
            throw new IllegalStateException("CamelContext is not suspended");
        }
        this.context.resume();
    }

    public void startAllRoutes() throws Exception {
        this.context.getRouteController().startAllRoutes();
    }

    public boolean canSendToEndpoint(String endpointUri) {
        block8: {
            boolean bl;
            block9: {
                Endpoint endpoint = this.context.getEndpoint(endpointUri);
                if (endpoint == null) break block8;
                Producer producer = endpoint.createProducer();
                try {
                    boolean bl2 = bl = producer != null;
                    if (producer == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (producer != null) {
                            try {
                                producer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                producer.close();
            }
            return bl;
        }
        return false;
    }

    public void sendBody(String endpointUri, Object body) throws Exception {
        try (ProducerTemplate template = this.context.createProducerTemplate();){
            template.sendBody(endpointUri, body);
        }
    }

    public void sendStringBody(String endpointUri, String body) throws Exception {
        this.sendBody(endpointUri, body);
    }

    public void sendBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        try (ProducerTemplate template = this.context.createProducerTemplate();){
            template.sendBodyAndHeaders(endpointUri, body, headers);
        }
    }

    public Object requestBody(String endpointUri, Object body) throws Exception {
        try (ProducerTemplate template = this.context.createProducerTemplate();){
            Object object = template.requestBody(endpointUri, body);
            return object;
        }
    }

    public Object requestStringBody(String endpointUri, String body) throws Exception {
        return this.requestBody(endpointUri, body);
    }

    public Object requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        try (ProducerTemplate template = this.context.createProducerTemplate();){
            Object object = template.requestBodyAndHeaders(endpointUri, body, headers);
            return object;
        }
    }

    public String dumpRestsAsXml() throws Exception {
        return this.dumpRestsAsXml(false);
    }

    public String dumpRestsAsXml(boolean resolvePlaceholders) throws Exception {
        List rests = ((Model)this.context.getExtension(Model.class)).getRestDefinitions();
        if (rests.isEmpty()) {
            return null;
        }
        RestsDefinition def = new RestsDefinition();
        def.setRests(rests);
        ExtendedCamelContext ecc = (ExtendedCamelContext)this.context.adapt(ExtendedCamelContext.class);
        return ecc.getModelToXMLDumper().dumpModelAsXml(this.context, (NamedNode)def, resolvePlaceholders, false);
    }

    public String dumpRoutesAsXml() throws Exception {
        return this.dumpRoutesAsXml(false, false);
    }

    public String dumpRoutesAsXml(boolean resolvePlaceholders) throws Exception {
        return this.dumpRoutesAsXml(resolvePlaceholders, false);
    }

    public String dumpRoutesAsXml(boolean resolvePlaceholders, boolean resolveDelegateEndpoints) throws Exception {
        List routes = ((Model)this.context.getExtension(Model.class)).getRouteDefinitions();
        if (routes.isEmpty()) {
            return null;
        }
        RoutesDefinition def = new RoutesDefinition();
        def.setRoutes(routes);
        ExtendedCamelContext ecc = (ExtendedCamelContext)this.context.adapt(ExtendedCamelContext.class);
        return ecc.getModelToXMLDumper().dumpModelAsXml(this.context, (NamedNode)def, resolvePlaceholders, resolveDelegateEndpoints);
    }

    public String dumpRouteTemplatesAsXml() throws Exception {
        List templates = ((Model)this.context.getExtension(Model.class)).getRouteTemplateDefinitions();
        if (templates.isEmpty()) {
            return null;
        }
        RouteTemplatesDefinition def = new RouteTemplatesDefinition();
        def.setRouteTemplates(templates);
        ExtendedCamelContext ecc = (ExtendedCamelContext)this.context.adapt(ExtendedCamelContext.class);
        return ecc.getModelToXMLDumper().dumpModelAsXml(this.context, (NamedNode)def);
    }

    public String dumpRoutesStatsAsXml(boolean fullStats, boolean includeProcessors) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextStat").append(String.format(" id=\"%s\" state=\"%s\"", this.getCamelId(), this.getState()));
        String stat = this.dumpStatsAsXml(fullStats);
        sb.append(" exchangesInflight=\"").append(this.getInflightExchanges()).append("\"");
        sb.append(" ").append(stat, 7, stat.length() - 2).append(">\n");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> routes = server.queryNames(query, null);
            ArrayList<ManagedProcessorMBean> processors = new ArrayList<ManagedProcessorMBean>();
            if (includeProcessors) {
                query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
                Set<ObjectName> names = server.queryNames(query, null);
                for (ObjectName on : names) {
                    ManagedProcessorMBean processor = (ManagedProcessorMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProcessorMBean.class);
                    processors.add(processor);
                }
            }
            processors.sort(new OrderProcessorMBeans());
            sb.append("  <routeStats>\n");
            for (ObjectName on : routes) {
                ManagedRouteMBean route = (ManagedRouteMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedRouteMBean.class);
                sb.append("    <routeStat").append(String.format(" id=\"%s\" state=\"%s\"", route.getRouteId(), route.getState()));
                if (route.getSourceLocation() != null) {
                    sb.append(String.format(" sourceLocation=\"%s\"", route.getSourceLocation()));
                }
                stat = route.dumpStatsAsXml(fullStats);
                sb.append(" exchangesInflight=\"").append(route.getExchangesInflight()).append("\"");
                sb.append(" ").append(stat, 7, stat.length() - 2).append(">\n");
                if (includeProcessors) {
                    sb.append("      <processorStats>\n");
                    for (ManagedProcessorMBean processor : processors) {
                        int line;
                        int n = line = processor.getSourceLineNumber() != null ? processor.getSourceLineNumber() : -1;
                        if (!route.getRouteId().equals(processor.getRouteId())) continue;
                        sb.append("        <processorStat").append(String.format(" id=\"%s\" index=\"%s\" state=\"%s\" sourceLineNumber=\"%s\"", processor.getProcessorId(), processor.getIndex(), processor.getState(), line));
                        stat = processor.dumpStatsAsXml(fullStats);
                        sb.append(" exchangesInflight=\"").append(processor.getExchangesInflight()).append("\"");
                        sb.append(" ").append(stat, 7, stat.length()).append("\n");
                    }
                    sb.append("      </processorStats>\n");
                }
                sb.append("    </routeStat>\n");
            }
            sb.append("  </routeStats>\n");
        }
        sb.append("</camelContextStat>");
        return sb.toString();
    }

    public String dumpStepStatsAsXml(boolean fullStats) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextStat").append(String.format(" id=\"%s\" state=\"%s\"", this.getCamelId(), this.getState()));
        String stat = this.dumpStatsAsXml(fullStats);
        sb.append(" exchangesInflight=\"").append(this.getInflightExchanges()).append("\"");
        sb.append(" ").append(stat, 7, stat.length() - 2).append(">\n");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> routes = server.queryNames(query, null);
            ArrayList<Object> steps = new ArrayList<Object>();
            query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=steps,*");
            Set<ObjectName> names = server.queryNames(query, null);
            for (ObjectName on : names) {
                ManagedStepMBean step = (ManagedStepMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedStepMBean.class);
                steps.add(step);
            }
            steps.sort(new OrderProcessorMBeans());
            sb.append("  <routeStats>\n");
            for (ObjectName on : routes) {
                ManagedRouteMBean route = (ManagedRouteMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedRouteMBean.class);
                sb.append("    <routeStat").append(String.format(" id=\"%s\" state=\"%s\"", route.getRouteId(), route.getState()));
                if (route.getSourceLocation() != null) {
                    sb.append(String.format(" sourceLocation=\"%s\"", route.getSourceLocation()));
                }
                stat = route.dumpStatsAsXml(fullStats);
                sb.append(" exchangesInflight=\"").append(route.getExchangesInflight()).append("\"");
                sb.append(" ").append(stat, 7, stat.length() - 2).append(">\n");
                sb.append("      <stepStats>\n");
                for (ManagedProcessorMBean managedProcessorMBean : steps) {
                    if (route.getRouteId().equals(managedProcessorMBean.getRouteId())) {
                        int line = managedProcessorMBean.getSourceLineNumber() != null ? managedProcessorMBean.getSourceLineNumber() : -1;
                        sb.append("        <stepStat").append(String.format(" id=\"%s\" index=\"%s\" state=\"%s\" sourceLineNumber=\"%s\"", managedProcessorMBean.getProcessorId(), managedProcessorMBean.getIndex(), managedProcessorMBean.getState(), line));
                        stat = managedProcessorMBean.dumpStatsAsXml(fullStats);
                        sb.append(" exchangesInflight=\"").append(managedProcessorMBean.getExchangesInflight()).append("\"");
                        sb.append(" ").append(stat, 7, stat.length()).append("\n");
                    }
                    sb.append("      </stepStats>\n");
                }
                sb.append("    </stepStat>\n");
            }
            sb.append("  </routeStats>\n");
        }
        sb.append("</camelContextStat>");
        return sb.toString();
    }

    public String dumpRoutesCoverageAsXml() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextRouteCoverage").append(String.format(" id=\"%s\" exchangesTotal=\"%s\" totalProcessingTime=\"%s\"", this.getCamelId(), this.getExchangesTotal(), this.getTotalProcessingTime())).append(">\n");
        String xml = this.dumpRoutesAsXml();
        if (xml != null) {
            Document dom = RouteCoverageXmlParser.parseXml(this.context, new ByteArrayInputStream(xml.getBytes()));
            String converted = (String)this.context.getTypeConverter().convertTo(String.class, (Object)dom);
            sb.append(converted);
        }
        sb.append("\n</camelContextRouteCoverage>");
        return sb.toString();
    }

    @Deprecated
    public String dumpRoutesSourceLocationsAsXml() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<routeLocations>");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            ArrayList<ManagedRouteMBean> routes = new ArrayList<ManagedRouteMBean>();
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> names = server.queryNames(query, null);
            for (ObjectName on : names) {
                ManagedRouteMBean route = (ManagedRouteMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedRouteMBean.class);
                routes.add(route);
            }
            routes.sort(new RouteMBeans());
            ArrayList<ManagedProcessorMBean> processors = new ArrayList<ManagedProcessorMBean>();
            query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
            names = server.queryNames(query, null);
            for (ObjectName on : names) {
                ManagedProcessorMBean processor = (ManagedProcessorMBean)this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProcessorMBean.class);
                processors.add(processor);
            }
            processors.sort(new OrderProcessorMBeans());
            for (ManagedRouteMBean route : routes) {
                RouteDefinition rd = ((ModelCamelContext)this.context.adapt(ModelCamelContext.class)).getRouteDefinition(route.getRouteId());
                if (rd != null) {
                    String location;
                    String id = rd.getRouteId();
                    int line = rd.getInput().getLineNumber();
                    String string = location = rd.getInput().getLocation() != null ? rd.getInput().getLocation() : route.getSourceLocation();
                    if (location == null) {
                        location = "";
                    }
                    sb.append("\n    <routeLocation").append(String.format(" routeId=\"%s\" id=\"%s\" index=\"%s\" sourceLocation=\"%s\" sourceLineNumber=\"%s\"/>", route.getRouteId(), id, 0, location, line));
                }
                for (ManagedProcessorMBean processor : processors) {
                    if (!route.getRouteId().equals(processor.getRouteId())) continue;
                    int line = processor.getSourceLineNumber() != null ? processor.getSourceLineNumber() : -1;
                    String location = processor.getSourceLocation();
                    if (location == null) {
                        location = "";
                    }
                    sb.append("\n    <routeLocation").append(String.format(" routeId=\"%s\" id=\"%s\" index=\"%s\" sourceLocation=\"%s\" sourceLineNumber=\"%s\"/>", route.getRouteId(), processor.getProcessorId(), processor.getIndex(), location, line));
                }
            }
        }
        sb.append("\n</routeLocations>");
        return sb.toString();
    }

    public boolean createEndpoint(String uri) throws Exception {
        if (this.context.hasEndpoint(uri) != null) {
            return false;
        }
        Endpoint endpoint = this.context.getEndpoint(uri);
        if (endpoint != null) {
            ObjectName on = this.context.getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForEndpoint(endpoint);
            if (on != null && !this.context.getManagementStrategy().getManagementAgent().isRegistered(on)) {
                Object me = this.context.getManagementStrategy().getManagementObjectStrategy().getManagedObjectForEndpoint(this.context, endpoint);
                this.context.getManagementStrategy().getManagementAgent().register(me, on);
            }
            return true;
        }
        return false;
    }

    public int removeEndpoints(String pattern) throws Exception {
        Collection removed = this.context.removeEndpoints(pattern);
        return removed.size();
    }

    public void reset(boolean includeRoutes) throws Exception {
        MBeanServer server;
        this.reset();
        this.load.reset();
        this.thp.reset();
        if (includeRoutes && (server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer()) != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(this.jmxDomain + ":context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> names = server.queryNames(query, null);
            for (ObjectName name : names) {
                server.invoke(name, "reset", new Object[]{true}, new String[]{"boolean"});
            }
        }
    }

    public Set<String> componentNames() throws Exception {
        return this.context.getComponentNames();
    }

    public Set<String> languageNames() throws Exception {
        return this.context.getLanguageNames();
    }

    public Set<String> dataFormatNames() throws Exception {
        return this.context.getDataFormatNames();
    }

    private static final class RouteMBeans
    implements Comparator<ManagedRouteMBean> {
        private RouteMBeans() {
        }

        @Override
        public int compare(ManagedRouteMBean o1, ManagedRouteMBean o2) {
            return o1.getRouteId().compareToIgnoreCase(o2.getRouteId());
        }
    }

    private static final class OrderProcessorMBeans
    implements Comparator<ManagedProcessorMBean> {
        private OrderProcessorMBeans() {
        }

        @Override
        public int compare(ManagedProcessorMBean o1, ManagedProcessorMBean o2) {
            return o1.getIndex().compareTo(o2.getIndex());
        }
    }
}

