/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.service.ServiceHelper;

@ManagedResource(description="Managed Processor")
public class ManagedProcessor
extends ManagedPerformanceCounter
implements ManagedInstance,
ManagedProcessorMBean {
    private final CamelContext context;
    private final Processor processor;
    private final ProcessorDefinition<?> definition;
    private final String id;
    private final int nodeLevel;
    private String stepId;
    private Route route;
    private String sourceLocation;

    public ManagedProcessor(CamelContext context, Processor processor, ProcessorDefinition<?> definition) {
        this.context = context;
        this.processor = processor;
        this.definition = definition;
        this.nodeLevel = ProcessorDefinitionHelper.getNodeLevel(definition);
        this.id = definition.idOrCreate(((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getNodeIdFactory());
        StepDefinition step = definition instanceof StepDefinition ? (StepDefinition)definition : (StepDefinition)ProcessorDefinitionHelper.findFirstParentOfType(StepDefinition.class, definition, (boolean)true);
        this.stepId = step != null ? step.idOrCreate(((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getNodeIdFactory()) : null;
        this.sourceLocation = definition.getLocation();
        if (this.sourceLocation == null) {
            RouteDefinition rd = ProcessorDefinitionHelper.getRoute(definition);
            this.sourceLocation = rd != null ? rd.getLocation() : null;
        }
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean enabled = this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel().isDefaultOrExtended();
        this.setStatisticsEnabled(enabled);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Object getInstance() {
        return this.processor;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public ProcessorDefinition<?> getDefinition() {
        return this.definition;
    }

    public String getId() {
        return this.id;
    }

    public String getStepId() {
        return this.stepId;
    }

    public Integer getIndex() {
        return this.definition.getIndex();
    }

    public int getLevel() {
        return this.nodeLevel;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public Integer getSourceLineNumber() {
        int line = this.definition.getLineNumber();
        return line >= 0 ? Integer.valueOf(line) : null;
    }

    public Boolean getSupportExtendedInformation() {
        return false;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public String getState() {
        if (this.processor instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)this.processor).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    public String getCamelId() {
        return this.context.getName();
    }

    public String getCamelManagementName() {
        return this.context.getManagementName();
    }

    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        if (this.processor instanceof RouteIdAware) {
            return ((RouteIdAware)this.processor).getRouteId();
        }
        return null;
    }

    public String getProcessorId() {
        return this.id;
    }

    public String getProcessorName() {
        return this.definition.getShortName();
    }

    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        ServiceHelper.startService((Object)this.getProcessor());
    }

    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        ServiceHelper.stopService((Object)this.getProcessor());
    }

    public String dumpProcessorAsXml() throws Exception {
        ExtendedCamelContext ecc = (ExtendedCamelContext)this.context.adapt(ExtendedCamelContext.class);
        return ecc.getModelToXMLDumper().dumpModelAsXml(this.context, this.definition);
    }
}

