/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedTaskManagerRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.support.task.BackgroundTask;
import org.apache.camel.support.task.Task;
import org.apache.camel.support.task.TaskManagerRegistry;

@ManagedResource(description="Managed TaskManagerRegistry")
public class ManagedTaskManagerRegistry
extends ManagedService
implements ManagedTaskManagerRegistryMBean {
    private final TaskManagerRegistry registry;

    public ManagedTaskManagerRegistry(CamelContext context, TaskManagerRegistry registry) {
        super(context, (Service)registry);
        this.registry = registry;
    }

    public Integer getSize() {
        return this.registry.getSize();
    }

    public TabularData listTasks() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listInternalTaskTabularType());
            for (Task task : this.registry.getTasks()) {
                String name = task.getName();
                String kind = task instanceof BackgroundTask ? "background" : "foreground";
                String status = task.getStatus().name();
                long attempts = task.iteration();
                long delay = task.getCurrentDelay();
                long elapsed = task.getCurrentElapsedTime();
                long firstTime = task.getFirstAttemptTime();
                long lastTime = task.getLastAttemptTime();
                long nextTime = task.getNextAttemptTime();
                String failure = task.getException() != null ? task.getException().getMessage() : null;
                CompositeType ct = CamelOpenMBeanTypes.listInternalTaskCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"name", "kind", "status", "attempts", "delay", "elapsed", "firstTime", "lastTime", "nextTime", "failure"}, new Object[]{name, kind, status, attempts, delay, elapsed, firstTime, lastTime, nextTime, failure});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

