/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.DisabledAware;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedProcessorAware;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;

@ManagedResource(description="Managed Processor")
public class ManagedProcessor
extends ManagedPerformanceCounter
implements ManagedInstance,
ManagedProcessorMBean,
ManagedProcessorAware {
    private final CamelContext context;
    private Processor processor;
    private final ProcessorDefinition<?> definition;
    private final String id;
    private final int nodeLevel;
    private final String stepId;
    private Route route;
    private String sourceLocation;
    private String sourceLocationShort;

    public ManagedProcessor(CamelContext context, Processor processor, ProcessorDefinition<?> definition) {
        StepDefinition stepDefinition;
        this.context = context;
        this.processor = processor;
        this.definition = definition;
        this.nodeLevel = ProcessorDefinitionHelper.getNodeLevel(definition);
        this.id = definition.idOrCreate((NodeIdFactory)context.getCamelContextExtension().getContextPlugin(NodeIdFactory.class));
        StepDefinition step = definition instanceof StepDefinition ? (stepDefinition = (StepDefinition)definition) : (StepDefinition)ProcessorDefinitionHelper.findFirstParentOfType(StepDefinition.class, definition, (boolean)true);
        this.stepId = step != null ? step.idOrCreate((NodeIdFactory)context.getCamelContextExtension().getContextPlugin(NodeIdFactory.class)) : null;
        this.sourceLocation = definition.getLocation();
        if (this.sourceLocation == null) {
            RouteDefinition rd = ProcessorDefinitionHelper.getRoute(definition);
            this.sourceLocation = rd != null ? rd.getLocation() : null;
        }
        this.sourceLocationShort = LoggerHelper.getLineNumberLoggerName(definition);
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean enabled = this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel().isDefaultOrExtended();
        this.setStatisticsEnabled(enabled);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Object getInstance() {
        return this.getProcessor();
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public ProcessorDefinition<?> getDefinition() {
        return this.definition;
    }

    public String getId() {
        return this.id;
    }

    public String getStepId() {
        return this.stepId;
    }

    public Integer getIndex() {
        return this.definition.getIndex();
    }

    public int getLevel() {
        return this.nodeLevel;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public String getSourceLocationShort() {
        return this.sourceLocationShort;
    }

    public Integer getSourceLineNumber() {
        int line = this.definition.getLineNumber();
        return line >= 0 ? Integer.valueOf(line) : null;
    }

    public Boolean getSupportExtendedInformation() {
        return false;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public String getState() {
        Processor processor = this.processor;
        if (processor instanceof StatefulService) {
            StatefulService statefulService = (StatefulService)processor;
            ServiceStatus status = statefulService.getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    public String getCamelId() {
        return this.context.getName();
    }

    public String getCamelManagementName() {
        return this.context.getManagementName();
    }

    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        Processor processor = this.processor;
        if (processor instanceof RouteIdAware) {
            RouteIdAware routeIdAware = (RouteIdAware)processor;
            return routeIdAware.getRouteId();
        }
        return null;
    }

    public String getNodePrefixId() {
        if (this.route != null) {
            return this.route.getNodePrefixId();
        }
        return null;
    }

    public String getProcessorId() {
        return this.id;
    }

    public String getProcessorName() {
        return this.definition.getShortName();
    }

    public String getDescription() {
        return this.definition.getDescription();
    }

    public String getModelLabel() {
        return this.definition.getLabel();
    }

    public String getNote() {
        return this.definition.getNote();
    }

    public Boolean getDisabled() {
        Processor processor = this.processor;
        if (processor instanceof DisabledAware) {
            DisabledAware da = (DisabledAware)processor;
            return da.isDisabled();
        }
        return false;
    }

    public void enable() {
        Processor processor = this.processor;
        if (processor instanceof DisabledAware) {
            DisabledAware da = (DisabledAware)processor;
            da.setDisabled(false);
        }
    }

    public void disable() {
        Processor processor = this.processor;
        if (processor instanceof DisabledAware) {
            DisabledAware da = (DisabledAware)processor;
            da.setDisabled(true);
        }
    }

    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        ServiceHelper.startService((Object)this.getProcessor());
    }

    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        ServiceHelper.stopService((Object)this.getProcessor());
    }

    public String dumpProcessorAsXml() throws Exception {
        return PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml(this.context, this.definition);
    }
}

