/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.util.CastUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.codehaus.mojo.exec.ExecutableDependency;
import org.codehaus.mojo.exec.Property;

public class RunMojo
extends AbstractExecMojo {
    protected MavenProject project;
    protected String duration;
    protected boolean logClasspath;
    protected boolean useBlueprint;
    protected boolean useCDI;
    protected String extendedPluginDependencyArtifactId;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource metadataSource;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private MavenProjectBuilder projectBuilder;
    private List<Artifact> pluginDependencies;
    private boolean trace;
    private String mainClass;
    private String basedPackages;
    private String configClasses;
    private String applicationContextUri;
    private String fileApplicationContextUri;
    private String configAdminPid;
    private String configAdminFileName;
    private String[] arguments;
    private Property[] systemProperties;
    private boolean keepAlive;
    private boolean includeProjectDependencies;
    private boolean includePluginDependencies;
    private ExecutableDependency executableDependency;
    private boolean cleanupDaemonThreads;
    private long daemonThreadJoinTimeout;
    private boolean stopUnresponsiveDaemonThreads;
    private long killAfter;
    private Properties originalSystemProperties;
    private String extraPluginDependencyArtifactId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean usingBlueprintMain;
        boolean usingSpringJavaConfigureMain = false;
        boolean useCdiMain = this.useCDI || this.detectCDIOnClassPath();
        boolean bl = usingBlueprintMain = this.useBlueprint || this.detectBlueprintOnClassPathOrBlueprintXMLFiles();
        if (this.killAfter != -1L) {
            this.getLog().warn((CharSequence)"Warning: killAfter is now deprecated. Do you need it ? Please comment on MEXEC-6.");
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.trace) {
            args.add("-t");
        }
        if (this.applicationContextUri != null) {
            args.add("-ac");
            args.add(this.applicationContextUri);
        } else if (this.fileApplicationContextUri != null) {
            args.add("-fa");
            args.add(this.fileApplicationContextUri);
        }
        if (this.configClasses != null) {
            args.add("-cc");
            args.add(this.configClasses);
            usingSpringJavaConfigureMain = true;
        }
        if (this.basedPackages != null) {
            args.add("-bp");
            args.add(this.basedPackages);
            usingSpringJavaConfigureMain = true;
        }
        args.add("-d");
        args.add(this.duration);
        if (this.arguments != null) {
            args.addAll(Arrays.asList(this.arguments));
        }
        if (usingSpringJavaConfigureMain) {
            this.mainClass = "org.apache.camel.spring.javaconfig.Main";
            this.getLog().info((CharSequence)"Using org.apache.camel.spring.javaconfig.Main to initiate a CamelContext");
        } else if (useCdiMain) {
            this.mainClass = "org.apache.camel.cdi.Main";
            this.extraPluginDependencyArtifactId = "camel-cdi";
            this.getLog().info((CharSequence)("Using " + this.mainClass + " to initiate a CamelContext"));
        } else if (usingBlueprintMain) {
            this.mainClass = "org.apache.camel.test.blueprint.Main";
            this.extraPluginDependencyArtifactId = "camel-test-blueprint";
            if (this.configAdminPid != null) {
                args.add("-pid");
                args.add(this.configAdminPid);
            }
            if (this.configAdminFileName != null) {
                args.add("-pf");
                args.add(this.configAdminFileName);
            }
            this.getLog().info((CharSequence)"Using org.apache.camel.test.blueprint.Main to initiate a CamelContext");
        } else if (this.mainClass != null) {
            this.getLog().info((CharSequence)("Using custom " + this.mainClass + " to initiate a CamelContext"));
        } else {
            this.getLog().info((CharSequence)"Using org.apache.camel.spring.Main to initiate a CamelContext");
            this.mainClass = "org.apache.camel.spring.Main";
        }
        this.arguments = new String[args.size()];
        args.toArray(this.arguments);
        if (this.getLog().isDebugEnabled()) {
            StringBuilder msg = new StringBuilder("Invoking: ");
            msg.append(this.mainClass);
            msg.append(".main(");
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(this.arguments[i]);
            }
            msg.append(")");
            this.getLog().debug((CharSequence)msg);
        }
        IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(this.mainClass);
        Thread bootstrapThread = new Thread(threadGroup, new Runnable(){

            @Override
            public void run() {
                try {
                    RunMojo.this.beforeBootstrapCamel();
                    RunMojo.this.getLog().info((CharSequence)"Starting Camel ...");
                    Method main = Thread.currentThread().getContextClassLoader().loadClass(RunMojo.this.mainClass).getMethod("main", String[].class);
                    main.invoke(null, new Object[]{RunMojo.this.arguments});
                    RunMojo.this.afterBootstrapCamel();
                }
                catch (Exception e) {
                    RunMojo.this.getLog().error((CharSequence)"*************************************");
                    RunMojo.this.getLog().error((CharSequence)("Error occurred while running main from: " + RunMojo.this.mainClass));
                    RunMojo.this.getLog().error((Throwable)e);
                    RunMojo.this.getLog().error((CharSequence)"*************************************");
                    Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), e);
                }
            }
        }, this.mainClass + ".main()");
        bootstrapThread.setContextClassLoader(this.getClassLoader());
        this.setSystemProperties();
        bootstrapThread.start();
        this.joinNonDaemonThreads(threadGroup);
        if (this.keepAlive) {
            this.getLog().warn((CharSequence)"Warning: keepAlive is now deprecated and obsolete. Do you need it? Please comment on MEXEC-6.");
            this.waitFor(0L);
        }
        if (this.cleanupDaemonThreads) {
            this.terminateThreads(threadGroup);
            try {
                threadGroup.destroy();
            }
            catch (IllegalThreadStateException e) {
                this.getLog().warn((CharSequence)("Couldn't destroy threadgroup " + threadGroup), (Throwable)e);
            }
        }
        if (this.originalSystemProperties != null) {
            System.setProperties(this.originalSystemProperties);
        }
        IsolatedThreadGroup isolatedThreadGroup = threadGroup;
        synchronized (isolatedThreadGroup) {
            if (threadGroup.uncaughtException != null) {
                throw new MojoExecutionException(null, threadGroup.uncaughtException);
            }
        }
        this.registerSourceRoots();
    }

    protected void beforeBootstrapCamel() throws Exception {
    }

    protected void afterBootstrapCamel() throws Exception {
    }

    private void joinNonDaemonThreads(ThreadGroup threadGroup) {
        boolean foundNonDaemon;
        do {
            foundNonDaemon = false;
            Collection<Thread> threads = this.getActiveThreads(threadGroup);
            for (Thread thread : threads) {
                if (thread.isDaemon()) continue;
                foundNonDaemon = true;
                this.joinThread(thread, 0L);
            }
        } while (foundNonDaemon);
    }

    private void joinThread(Thread thread, long timeoutMsecs) {
        try {
            this.getLog().debug((CharSequence)("joining on thread " + thread));
            thread.join(timeoutMsecs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getLog().warn((CharSequence)("interrupted while joining against thread " + thread), (Throwable)e);
        }
        if (thread.isAlive()) {
            this.getLog().warn((CharSequence)("thread " + thread + " was interrupted but is still alive after waiting at least " + timeoutMsecs + "msecs"));
        }
    }

    private void terminateThreads(ThreadGroup threadGroup) {
        long startTime = System.currentTimeMillis();
        HashSet<Thread> uncooperativeThreads = new HashSet<Thread>();
        Collection<Thread> threads = this.getActiveThreads(threadGroup);
        while (!threads.isEmpty()) {
            for (Thread thread : threads) {
                this.getLog().debug((CharSequence)("interrupting thread " + thread));
                thread.interrupt();
            }
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                if (this.daemonThreadJoinTimeout <= 0L) {
                    this.joinThread(thread, 0L);
                    continue;
                }
                long timeout = this.daemonThreadJoinTimeout - (System.currentTimeMillis() - startTime);
                if (timeout > 0L) {
                    this.joinThread(thread, timeout);
                }
                if (!thread.isAlive()) continue;
                uncooperativeThreads.add(thread);
                if (this.stopUnresponsiveDaemonThreads) {
                    this.getLog().warn((CharSequence)("thread " + thread + " will be Thread.stop()'ed"));
                    thread.stop();
                    continue;
                }
                this.getLog().warn((CharSequence)("thread " + thread + " will linger despite being asked to die via interruption"));
            }
            threads = this.getActiveThreads(threadGroup);
            threads.removeAll(uncooperativeThreads);
        }
        if (!uncooperativeThreads.isEmpty()) {
            this.getLog().warn((CharSequence)("NOTE: " + uncooperativeThreads.size() + " thread(s) did not finish despite being asked to " + " via interruption. This is not a problem with exec:java, it is a problem with the running code." + " Although not serious, it should be remedied."));
        } else {
            int activeCount = threadGroup.activeCount();
            if (activeCount != 0) {
                Thread[] threadsArray = new Thread[1];
                threadGroup.enumerate(threadsArray);
                this.getLog().debug((CharSequence)("strange; " + activeCount + " thread(s) still active in the group " + threadGroup + " such as " + threadsArray[0]));
            }
        }
    }

    private Collection<Thread> getActiveThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int numThreads = threadGroup.enumerate(threads);
        ArrayList<Thread> result = new ArrayList<Thread>(numThreads);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            result.add(threads[i]);
        }
        return result;
    }

    private void setSystemProperties() {
        if (this.systemProperties != null) {
            this.originalSystemProperties = System.getProperties();
            for (Property systemProperty : this.systemProperties) {
                String value = systemProperty.getValue();
                System.setProperty(systemProperty.getKey(), value == null ? "" : value);
            }
        }
    }

    private boolean detectCDIOnClassPath() {
        List deps = this.project.getCompileDependencies();
        for (Dependency dep : deps) {
            if (!"org.apache.camel".equals(dep.getGroupId()) || !"camel-cdi".equals(dep.getArtifactId())) continue;
            this.getLog().info((CharSequence)"camel-cdi detected on classpath");
            return true;
        }
        return false;
    }

    private boolean detectBlueprintOnClassPathOrBlueprintXMLFiles() {
        List deps = this.project.getCompileDependencies();
        for (Dependency dep : deps) {
            if (!"org.apache.camel".equals(dep.getGroupId()) || !"camel-blueprint".equals(dep.getArtifactId())) continue;
            this.getLog().info((CharSequence)"camel-blueprint detected on classpath");
        }
        List resources = this.project.getResources();
        for (Resource res : resources) {
            File dir = new File(res.getDirectory());
            File xml = new File(dir, "OSGI-INF/blueprint");
            if (!xml.exists() || !xml.isDirectory()) continue;
            this.getLog().info((CharSequence)("OSGi Blueprint XML files detected in directory " + xml));
            return true;
        }
        return false;
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        LinkedHashSet<URL> classpathURLs = new LinkedHashSet<URL>();
        this.addRelevantProjectDependenciesToClasspath(classpathURLs);
        this.addExtraPluginDependenciesToClasspath(classpathURLs);
        this.addRelevantPluginDependenciesToClasspath(classpathURLs);
        if (this.logClasspath) {
            this.getLog().info((CharSequence)"Classpath:");
            for (URL url : classpathURLs) {
                this.getLog().info((CharSequence)("  " + url.getFile().toString()));
            }
        }
        return new URLClassLoader(classpathURLs.toArray(new URL[classpathURLs.size()]));
    }

    private void addRelevantPluginDependenciesToClasspath(Set<URL> path) throws MojoExecutionException {
        if (this.hasCommandlineArgs()) {
            this.arguments = this.parseCommandlineArgs();
        }
        try {
            for (Artifact classPathElement : this.determineRelevantPluginDependencies()) {
                if (classPathElement.getArtifactId().equals("org.osgi.core")) {
                    this.getLog().debug((CharSequence)("Skipping org.osgi.core -> " + classPathElement.getGroupId() + "/" + classPathElement.getArtifactId() + "/" + classPathElement.getVersion()));
                    continue;
                }
                this.getLog().debug((CharSequence)("Adding plugin dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                path.add(classPathElement.getFile().toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    private void addExtraPluginDependenciesToClasspath(Set<URL> path) throws MojoExecutionException {
        if (this.extraPluginDependencyArtifactId == null && this.extendedPluginDependencyArtifactId == null) {
            return;
        }
        try {
            HashSet<Artifact> artifacts = new HashSet<Artifact>(this.pluginDependencies);
            for (Artifact artifact : artifacts) {
                if (!artifact.getArtifactId().equals(this.extraPluginDependencyArtifactId) && !artifact.getArtifactId().equals(this.extendedPluginDependencyArtifactId)) continue;
                this.getLog().debug((CharSequence)("Adding extra plugin dependency artifact: " + artifact.getArtifactId() + " to classpath"));
                path.add(artifact.getFile().toURI().toURL());
                Set<Artifact> deps = this.resolveExecutableDependencies(artifact, true);
                if (deps == null) continue;
                for (Artifact dep : deps) {
                    this.getLog().debug((CharSequence)("Adding extra plugin dependency artifact: " + dep.getArtifactId() + " to classpath"));
                    path.add(dep.getFile().toURI().toURL());
                }
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    private void addRelevantProjectDependenciesToClasspath(Set<URL> path) throws MojoExecutionException {
        if (this.includeProjectDependencies) {
            try {
                this.getLog().debug((CharSequence)"Project Dependencies will be included.");
                URL mainClasses = new File(this.project.getBuild().getOutputDirectory()).toURI().toURL();
                this.getLog().debug((CharSequence)("Adding to classpath : " + mainClasses));
                path.add(mainClasses);
                Set dependencies = CastUtils.cast((Set)this.project.getArtifacts());
                dependencies.addAll(this.getAllNonTestScopedDependencies());
                for (Artifact classPathElement : dependencies) {
                    this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                    File file = classPathElement.getFile();
                    if (file == null) continue;
                    path.add(file.toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
            }
        } else {
            this.getLog().debug((CharSequence)"Project Dependencies will be excluded.");
        }
    }

    private Collection<Artifact> getAllNonTestScopedDependencies() throws MojoExecutionException {
        ArrayList<Artifact> answer = new ArrayList<Artifact>();
        for (Artifact artifact : this.getAllDependencies()) {
            if (artifact.getScope().equals("test")) continue;
            answer.add(artifact);
        }
        return answer;
    }

    private Collection<Artifact> getAllDependencies() throws MojoExecutionException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Dependency dependency : this.project.getDependencies()) {
            VersionRange versionRange;
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            try {
                versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("unable to parse version", (Exception)((Object)e));
            }
            String type = dependency.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dependency.getClassifier();
            boolean optional = dependency.isOptional();
            String scope = dependency.getScope();
            if (scope == null) {
                scope = "compile";
            }
            Artifact art = this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, null, optional);
            if (scope.equalsIgnoreCase("system")) {
                art.setFile(new File(dependency.getSystemPath()));
            }
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion exclusion : dependency.getExclusions()) {
                exclusions.add(exclusion.getGroupId() + ":" + exclusion.getArtifactId());
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            art.setDependencyFilter((ArtifactFilter)newFilter);
            artifacts.add(art);
        }
        return artifacts;
    }

    private Set<Artifact> determineRelevantPluginDependencies() throws MojoExecutionException {
        Set<Object> relevantDependencies;
        if (this.includePluginDependencies) {
            if (this.executableDependency == null) {
                this.getLog().debug((CharSequence)"All Plugin Dependencies will be included.");
                relevantDependencies = new HashSet<Artifact>(this.pluginDependencies);
            } else {
                this.getLog().debug((CharSequence)"Selected plugin Dependencies will be included.");
                Artifact executableArtifact = this.findExecutableArtifact();
                Artifact executablePomArtifact = this.getExecutablePomArtifact(executableArtifact);
                relevantDependencies = this.resolveExecutableDependencies(executablePomArtifact, false);
            }
        } else {
            this.getLog().debug((CharSequence)"Only Direct Plugin Dependencies will be included.");
            PluginDescriptor descriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
            try {
                relevantDependencies = this.artifactResolver.resolveTransitively(MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)descriptor.getPlugin().getDependencies(), null, null, null), this.project.getArtifact(), Collections.emptyMap(), this.localRepository, this.remoteRepositories, this.metadataSource, (ArtifactFilter)new ScopeArtifactFilter("runtime"), Collections.emptyList()).getArtifacts();
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Encountered problems resolving dependencies of the plugin in preparation for its execution.", ex);
            }
        }
        return relevantDependencies;
    }

    private Artifact getExecutablePomArtifact(Artifact executableArtifact) {
        return this.artifactFactory.createBuildArtifact(executableArtifact.getGroupId(), executableArtifact.getArtifactId(), executableArtifact.getVersion(), "pom");
    }

    private Artifact findExecutableArtifact() throws MojoExecutionException {
        Artifact executableTool = null;
        for (Artifact pluginDep : this.pluginDependencies) {
            if (!this.executableDependency.matches(pluginDep)) continue;
            executableTool = pluginDep;
            break;
        }
        if (executableTool == null) {
            throw new MojoExecutionException("No dependency of the plugin matches the specified executableDependency.  Specified executableToolAssembly is: " + this.executableDependency.toString());
        }
        return executableTool;
    }

    private Set<Artifact> resolveExecutableDependencies(Artifact executablePomArtifact, boolean ignoreFailures) throws MojoExecutionException {
        Set executableDependencies = null;
        try {
            MavenProject executableProject = this.projectBuilder.buildFromRepository(executablePomArtifact, this.remoteRepositories, this.localRepository);
            List dependencies = CastUtils.cast((List)executableProject.getDependencies());
            Set dependencyArtifacts = CastUtils.cast((Set)MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)dependencies, null, null, null));
            dependencyArtifacts.add(executableProject.getArtifact());
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencyArtifacts, executablePomArtifact, Collections.emptyMap(), this.localRepository, this.remoteRepositories, this.metadataSource, (ArtifactFilter)new ScopeArtifactFilter("runtime"), Collections.emptyList());
            executableDependencies = CastUtils.cast((Set)result.getArtifacts());
        }
        catch (Exception ex) {
            if (ignoreFailures) {
                this.getLog().debug((CharSequence)("Ignoring maven resolving dependencies failure " + ex.getMessage()));
            }
            throw new MojoExecutionException("Encountered problems resolving dependencies of the executable in preparation for its execution.", ex);
        }
        return executableDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(long millis) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.getLog().warn((CharSequence)("Spuriously interrupted while waiting for " + millis + "ms"), (Throwable)e);
            }
        }
    }

    class IsolatedThreadGroup
    extends ThreadGroup {
        Throwable uncaughtException;

        IsolatedThreadGroup(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            boolean doLog = false;
            IsolatedThreadGroup isolatedThreadGroup = this;
            synchronized (isolatedThreadGroup) {
                if (this.uncaughtException == null) {
                    this.uncaughtException = throwable;
                } else {
                    doLog = true;
                }
            }
            if (doLog) {
                RunMojo.this.getLog().warn((CharSequence)"an additional exception was thrown", throwable);
            }
        }
    }
}

