/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.EndpointValidationResult;
import org.apache.camel.catalog.SimpleValidationResult;
import org.apache.camel.catalog.SuggestionStrategy;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.catalog.lucene.LuceneSuggestionStrategy;
import org.apache.camel.catalog.maven.MavenVersionManager;
import org.apache.camel.maven.helper.EndpointHelper;
import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.XmlRouteParser;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.apache.camel.parser.model.CamelSimpleExpressionDetails;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;

public class ValidateMojo
extends AbstractExecMojo {
    protected MavenProject project;
    private boolean failOnError;
    private boolean logUnparseable;
    private boolean includeJava;
    private boolean includeXml;
    private boolean includeTest;
    private String includes;
    private String excludes;
    private boolean ignoreUnknownComponent;
    private boolean ignoreIncapable;
    private boolean ignoreLenientProperties;
    private boolean showAll;
    private boolean downloadVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String simpleSummary;
        String endpointSummary;
        int ok;
        ArrayList fileSimpleExpressions;
        ArrayList fileEndpoints;
        String dir;
        Object obj;
        Iterator iterator;
        Object list;
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        catalog.addComponent("activemq", "org.apache.activemq.camel.component.ActiveMQComponent");
        catalog.setSuggestionStrategy((SuggestionStrategy)new LuceneSuggestionStrategy());
        catalog.setVersionManager((VersionManager)new MavenVersionManager());
        catalog.enableCache();
        if (this.downloadVersion) {
            String catalogVersion = catalog.getCatalogVersion();
            String version = ValidateMojo.findCamelVersion(this.project);
            if (version != null && !version.equals(catalogVersion)) {
                this.getLog().info((CharSequence)("Downloading Camel version: " + version));
                boolean loaded = catalog.loadVersion(version);
                if (!loaded) {
                    this.getLog().warn((CharSequence)("Error downloading Camel version: " + version));
                }
            }
        }
        if (catalog.getLoadedVersion() == null) {
            catalog.loadVersion(catalog.getCatalogVersion());
        }
        if (catalog.getLoadedVersion() != null) {
            this.getLog().info((CharSequence)("Using Camel version: " + catalog.getLoadedVersion()));
        } else {
            this.getLog().info((CharSequence)("Using Camel version: " + catalog.getCatalogVersion()));
        }
        ArrayList endpoints = new ArrayList();
        ArrayList simpleExpressions = new ArrayList();
        LinkedHashSet<File> javaFiles = new LinkedHashSet<File>();
        LinkedHashSet<File> xmlFiles = new LinkedHashSet<File>();
        if (this.includeJava) {
            list = this.project.getCompileSourceRoots();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                obj = iterator.next();
                dir = (String)obj;
                this.findJavaFiles(new File(dir), javaFiles);
            }
            if (this.includeTest) {
                list = this.project.getTestCompileSourceRoots();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    obj = iterator.next();
                    dir = (String)obj;
                    this.findJavaFiles(new File(dir), javaFiles);
                }
            }
        }
        if (this.includeXml) {
            list = this.project.getResources();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                obj = iterator.next();
                dir = (Resource)obj;
                this.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
            }
            if (this.includeTest) {
                list = this.project.getTestResources();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    obj = iterator.next();
                    dir = (Resource)obj;
                    this.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
                }
            }
        }
        for (File file : javaFiles) {
            if (!this.matchFile(file)) continue;
            try {
                fileEndpoints = new ArrayList();
                fileSimpleExpressions = new ArrayList();
                ArrayList unparsable = new ArrayList();
                String fqn = file.getPath();
                String baseDir = ".";
                JavaType out = Roaster.parse((File)file);
                if (out == null || !(out instanceof JavaClassSource)) continue;
                JavaClassSource clazz = (JavaClassSource)out;
                RouteBuilderParser.parseRouteBuilderEndpoints((JavaClassSource)clazz, (String)baseDir, (String)fqn, fileEndpoints, unparsable, (boolean)this.includeTest);
                RouteBuilderParser.parseRouteBuilderSimpleExpressions((JavaClassSource)clazz, (String)baseDir, (String)fqn, fileSimpleExpressions);
                endpoints.addAll(fileEndpoints);
                simpleExpressions.addAll(fileSimpleExpressions);
                if (!this.logUnparseable || unparsable.isEmpty()) continue;
                for (String uri : unparsable) {
                    this.getLog().warn((CharSequence)("Cannot parse endpoint uri " + uri + " in java file " + file));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing java file " + file + " code due " + e.getMessage()), (Throwable)e);
            }
        }
        for (File file : xmlFiles) {
            if (!this.matchFile(file)) continue;
            try {
                fileEndpoints = new ArrayList();
                fileSimpleExpressions = new ArrayList();
                String fqn = file.getPath();
                String baseDir = ".";
                FileInputStream is = new FileInputStream(file);
                XmlRouteParser.parseXmlRouteEndpoints((InputStream)is, (String)baseDir, (String)fqn, fileEndpoints);
                ((InputStream)is).close();
                is = new FileInputStream(file);
                XmlRouteParser.parseXmlRouteSimpleExpressions((InputStream)is, (String)baseDir, (String)fqn, fileSimpleExpressions);
                ((InputStream)is).close();
                endpoints.addAll(fileEndpoints);
                simpleExpressions.addAll(fileSimpleExpressions);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing xml file " + file + " code due " + e.getMessage()), (Throwable)e);
            }
        }
        int endpointErrors = 0;
        int unknownComponents = 0;
        int incapableErrors = 0;
        for (CamelEndpointDetails detail : endpoints) {
            String fqn;
            StringBuilder sb;
            this.getLog().debug((CharSequence)("Validating endpoint: " + detail.getEndpointUri()));
            EndpointValidationResult result = catalog.validateEndpointProperties(detail.getEndpointUri(), this.ignoreLenientProperties);
            boolean ok2 = result.isSuccess();
            if (!ok2 && this.ignoreUnknownComponent && result.getUnknownComponent() != null) {
                ++unknownComponents;
                ok2 = true;
            }
            if (!ok2 && this.ignoreIncapable && result.getIncapable() != null) {
                ++incapableErrors;
                ok2 = true;
            }
            if (!ok2) {
                if (result.getUnknownComponent() != null) {
                    ++unknownComponents;
                } else if (result.getIncapable() != null) {
                    ++incapableErrors;
                } else {
                    ++endpointErrors;
                }
                sb = new StringBuilder();
                sb.append("Endpoint validation error at: ");
                if (detail.getClassName() != null && detail.getLineNumber() != null) {
                    sb.append(detail.getClassName());
                    if (detail.getMethodName() != null) {
                        sb.append(".").append(detail.getMethodName());
                    }
                    sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                    sb.append(detail.getLineNumber()).append(")");
                } else if (detail.getLineNumber() != null) {
                    fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                    if (fqn.endsWith(".xml")) {
                        fqn = fqn.substring(0, fqn.length() - 4);
                        fqn = ValidateMojo.asPackageName(fqn);
                    }
                    sb.append(fqn);
                    sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                    sb.append(detail.getLineNumber()).append(")");
                } else {
                    sb.append(detail.getFileName());
                }
                sb.append("\n\n");
                String out = result.summaryErrorMessage(false);
                sb.append(out);
                sb.append("\n\n");
                this.getLog().warn((CharSequence)sb.toString());
                continue;
            }
            if (!this.showAll) continue;
            sb = new StringBuilder();
            sb.append("Endpoint validation passsed at: ");
            if (detail.getClassName() != null && detail.getLineNumber() != null) {
                sb.append(detail.getClassName());
                if (detail.getMethodName() != null) {
                    sb.append(".").append(detail.getMethodName());
                }
                sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                sb.append(detail.getLineNumber()).append(")");
            } else if (detail.getLineNumber() != null) {
                fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                if (fqn.endsWith(".xml")) {
                    fqn = fqn.substring(0, fqn.length() - 4);
                    fqn = ValidateMojo.asPackageName(fqn);
                }
                sb.append(fqn);
                sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                sb.append(detail.getLineNumber()).append(")");
            } else {
                sb.append(detail.getFileName());
            }
            sb.append("\n");
            sb.append("\n\t").append(result.getUri());
            sb.append("\n\n");
            this.getLog().info((CharSequence)sb.toString());
        }
        if (endpointErrors == 0) {
            ok = endpoints.size() - endpointErrors - incapableErrors - unknownComponents;
            endpointSummary = String.format("Endpoint validation success: (%s = passed, %s = invalid, %s = incapable, %s = unknown components)", ok, endpointErrors, incapableErrors, unknownComponents);
        } else {
            ok = endpoints.size() - endpointErrors - incapableErrors - unknownComponents;
            endpointSummary = String.format("Endpoint validation error: (%s = passed, %s = invalid, %s = incapable, %s = unknown components)", ok, endpointErrors, incapableErrors, unknownComponents);
        }
        if (endpointErrors > 0) {
            this.getLog().warn((CharSequence)endpointSummary);
        } else {
            this.getLog().info((CharSequence)endpointSummary);
        }
        int simpleErrors = 0;
        for (CamelSimpleExpressionDetails detail : simpleExpressions) {
            String fqn;
            StringBuilder sb;
            SimpleValidationResult result;
            boolean predicate = detail.isPredicate();
            if (predicate) {
                this.getLog().debug((CharSequence)("Validating simple predicate: " + detail.getSimple()));
                result = catalog.validateSimplePredicate(detail.getSimple());
            } else {
                this.getLog().debug((CharSequence)("Validating simple expression: " + detail.getSimple()));
                result = catalog.validateSimpleExpression(detail.getSimple());
            }
            if (!result.isSuccess()) {
                String[] lines;
                ++simpleErrors;
                sb = new StringBuilder();
                sb.append("Simple validation error at: ");
                if (detail.getClassName() != null && detail.getLineNumber() != null) {
                    sb.append(detail.getClassName());
                    if (detail.getMethodName() != null) {
                        sb.append(".").append(detail.getMethodName());
                    }
                    sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                    sb.append(detail.getLineNumber()).append(")");
                } else if (detail.getLineNumber() != null) {
                    fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                    if (fqn.endsWith(".xml")) {
                        fqn = fqn.substring(0, fqn.length() - 4);
                        fqn = ValidateMojo.asPackageName(fqn);
                    }
                    sb.append(fqn);
                    sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                    sb.append(detail.getLineNumber()).append(")");
                } else {
                    sb.append(detail.getFileName());
                }
                sb.append("\n");
                for (String line : lines = result.getError().split("\n")) {
                    sb.append("\n\t").append(line);
                }
                sb.append("\n");
                this.getLog().warn((CharSequence)sb.toString());
                continue;
            }
            if (!this.showAll) continue;
            sb = new StringBuilder();
            sb.append("Simple validation passed at: ");
            if (detail.getClassName() != null && detail.getLineNumber() != null) {
                sb.append(detail.getClassName());
                if (detail.getMethodName() != null) {
                    sb.append(".").append(detail.getMethodName());
                }
                sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                sb.append(detail.getLineNumber()).append(")");
            } else if (detail.getLineNumber() != null) {
                fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                if (fqn.endsWith(".xml")) {
                    fqn = fqn.substring(0, fqn.length() - 4);
                    fqn = ValidateMojo.asPackageName(fqn);
                }
                sb.append(fqn);
                sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                sb.append(detail.getLineNumber()).append(")");
            } else {
                sb.append(detail.getFileName());
            }
            sb.append("\n");
            sb.append("\n\t").append(result.getSimple());
            sb.append("\n\n");
            this.getLog().info((CharSequence)sb.toString());
        }
        if (simpleErrors == 0) {
            int ok3 = simpleExpressions.size() - simpleErrors;
            simpleSummary = String.format("Simple validation success: (%s = passed, %s = invalid)", ok3, simpleErrors);
        } else {
            int ok4 = simpleExpressions.size() - simpleErrors;
            simpleSummary = String.format("Simple validation error: (%s = passed, %s = invalid)", ok4, simpleErrors);
        }
        if (this.failOnError && (endpointErrors > 0 || simpleErrors > 0)) {
            throw new MojoExecutionException(endpointSummary + "\n" + simpleSummary);
        }
        if (simpleErrors > 0) {
            this.getLog().warn((CharSequence)simpleSummary);
        } else {
            this.getLog().info((CharSequence)simpleSummary);
        }
    }

    private static String findCamelVersion(MavenProject project) {
        Dependency candidate = null;
        List list = project.getDependencies();
        for (Object obj : list) {
            Dependency dep = (Dependency)obj;
            if (!"org.apache.camel".equals(dep.getGroupId())) continue;
            if ("camel-core".equals(dep.getArtifactId())) {
                candidate = dep;
                break;
            }
            candidate = dep;
        }
        if (candidate != null) {
            return candidate.getVersion();
        }
        return null;
    }

    private void findJavaFiles(File dir, Set<File> javaFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".java")) {
                    javaFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findJavaFiles(file, javaFiles);
            }
        }
    }

    private void findXmlFiles(File dir, Set<File> xmlFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".xml")) {
                    xmlFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findXmlFiles(file, xmlFiles);
            }
        }
    }

    private boolean matchFile(File file) {
        boolean match;
        String fqn;
        if (this.excludes == null && this.includes == null) {
            return true;
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes.split(",")) {
                exclude = exclude.trim();
                fqn = this.stripRootPath(this.asRelativeFile(file.getAbsolutePath()));
                boolean bl = match = EndpointHelper.matchPattern(fqn, exclude) || EndpointHelper.matchPattern(file.getName(), exclude);
                if (!match) continue;
                return false;
            }
        }
        if (this.includes != null) {
            for (String include : this.includes.split(",")) {
                include = include.trim();
                fqn = this.stripRootPath(this.asRelativeFile(file.getAbsolutePath()));
                boolean bl = match = EndpointHelper.matchPattern(fqn, include) || EndpointHelper.matchPattern(file.getName(), include);
                if (!match) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String asRelativeFile(String name) {
        String answer = name;
        String base = this.project.getBasedir().getAbsolutePath();
        if (name.startsWith(base) && (answer = name.substring(base.length())).startsWith(File.separator)) {
            answer = answer.substring(1);
        }
        return answer;
    }

    private String stripRootPath(String name) {
        String dir;
        Resource resource;
        String dir2;
        List list = this.project.getCompileSourceRoots();
        for (Object obj : list) {
            dir2 = (String)obj;
            if (!name.startsWith(dir2 = this.asRelativeFile(dir2))) continue;
            return name.substring(dir2.length() + 1);
        }
        list = this.project.getTestCompileSourceRoots();
        for (Object obj : list) {
            dir2 = (String)obj;
            if (!name.startsWith(dir2 = this.asRelativeFile(dir2))) continue;
            return name.substring(dir2.length() + 1);
        }
        List resources = this.project.getResources();
        for (Object obj : resources) {
            resource = (Resource)obj;
            dir = this.asRelativeFile(resource.getDirectory());
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        resources = this.project.getTestResources();
        for (Object obj : resources) {
            resource = (Resource)obj;
            dir = this.asRelativeFile(resource.getDirectory());
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        return name;
    }

    private static String asPackageName(String name) {
        return name.replace(File.separator, ".");
    }

    private static String asSimpleClassName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot > 0) {
            return className.substring(dot + 1);
        }
        return className;
    }
}

