/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.camel.maven.EmbeddedMojo;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class DotMojo
extends AbstractMavenReport {
    public static final String[] DEFAULT_GRAPHVIZ_OUTPUT_TYPES = new String[]{"png", "svg", "cmapx"};
    protected static final String SUBDIRECTORY = "cameldoc";
    protected String duration;
    protected boolean runCamel;
    protected boolean useDot;
    protected String applicationContextUri;
    protected String fileApplicationContextUri;
    private String mainClass;
    private MavenProject project;
    private File buildDirectory;
    private File outputDirectory;
    private String aggregate;
    private String executable;
    private String graphvizOutputType;
    private String[] graphvizOutputTypes;
    private Renderer renderer;
    private String indexHtmlContent;

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.dot.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.dot.name");
    }

    public String getOutputName() {
        return "cameldoc/index";
    }

    public String getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(String aggregate) {
        this.aggregate = aggregate;
    }

    public boolean isUseDot() {
        return this.useDot;
    }

    public void setUseDot(boolean useDot) {
        this.useDot = useDot;
    }

    public void execute() throws MojoExecutionException {
        this.execute(this.buildDirectory, Locale.getDefault());
        try {
            this.writeIndexHtmlFile(this.outputDirectory, "index.html", this.indexHtmlContent);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed: " + e, (Exception)e);
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.execute(this.outputDirectory, locale);
            Sink kitchenSink = this.getSink();
            if (kitchenSink != null) {
                kitchenSink.rawText(this.indexHtmlContent);
            } else {
                this.writeIndexHtmlFile(this.outputDirectory, "index.html", this.indexHtmlContent);
            }
        }
        catch (Exception e) {
            MavenReportException ex = new MavenReportException(e.getMessage());
            ex.initCause(e.getCause());
            throw ex;
        }
    }

    protected void execute(File outputDir, Locale locale) throws MojoExecutionException {
        try {
            this.runCamelEmbedded(outputDir);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed: " + (Object)((Object)e), (Exception)((Object)e));
        }
        outputDir.mkdirs();
        ArrayList<File> files = new ArrayList<File>();
        this.appendFiles(files, this.outputDirectory);
        if (this.graphvizOutputTypes == null) {
            this.graphvizOutputTypes = this.graphvizOutputType == null ? DEFAULT_GRAPHVIZ_OUTPUT_TYPES : new String[]{this.graphvizOutputType};
        }
        try {
            HashSet<String> contextNames = new HashSet<String>();
            for (File file : files) {
                String contextName = file.getParentFile().getName();
                contextNames.add(contextName);
            }
            boolean multipleCamelContexts = contextNames.size() > 1;
            int size = files.size();
            for (int i = 0; i < size; ++i) {
                File file = (File)files.get(i);
                String contextName = null;
                if (multipleCamelContexts) {
                    contextName = file.getParentFile().getName();
                }
                this.getLog().info((CharSequence)("Generating contextName: " + contextName + " file: " + file + ""));
                this.generate(i, file, contextName);
            }
            if (multipleCamelContexts) {
                StringWriter buffer = new StringWriter();
                PrintWriter out = new PrintWriter(buffer);
                out.println("<h1>Camel Contexts</h1>");
                out.println();
                out.println("<ul>");
                for (String contextName : contextNames) {
                    out.print("  <li><a href='");
                    out.print(contextName);
                    out.print("/routes.html'>");
                    out.print(contextName);
                    out.println("</a></li>");
                }
                out.println("</ul>");
                this.indexHtmlContent = buffer.toString();
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed: " + e, (Exception)e);
        }
    }

    private void generate(int index, File file, String contextName) throws CommandLineException, MojoExecutionException, IOException {
        int idx;
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        this.printHtmlHeader(out, contextName);
        this.printHtmlFileHeader(out, file);
        for (int j = 0; j < this.graphvizOutputTypes.length; ++j) {
            String format = this.graphvizOutputTypes[j];
            String generated = this.convertFile(file, format);
            if (!format.equals("cmapx") || generated == null) continue;
            this.addFileToBuffer(out, new File(generated));
        }
        this.printHtmlFileFooter(out, file);
        this.printHtmlFooter(out);
        String content = buffer.toString();
        String name = file.getName();
        if (name.equalsIgnoreCase("routes.dot") || index == 0) {
            this.indexHtmlContent = content;
        }
        if ((idx = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, idx);
            name = name + ".html";
        }
        this.writeIndexHtmlFile(file.getParentFile(), name, content);
    }

    protected void runCamelEmbedded(File outputDir) throws DependencyResolutionRequiredException {
        if (this.runCamel) {
            if (this.applicationContextUri != null) {
                this.getLog().info((CharSequence)("Running Camel embedded to load Spring XML files from classpath: " + this.applicationContextUri));
            } else if (this.fileApplicationContextUri != null) {
                this.getLog().info((CharSequence)("Running Camel embedded to load Spring XML files from file path: " + this.fileApplicationContextUri));
            } else {
                this.getLog().info((CharSequence)"Running Camel embedded to load Spring XML files from default path: META-INF/spring/*.xml");
            }
            List list = this.project.getTestClasspathElements();
            this.getLog().debug((CharSequence)("Using classpath: " + list));
            EmbeddedMojo mojo = new EmbeddedMojo();
            mojo.setClasspathElements(list);
            mojo.setDotEnabled(true);
            mojo.setMainClass(this.mainClass);
            if ("true".equals(this.getAggregate())) {
                mojo.setDotAggregationEnabled(true);
            }
            mojo.setOutputDirectory(this.outputDirectory.getAbsolutePath());
            mojo.setDuration(this.duration);
            mojo.setLog(this.getLog());
            mojo.setPluginContext(this.getPluginContext());
            mojo.setApplicationContextUri(this.applicationContextUri);
            mojo.setFileApplicationContextUri(this.fileApplicationContextUri);
            try {
                mojo.executeWithoutWrapping();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Failed to run Camel embedded: " + e), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeIndexHtmlFile(File dir, String fileName, String content) throws IOException {
        dir.mkdirs();
        File html = new File(dir, fileName);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(html));
            out.println("<html>");
            out.println("<head>");
            out.println("</head>");
            out.println("<body>");
            out.println();
            if (content == null) {
                out.write("<p>No EIP diagrams available</p>");
            } else {
                out.write(content);
            }
            out.println("</body>");
            out.println("</html>");
        }
        finally {
            String description = "Failed to close html output file";
            this.close(out, description);
        }
    }

    protected void printHtmlHeader(PrintWriter out, String contextName) {
        if (contextName != null) {
            out.println("<h1>EIP Patterns for CamelContext: " + contextName + "</h1>");
        } else {
            out.println("<h1>Camel EIP Patterns</h1>");
        }
        out.println();
    }

    protected void printHtmlFileHeader(PrintWriter out, File file) {
        out.println("<p>");
        out.println("  <img src='" + this.removeFileExtension(file.getName()) + ".png' usemap='#CamelRoutes'>");
    }

    protected void printHtmlFileFooter(PrintWriter out, File file) {
        out.println("  </img>");
        out.println("</p>");
        out.println();
    }

    protected void printHtmlFooter(PrintWriter out) {
        out.println();
    }

    protected void close(Closeable closeable, String description) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)(description + ": " + e));
            }
        }
    }

    protected String convertFile(File file, String format) throws CommandLineException {
        String errOutput;
        Log log = this.getLog();
        if (!this.useDot) {
            log.info((CharSequence)"DOT generation disabled.");
            return null;
        }
        if (this.dotHelpExitCode() != 0) {
            log.info((CharSequence)"'dot -?' execution failed so DOT generation disabled.");
            return null;
        }
        if (this.executable == null || this.executable.length() == 0) {
            log.warn((CharSequence)"Parameter <executable/> was not set in the pom.xml.  Skipping conversion.");
            return null;
        }
        String generatedFileName = this.removeFileExtension(file.getAbsolutePath()) + "." + format;
        Commandline cl = new Commandline();
        cl.setExecutable(this.executable);
        cl.createArgument().setValue("-T" + format);
        cl.createArgument().setValue("-o");
        cl.createArgument().setValue(generatedFileName);
        cl.createArgument().setValue(file.getAbsolutePath());
        log.debug((CharSequence)("executing: " + cl.toString()));
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        String output = stdout.getOutput();
        if (output.length() > 0) {
            log.debug((CharSequence)output);
        }
        if ((errOutput = stderr.getOutput()).length() > 0) {
            log.warn((CharSequence)errOutput);
        }
        return generatedFileName;
    }

    private int dotHelpExitCode() throws CommandLineException {
        Commandline cl = new Commandline();
        cl.setExecutable(this.executable);
        cl.createArgument().setValue("-?");
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        return CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
    }

    protected String removeFileExtension(String name) {
        int idx = name.lastIndexOf(".");
        if (idx > 0) {
            return name.substring(0, idx);
        }
        return name;
    }

    private void appendFiles(List<File> output, File file) {
        if (file.isDirectory()) {
            this.appendDirectory(output, file);
        } else if (this.isValid(file)) {
            output.add(file);
        }
    }

    private void appendDirectory(List<File> output, File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            this.appendFiles(output, file);
        }
    }

    private boolean isValid(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".dot");
    }

    private void addFileToBuffer(PrintWriter out, File file) throws MojoExecutionException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                out.println(line);
            }
            this.close(reader, "cmapx file");
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed: " + e, (Exception)e);
            }
            catch (Throwable throwable) {
                this.close(reader, "cmapx file");
                throw throwable;
            }
        }
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("camel-maven-plugin", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected Renderer getSiteRenderer() {
        return this.renderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }
}

