/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.util.CastUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.codehaus.mojo.exec.ExecutableDependency;
import org.codehaus.mojo.exec.Property;

public class RunMojo
extends AbstractExecMojo {
    protected MavenProject project;
    protected String duration;
    protected String dotDir;
    protected boolean useDot;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource metadataSource;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private MavenProjectBuilder projectBuilder;
    private List<Artifact> pluginDependencies;
    private boolean trace;
    private String routesOutputFile;
    private String mainClass;
    private String basedPackages;
    private String configClasses;
    private String applicationContextUri;
    private String fileApplicationContextUri;
    private String[] arguments;
    private Property[] systemProperties;
    private boolean keepAlive;
    private boolean includeProjectDependencies;
    private boolean includePluginDependencies;
    private ExecutableDependency executableDependency;
    private boolean cleanupDaemonThreads;
    private long daemonThreadJoinTimeout;
    private boolean stopUnresponsiveDaemonThreads;
    private long killAfter;
    private Properties originalSystemProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean usingSpringJavaConfigureMain = false;
        if (this.killAfter != -1L) {
            this.getLog().warn((CharSequence)"Warning: killAfter is now deprecated. Do you need it ? Please comment on MEXEC-6.");
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.dotDir != null && this.useDot) {
            args.add("-o");
            args.add(this.dotDir);
        }
        if (this.trace) {
            args.add("-t");
        }
        if (this.routesOutputFile != null) {
            args.add("-output");
            args.add(this.routesOutputFile);
        }
        if (this.applicationContextUri != null) {
            args.add("-ac");
            args.add(this.applicationContextUri);
        } else if (this.fileApplicationContextUri != null) {
            args.add("-fa");
            args.add(this.fileApplicationContextUri);
        }
        if (this.configClasses != null) {
            args.add("-cc");
            args.add(this.configClasses);
            usingSpringJavaConfigureMain = true;
        }
        if (this.basedPackages != null) {
            args.add("-bp");
            args.add(this.basedPackages);
            usingSpringJavaConfigureMain = true;
        }
        args.add("-d");
        args.add(this.duration);
        if (this.arguments != null) {
            args.addAll(Arrays.asList(this.arguments));
        }
        this.arguments = new String[args.size()];
        args.toArray(this.arguments);
        if (usingSpringJavaConfigureMain) {
            this.mainClass = "org.apache.camel.spring.javaconfig.Main";
            this.getLog().info((CharSequence)"Using the org.apache.camel.spring.javaconfig.Main to initiate a CamelContext");
        }
        if (this.getLog().isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("Invoking : ");
            msg.append(this.mainClass);
            msg.append(".main(");
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(this.arguments[i]);
            }
            msg.append(")");
            this.getLog().debug((CharSequence)msg);
        }
        IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(this.mainClass);
        Thread bootstrapThread = new Thread(threadGroup, new Runnable(){

            @Override
            public void run() {
                try {
                    Method main = Thread.currentThread().getContextClassLoader().loadClass(RunMojo.this.mainClass).getMethod("main", String[].class);
                    if (!main.isAccessible()) {
                        RunMojo.this.getLog().debug((CharSequence)"Setting accessibility to true in order to invoke main().");
                        main.setAccessible(true);
                    }
                    main.invoke((Object)main, new Object[]{RunMojo.this.arguments});
                }
                catch (Exception e) {
                    System.err.println("*************************************");
                    System.err.println("Error occurred while running main from: " + RunMojo.this.mainClass);
                    e.printStackTrace();
                    System.err.println("*************************************");
                    Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), e);
                }
            }
        }, this.mainClass + ".main()");
        bootstrapThread.setContextClassLoader(this.getClassLoader());
        this.setSystemProperties();
        bootstrapThread.start();
        this.joinNonDaemonThreads(threadGroup);
        if (this.keepAlive) {
            this.getLog().warn((CharSequence)"Warning: keepAlive is now deprecated and obsolete. Do you need it? Please comment on MEXEC-6.");
            this.waitFor(0L);
        }
        if (this.cleanupDaemonThreads) {
            this.terminateThreads(threadGroup);
            try {
                threadGroup.destroy();
            }
            catch (IllegalThreadStateException e) {
                this.getLog().warn((CharSequence)("Couldn't destroy threadgroup " + threadGroup), (Throwable)e);
            }
        }
        if (this.originalSystemProperties != null) {
            System.setProperties(this.originalSystemProperties);
        }
        IsolatedThreadGroup isolatedThreadGroup = threadGroup;
        synchronized (isolatedThreadGroup) {
            if (threadGroup.uncaughtException != null) {
                throw new MojoExecutionException(null, threadGroup.uncaughtException);
            }
        }
        this.registerSourceRoots();
    }

    private void joinNonDaemonThreads(ThreadGroup threadGroup) {
        boolean foundNonDaemon;
        do {
            foundNonDaemon = false;
            Collection<Thread> threads = this.getActiveThreads(threadGroup);
            for (Thread thread : threads) {
                if (thread.isDaemon()) continue;
                foundNonDaemon = true;
                this.joinThread(thread, 0L);
            }
        } while (foundNonDaemon);
    }

    private void joinThread(Thread thread, long timeoutMsecs) {
        try {
            this.getLog().debug((CharSequence)("joining on thread " + thread));
            thread.join(timeoutMsecs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getLog().warn((CharSequence)("interrupted while joining against thread " + thread), (Throwable)e);
        }
        if (thread.isAlive()) {
            this.getLog().warn((CharSequence)("thread " + thread + " was interrupted but is still alive after waiting at least " + timeoutMsecs + "msecs"));
        }
    }

    private void terminateThreads(ThreadGroup threadGroup) {
        long startTime = System.currentTimeMillis();
        HashSet<Thread> uncooperativeThreads = new HashSet<Thread>();
        Collection<Thread> threads = this.getActiveThreads(threadGroup);
        while (!threads.isEmpty()) {
            for (Thread thread : threads) {
                this.getLog().debug((CharSequence)("interrupting thread " + thread));
                thread.interrupt();
            }
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                if (this.daemonThreadJoinTimeout <= 0L) {
                    this.joinThread(thread, 0L);
                    continue;
                }
                long timeout = this.daemonThreadJoinTimeout - (System.currentTimeMillis() - startTime);
                if (timeout > 0L) {
                    this.joinThread(thread, timeout);
                }
                if (!thread.isAlive()) continue;
                uncooperativeThreads.add(thread);
                if (this.stopUnresponsiveDaemonThreads) {
                    this.getLog().warn((CharSequence)("thread " + thread + " will be Thread.stop()'ed"));
                    thread.stop();
                    continue;
                }
                this.getLog().warn((CharSequence)("thread " + thread + " will linger despite being asked to die via interruption"));
            }
            threads = this.getActiveThreads(threadGroup);
            threads.removeAll(uncooperativeThreads);
        }
        if (!uncooperativeThreads.isEmpty()) {
            this.getLog().warn((CharSequence)("NOTE: " + uncooperativeThreads.size() + " thread(s) did not finish despite being asked to " + " via interruption. This is not a problem with exec:java, it is a problem with the running code." + " Although not serious, it should be remedied."));
        } else {
            int activeCount = threadGroup.activeCount();
            if (activeCount != 0) {
                Thread[] threadsArray = new Thread[1];
                threadGroup.enumerate(threadsArray);
                this.getLog().debug((CharSequence)("strange; " + activeCount + " thread(s) still active in the group " + threadGroup + " such as " + threadsArray[0]));
            }
        }
    }

    private Collection<Thread> getActiveThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int numThreads = threadGroup.enumerate(threads);
        ArrayList<Thread> result = new ArrayList<Thread>(numThreads);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            result.add(threads[i]);
        }
        return result;
    }

    private void setSystemProperties() {
        if (this.systemProperties != null) {
            this.originalSystemProperties = System.getProperties();
            for (int i = 0; i < this.systemProperties.length; ++i) {
                Property systemProperty = this.systemProperties[i];
                String value = systemProperty.getValue();
                System.setProperty(systemProperty.getKey(), value == null ? "" : value);
            }
        }
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        ArrayList<URL> classpathURLs = new ArrayList<URL>();
        this.addRelevantPluginDependenciesToClasspath(classpathURLs);
        this.addRelevantProjectDependenciesToClasspath(classpathURLs);
        this.getLog().info((CharSequence)("Classpath = " + classpathURLs));
        return new URLClassLoader(classpathURLs.toArray(new URL[classpathURLs.size()]));
    }

    private void addRelevantPluginDependenciesToClasspath(List<URL> path) throws MojoExecutionException {
        if (this.hasCommandlineArgs()) {
            this.arguments = this.parseCommandlineArgs();
        }
        try {
            for (Artifact classPathElement : this.determineRelevantPluginDependencies()) {
                this.getLog().debug((CharSequence)("Adding plugin dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                path.add(classPathElement.getFile().toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    private void addRelevantProjectDependenciesToClasspath(List<URL> path) throws MojoExecutionException {
        if (this.includeProjectDependencies) {
            try {
                this.getLog().debug((CharSequence)"Project Dependencies will be included.");
                URL mainClasses = new File(this.project.getBuild().getOutputDirectory()).toURI().toURL();
                this.getLog().debug((CharSequence)("Adding to classpath : " + mainClasses));
                path.add(mainClasses);
                Set dependencies = CastUtils.cast((Set)this.project.getArtifacts());
                dependencies.addAll(this.getAllNonTestScopedDependencies());
                for (Artifact classPathElement : dependencies) {
                    this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                    File file = classPathElement.getFile();
                    if (file == null) continue;
                    path.add(file.toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
            }
        } else {
            this.getLog().debug((CharSequence)"Project Dependencies will be excluded.");
        }
    }

    private Collection<Artifact> getAllNonTestScopedDependencies() throws MojoExecutionException {
        ArrayList<Artifact> answer = new ArrayList<Artifact>();
        for (Artifact artifact : this.getAllDependencies()) {
            if (artifact.getScope().equals("test")) continue;
            answer.add(artifact);
        }
        return answer;
    }

    private Collection<Artifact> getAllDependencies() throws MojoExecutionException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Dependency dependency : this.project.getDependencies()) {
            VersionRange versionRange;
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            try {
                versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("unable to parse version", (Exception)((Object)e));
            }
            String type = dependency.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dependency.getClassifier();
            boolean optional = dependency.isOptional();
            String scope = dependency.getScope();
            if (scope == null) {
                scope = "compile";
            }
            Artifact art = this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, null, optional);
            if (scope.equalsIgnoreCase("system")) {
                art.setFile(new File(dependency.getSystemPath()));
            }
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion e : dependency.getExclusions()) {
                exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            art.setDependencyFilter((ArtifactFilter)newFilter);
            artifacts.add(art);
        }
        return artifacts;
    }

    private Set<Artifact> determineRelevantPluginDependencies() throws MojoExecutionException {
        Set<Artifact> relevantDependencies;
        if (this.includePluginDependencies) {
            if (this.executableDependency == null) {
                this.getLog().debug((CharSequence)"All Plugin Dependencies will be included.");
                relevantDependencies = new HashSet<Artifact>(this.pluginDependencies);
            } else {
                this.getLog().debug((CharSequence)"Selected plugin Dependencies will be included.");
                Artifact executableArtifact = this.findExecutableArtifact();
                Artifact executablePomArtifact = this.getExecutablePomArtifact(executableArtifact);
                relevantDependencies = this.resolveExecutableDependencies(executablePomArtifact);
            }
        } else {
            relevantDependencies = Collections.emptySet();
            this.getLog().debug((CharSequence)"Plugin Dependencies will be excluded.");
        }
        return relevantDependencies;
    }

    private Artifact getExecutablePomArtifact(Artifact executableArtifact) {
        return this.artifactFactory.createBuildArtifact(executableArtifact.getGroupId(), executableArtifact.getArtifactId(), executableArtifact.getVersion(), "pom");
    }

    private Artifact findExecutableArtifact() throws MojoExecutionException {
        Artifact executableTool = null;
        for (Artifact pluginDep : this.pluginDependencies) {
            if (!this.executableDependency.matches(pluginDep)) continue;
            executableTool = pluginDep;
            break;
        }
        if (executableTool == null) {
            throw new MojoExecutionException("No dependency of the plugin matches the specified executableDependency.  Specified executableToolAssembly is: " + this.executableDependency.toString());
        }
        return executableTool;
    }

    private Set<Artifact> resolveExecutableDependencies(Artifact executablePomArtifact) throws MojoExecutionException {
        Set executableDependencies;
        try {
            MavenProject executableProject = this.projectBuilder.buildFromRepository(executablePomArtifact, this.remoteRepositories, this.localRepository);
            List dependencies = CastUtils.cast((List)executableProject.getDependencies());
            Set dependencyArtifacts = CastUtils.cast((Set)MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)dependencies, null, null, null));
            dependencyArtifacts.add(executableProject.getArtifact());
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencyArtifacts, executablePomArtifact, Collections.EMPTY_MAP, this.localRepository, this.remoteRepositories, this.metadataSource, null, Collections.EMPTY_LIST);
            executableDependencies = CastUtils.cast((Set)result.getArtifacts());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Encountered problems resolving dependencies of the executable in preparation for its execution.", ex);
        }
        return executableDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(long millis) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.getLog().warn((CharSequence)("Spuriously interrupted while waiting for " + millis + "ms"), (Throwable)e);
            }
        }
    }

    class IsolatedThreadGroup
    extends ThreadGroup {
        Throwable uncaughtException;

        public IsolatedThreadGroup(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            boolean doLog = false;
            IsolatedThreadGroup isolatedThreadGroup = this;
            synchronized (isolatedThreadGroup) {
                if (this.uncaughtException == null) {
                    this.uncaughtException = throwable;
                } else {
                    doLog = true;
                }
            }
            if (doLog) {
                RunMojo.this.getLog().warn((CharSequence)"an additional exception was thrown", throwable);
            }
        }
    }
}

