/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.exec.AbstractExecMojo;

@Mojo(name="embedded", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class EmbeddedMojo
extends AbstractExecMojo {
    @Parameter(property="camel.duration", defaultValue="-1")
    protected String duration;
    @Parameter(property="camel.applicationContextUri")
    protected String applicationContextUri;
    @Parameter(property="camel.fileApplicationContextUri")
    protected String fileApplicationContextUri;
    @Parameter(property="project.testClasspathElements", required=true, readonly=true)
    private List<?> classpathElements;
    @Parameter(property="camel.mainClass", defaultValue="org.apache.camel.spring.Main", required=true)
    private String mainClass;

    public void execute() throws MojoExecutionException {
        try {
            this.executeWithoutWrapping();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed: " + e, e);
        }
    }

    public void executeWithoutWrapping() throws MalformedURLException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, MojoExecutionException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader newLoader = this.createClassLoader(null);
            Thread.currentThread().setContextClassLoader(newLoader);
            this.runCamel(newLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public List<?> getClasspathElements() {
        return this.classpathElements;
    }

    public void setClasspathElements(List<?> classpathElements) {
        this.classpathElements = classpathElements;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getApplicationContextUri() {
        return this.applicationContextUri;
    }

    public void setApplicationContextUri(String applicationContextUri) {
        this.applicationContextUri = applicationContextUri;
    }

    public String getFileApplicationContextUri() {
        return this.fileApplicationContextUri;
    }

    public void setFileApplicationContextUri(String fileApplicationContextUri) {
        this.fileApplicationContextUri = fileApplicationContextUri;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    protected void runCamel(ClassLoader newLoader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, MojoExecutionException {
        this.getLog().debug((CharSequence)("Running Camel in: " + newLoader));
        Class<?> type = newLoader.loadClass(this.mainClass);
        Method method = type.getMethod("main", String[].class);
        String[] arguments = this.createArguments();
        this.getLog().debug((CharSequence)("Starting the Camel Main with arguments: " + Arrays.asList(arguments)));
        try {
            method.invoke(null, new Object[]{arguments});
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new MojoExecutionException("Failed: " + t, t);
        }
    }

    protected String[] createArguments() {
        ArrayList<String> args = new ArrayList<String>(5);
        if (this.applicationContextUri != null) {
            args.add("-applicationContext");
            args.add(this.applicationContextUri);
        } else if (this.fileApplicationContextUri != null) {
            args.add("-fileApplicationContext");
            args.add(this.fileApplicationContextUri);
        }
        args.add("-duration");
        args.add(this.getDuration());
        return args.toArray(new String[0]);
    }

    public ClassLoader createClassLoader(ClassLoader parent) throws MalformedURLException {
        this.getLog().debug((CharSequence)("Using classpath: " + this.classpathElements));
        int size = this.classpathElements.size();
        URL[] urls = new URL[size];
        for (int i = 0; i < size; ++i) {
            String name = (String)this.classpathElements.get(i);
            File file = new File(name);
            urls[i] = file.toURI().toURL();
            this.getLog().debug((CharSequence)("URL: " + urls[i]));
        }
        URLClassLoader loader = new URLClassLoader(urls, parent);
        return loader;
    }
}

