/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import org.apache.camel.maven.RunMojo;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dev", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DevMojo
extends RunMojo {
    @Parameter(property="camel.routesDirectory")
    private String routesDirectory;

    @Override
    protected void beforeBootstrapCamel() throws Exception {
        String routesReloadDirectory = "src/main/resources";
        if (this.routesDirectory != null) {
            routesReloadDirectory = this.routesDirectory;
        } else if (this.routesDirectory == null && this.project.getResources().size() == 1) {
            routesReloadDirectory = ((Resource)this.project.getResources().get(0)).getDirectory();
        }
        System.setProperty("camel.main.routesReloadEnabled", "true");
        System.setProperty("camel.main.routesReloadDirectory", routesReloadDirectory);
        System.setProperty("camel.main.routesReloadDirectoryRecursive", "true");
        System.setProperty("camel.main.durationMaxAction", "stop");
        System.setProperty("camel.main.routesReloadPattern", "*.xml,*.yaml,*.java");
    }

    @Override
    protected String goal() {
        return "camel:dev";
    }
}

