/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.maven.DynamicClassLoader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="prepare-fatjar", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class PrepareFatJarMojo
extends AbstractMojo {
    private static final String GENERATED_MSG = "Generated by camel build tools - do NOT edit this file!";
    private static final String NL = "\n";
    private static final String META_INF_SERVICES_TYPE_CONVERTER_LOADER = "META-INF/services/org/apache/camel/TypeConverterLoader";
    private static final String META_INF_SERVICES_UBER_TYPE_CONVERTER_LOADER = "META-INF/services/org/apache/camel/UberTypeConverterLoader";
    private DynamicClassLoader projectClassLoader;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Component
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Collection<String> loaders = this.findTypeConverterLoaderClasses();
        if (loaders.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("Found " + loaders.size() + " Camel type converter loaders from project classpath"));
        StringBuilder sb = new StringBuilder();
        sb.append("# ");
        sb.append(GENERATED_MSG);
        sb.append(NL);
        sb.append(String.join((CharSequence)NL, loaders));
        sb.append(NL);
        String data = sb.toString();
        File file = new File(this.classesDirectory, META_INF_SERVICES_UBER_TYPE_CONVERTER_LOADER);
        try {
            this.writeFile(file, data);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error updating " + file, (Throwable)e);
        }
    }

    private void writeFile(File file, String data) throws IOException {
        Path path = file.toPath();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, data.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    protected Collection<String> findTypeConverterLoaderClasses() {
        LinkedHashSet<String> loaders = new LinkedHashSet<String>();
        try {
            Enumeration<URL> loaderResources = this.getProjectClassLoader().getResources(META_INF_SERVICES_TYPE_CONVERTER_LOADER);
            while (loaderResources.hasMoreElements()) {
                URL url = loaderResources.nextElement();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Loading file META-INF/services/org/apache/camel/TypeConverterLoader to retrieve list of type converters, from url: " + url));
                }
                this.readTypeConverters(loaders, url);
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Error finding type converters due to " + e.getMessage()));
        }
        return loaders;
    }

    private void readTypeConverters(Set<String> loaders, URL url) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String line;
            do {
                if ((line = reader.readLine()) == null || line.startsWith("#") || line.isEmpty()) continue;
                loaders.add(line);
            } while (line != null);
        }
    }

    protected final DynamicClassLoader getProjectClassLoader() throws MojoExecutionException {
        if (this.projectClassLoader == null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            this.addRelevantProjectDependenciesToClasspath(urls, false);
            this.projectClassLoader = DynamicClassLoader.createDynamicClassLoaderFromUrls(urls);
        }
        return this.projectClassLoader;
    }

    private void addRelevantProjectDependenciesToClasspath(List<URL> path, boolean testClasspathOnly) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Project Dependencies will be included.");
            if (testClasspathOnly) {
                URL testClasses = new File(this.project.getBuild().getTestOutputDirectory()).toURI().toURL();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding to classpath : " + testClasses));
                }
                path.add(testClasses);
            } else {
                URL mainClasses = new File(this.project.getBuild().getOutputDirectory()).toURI().toURL();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding to classpath : " + mainClasses));
                }
                path.add(mainClasses);
            }
            Set dependencies = this.project.getArtifacts();
            dependencies.addAll(this.getAllNonTestScopedDependencies());
            for (Artifact classPathElement : dependencies) {
                File file;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                }
                if ((file = classPathElement.getFile()) == null) continue;
                path.add(file.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    private Collection<Artifact> getAllNonTestScopedDependencies() throws MojoExecutionException {
        ArrayList<Artifact> answer = new ArrayList<Artifact>();
        for (Artifact artifact : this.getAllDependencies()) {
            if (artifact.getScope().equals("test")) continue;
            answer.add(artifact);
        }
        return answer;
    }

    private Collection<Artifact> getAllDependencies() throws MojoExecutionException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Dependency dependency : this.project.getDependencies()) {
            VersionRange versionRange;
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            try {
                versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("unable to parse version", (Exception)((Object)e));
            }
            String type = dependency.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dependency.getClassifier();
            boolean optional = dependency.isOptional();
            String scope = dependency.getScope();
            if (scope == null) {
                scope = "compile";
            }
            if (this.artifactFactory == null) continue;
            Artifact art = this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, null, optional);
            if (scope.equalsIgnoreCase("system")) {
                art.setFile(new File(dependency.getSystemPath()));
            }
            ArrayList<CallSite> exclusions = new ArrayList<CallSite>();
            for (Exclusion exclusion : dependency.getExclusions()) {
                exclusions.add((CallSite)((Object)(exclusion.getGroupId() + ":" + exclusion.getArtifactId())));
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            art.setDependencyFilter((ArtifactFilter)newFilter);
            artifacts.add(art);
        }
        return artifacts;
    }
}

