/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.camel.maven.RunMojo;
import org.apache.camel.util.CastUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="dev", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DevMojo
extends RunMojo {
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="camel.routesDirectory")
    private String routesDirectory;

    @Inject
    public DevMojo(RepositorySystem repositorySystem) {
        super(repositorySystem);
    }

    @Override
    protected void beforeBootstrapCamel() throws Exception {
        String dir = this.routesDirectory != null ? this.routesDirectory : (this.project.getResources().size() == 1 ? ((Resource)this.project.getResources().get(0)).getDirectory() : "src/main/resources");
        dir = new File(dir).getAbsolutePath();
        System.setProperty("camel.main.profile", this.profile == null ? "dev" : this.profile);
        System.setProperty("camel.main.routesReloadEnabled", "true");
        System.setProperty("camel.main.routesReloadDirectory", dir);
        System.setProperty("camel.main.routesReloadDirectoryRecursive", "true");
        System.setProperty("camel.main.sourceLocationEnabled", "true");
        System.setProperty("camel.main.durationMaxAction", "stop");
        System.setProperty("camel.main.routesReloadPattern", "*.xml,*.yaml,*.java");
    }

    @Override
    protected List<Artifact> getClasspath() throws MojoExecutionException, MojoFailureException {
        List<Artifact> classpath = super.getClasspath();
        if (classpath.stream().anyMatch(artifact -> "org.apache.camel".equals(artifact.getGroupId()) && "camel-debug".equals(artifact.getArtifactId()))) {
            this.getLog().debug((CharSequence)"The component camel-debug has been detected in the classpath so no need to add it");
            return classpath;
        }
        this.getLog().info((CharSequence)"The component camel-debug is not available in the classpath, it will be added automatically");
        Optional<String> camelCoreVersion = classpath.stream().filter(artifact -> "org.apache.camel".equals(artifact.getGroupId()) && Objects.nonNull(artifact.getArtifactId()) && artifact.getArtifactId().startsWith("camel-core")).map(Artifact::getBaseVersion).filter(Objects::nonNull).findAny();
        if (camelCoreVersion.isEmpty()) {
            this.getLog().info((CharSequence)"The version of Camel could not be detected, the version of the plugin will be used instead");
            if ("camel:debug".equals(this.goal())) {
                this.addCamelDependency(classpath, "camel-debug", this.mojo.getVersion());
            }
            this.addCamelDependency(classpath, "camel-dsl-modeline", this.mojo.getVersion());
            return classpath;
        }
        if ("camel:debug".equals(this.goal())) {
            this.addCamelDependency(classpath, "camel-debug", this.mojo.getVersion());
        }
        this.addCamelDependency(classpath, "camel-dsl-modeline", this.mojo.getVersion());
        return classpath;
    }

    private void addCamelDependency(List<Artifact> classpath, String artifactId, String version) {
        this.getLog().debug((CharSequence)String.format("Trying to retrieve the version %s of %s", artifactId, version));
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setResolveRoot(true);
        request.setResolveTransitively(true);
        request.setLocalRepository(this.session.getLocalRepository());
        request.setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        request.setOffline(this.session.isOffline());
        request.setForceUpdate(this.session.getRequest().isUpdateSnapshots());
        request.setServers(this.session.getRequest().getServers());
        request.setMirrors(this.session.getRequest().getMirrors());
        request.setProxies(this.session.getRequest().getProxies());
        request.setManagedVersionMap(Collections.emptyMap());
        request.setArtifact((Artifact)new DefaultArtifact("org.apache.camel", artifactId, version, "runtime", "jar", null, (ArtifactHandler)new DefaultArtifactHandler("jar")));
        request.setResolutionFilter((ArtifactFilter)new ScopeArtifactFilter("runtime"));
        ArtifactResolutionResult result = this.artifactResolver.resolve(request);
        if (result.isSuccess()) {
            this.getLog().info((CharSequence)String.format("Adding the version %s of %s", version, artifactId));
            classpath.addAll(CastUtils.cast((Set)result.getArtifacts()));
            return;
        }
        if (result.hasMissingArtifacts()) {
            this.getLog().warn((CharSequence)String.format("Could not find the artifacts: %s", result.getMissingArtifacts().stream().map(Objects::toString).collect(Collectors.joining(", "))));
        }
        if (result.hasExceptions()) {
            result.getExceptions().forEach(ex -> this.getLog().warn((CharSequence)String.format("An error occurred while retrieving %s:%s", artifactId, ex.getMessage())));
        }
    }

    @Override
    protected String goal() {
        return "camel:dev";
    }
}

