/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics;

import com.codahale.metrics.MetricRegistry;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.metrics.AbstractMetricsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricsProducer<T extends AbstractMetricsEndpoint>
extends DefaultProducer {
    public static final String HEADER_PATTERN = "CamelMetrics*";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMetricsProducer.class);

    public AbstractMetricsProducer(T endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        AbstractMetricsEndpoint endpoint = (AbstractMetricsEndpoint)this.getEndpoint();
        Message in = exchange.getIn();
        String defaultMetricsName = endpoint.getMetricsName();
        String finalMetricsName = this.getMetricsName(in, defaultMetricsName);
        MetricRegistry registry = endpoint.getRegistry();
        try {
            this.doProcess(exchange, endpoint, registry, finalMetricsName);
        }
        catch (Exception e) {
            LOG.warn("Failed to produce metrics for {} in {} - {}", new Object[]{finalMetricsName, ((Object)((Object)this)).getClass().getSimpleName(), e.getMessage()});
        }
        this.clearMetricsHeaders(in);
    }

    protected abstract void doProcess(Exchange var1, T var2, MetricRegistry var3, String var4) throws Exception;

    public String getMetricsName(Message in, String defaultValue) {
        return this.getStringHeader(in, "CamelMetricsName", defaultValue);
    }

    public String getStringHeader(Message in, String header, String defaultValue) {
        String headerValue = (String)in.getHeader(header, String.class);
        return ObjectHelper.isNotEmpty((Object)headerValue) ? headerValue : defaultValue;
    }

    public Long getLongHeader(Message in, String header, Long defaultValue) {
        return (Long)in.getHeader(header, (Object)defaultValue, Long.class);
    }

    protected boolean clearMetricsHeaders(Message in) {
        return in.removeHeaders(HEADER_PATTERN);
    }
}

