/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.metrics.AbstractMetricsEndpoint;
import org.apache.camel.component.metrics.MetricsType;
import org.apache.camel.component.metrics.counter.CounterEndpoint;
import org.apache.camel.component.metrics.histogram.HistogramEndpoint;
import org.apache.camel.component.metrics.meter.MeterEndpoint;
import org.apache.camel.component.metrics.timer.TimerEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsComponent
extends DefaultComponent {
    public static final String METRIC_REGISTRY_NAME = "metricRegistry";
    public static final MetricsType DEFAULT_METRICS_TYPE = MetricsType.METER;
    public static final long DEFAULT_REPORTING_INTERVAL_SECONDS = 60L;
    private static final Logger LOG = LoggerFactory.getLogger(MetricsComponent.class);
    private MetricRegistry metricRegistry;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (this.metricRegistry == null) {
            Registry camelRegistry = this.getCamelContext().getRegistry();
            this.metricRegistry = this.getOrCreateMetricRegistry(camelRegistry, METRIC_REGISTRY_NAME);
        }
        String metricsName = this.getMetricsName(remaining);
        MetricsType metricsType = this.getMetricsType(remaining);
        LOG.info("Metrics type: {}; name: {}", (Object)metricsType, (Object)metricsName);
        Endpoint endpoint = this.createNewEndpoint(this.metricRegistry, metricsType, metricsName);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    String getMetricsName(String remaining) {
        String name = ObjectHelper.after((String)remaining, (String)":");
        return name == null ? remaining : name;
    }

    Endpoint createNewEndpoint(MetricRegistry registry, MetricsType type, String metricsName) {
        AbstractMetricsEndpoint endpoint;
        switch (type) {
            case COUNTER: {
                endpoint = new CounterEndpoint(registry, metricsName);
                break;
            }
            case METER: {
                endpoint = new MeterEndpoint(registry, metricsName);
                break;
            }
            case HISTOGRAM: {
                endpoint = new HistogramEndpoint(registry, metricsName);
                break;
            }
            case TIMER: {
                endpoint = new TimerEndpoint(registry, metricsName);
                break;
            }
            default: {
                throw new RuntimeCamelException("Metrics type \"" + type.toString() + "\" not supported");
            }
        }
        return endpoint;
    }

    MetricsType getMetricsType(String remaining) {
        String name = ObjectHelper.before((String)remaining, (String)":");
        MetricsType type = name == null ? DEFAULT_METRICS_TYPE : MetricsType.getByName(name);
        if (type == null) {
            throw new RuntimeCamelException("Unknown metrics type \"" + name + "\"");
        }
        return type;
    }

    MetricRegistry getOrCreateMetricRegistry(Registry camelRegistry, String registryName) {
        LOG.debug("Looking up MetricRegistry from Camel Registry for name \"{}\"", (Object)registryName);
        MetricRegistry result = this.getMetricRegistryFromCamelRegistry(camelRegistry, registryName);
        if (result == null) {
            LOG.debug("MetricRegistry not found from Camel Registry for name \"{}\"", (Object)registryName);
            LOG.info("Creating new default MetricRegistry");
            result = this.createMetricRegistry();
        }
        return result;
    }

    MetricRegistry getMetricRegistryFromCamelRegistry(Registry camelRegistry, String registryName) {
        return (MetricRegistry)camelRegistry.lookupByNameAndType(registryName, MetricRegistry.class);
    }

    MetricRegistry createMetricRegistry() {
        MetricRegistry registry = new MetricRegistry();
        Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)registry).outputTo(LOG).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        reporter.start(60L, TimeUnit.SECONDS);
        return registry;
    }
}

