/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics.counter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.metrics.AbstractMetricsProducer;
import org.apache.camel.component.metrics.counter.CounterEndpoint;

public class CounterProducer
extends AbstractMetricsProducer<CounterEndpoint> {
    public CounterProducer(CounterEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, CounterEndpoint endpoint, MetricRegistry registry, String metricsName) throws Exception {
        Message in = exchange.getIn();
        Counter counter = registry.counter(metricsName);
        Long increment = endpoint.getIncrement();
        Long decrement = endpoint.getDecrement();
        Long finalIncrement = this.getLongHeader(in, "CamelMetricsCounterIncrement", increment);
        Long finalDecrement = this.getLongHeader(in, "CamelMetricsCounterDecrement", decrement);
        if (finalIncrement != null) {
            counter.inc(finalIncrement.longValue());
        } else if (finalDecrement != null) {
            counter.dec(finalDecrement.longValue());
        } else {
            counter.inc();
        }
    }
}

