/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics.meter;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.metrics.AbstractMetricsProducer;
import org.apache.camel.component.metrics.meter.MeterEndpoint;

public class MeterProducer
extends AbstractMetricsProducer<MeterEndpoint> {
    public MeterProducer(MeterEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, MeterEndpoint endpoint, MetricRegistry registry, String metricsName) throws Exception {
        Message in = exchange.getIn();
        Meter meter = registry.meter(metricsName);
        Long mark = endpoint.getMark();
        Long finalMark = this.getLongHeader(in, "CamelMetricsMeterMark", mark);
        if (finalMark == null) {
            meter.mark();
        } else {
            meter.mark(finalMark.longValue());
        }
    }
}

