/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics.routepolicy;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.component.metrics.routepolicy.MetricsRegistryService;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.camel.util.ObjectHelper;

public class MetricsRoutePolicy
extends RoutePolicySupport {
    private MetricRegistry metricsRegistry;
    private MetricsRegistryService registryService;
    private boolean useJmx = true;
    private String jmxDomain = "org.apache.camel.metrics";
    private boolean prettyPrint;
    private TimeUnit rateUnit = TimeUnit.SECONDS;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private MetricsStatistics statistics;
    private Route route;

    public MetricRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void setMetricsRegistry(MetricRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }

    public boolean isUseJmx() {
        return this.useJmx;
    }

    public void setUseJmx(boolean useJmx) {
        this.useJmx = useJmx;
    }

    public String getJmxDomain() {
        return this.jmxDomain;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getRateUnit() {
        return this.rateUnit;
    }

    public void setRateUnit(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    public void onInit(Route route) {
        super.onInit(route);
        this.route = route;
        try {
            this.registryService = (MetricsRegistryService)route.getRouteContext().getCamelContext().hasService(MetricsRegistryService.class);
            if (this.registryService == null) {
                this.registryService = new MetricsRegistryService();
                this.registryService.setMetricsRegistry(this.getMetricsRegistry());
                this.registryService.setUseJmx(this.isUseJmx());
                this.registryService.setJmxDomain(this.getJmxDomain());
                this.registryService.setPrettyPrint(this.isPrettyPrint());
                this.registryService.setRateUnit(this.getRateUnit());
                this.registryService.setDurationUnit(this.getDurationUnit());
                route.getRouteContext().getCamelContext().addService((Object)this.registryService);
            }
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        Timer responses = this.registryService.getMetricsRegistry().timer(this.createName("responses"));
        this.statistics = new MetricsStatistics(responses);
    }

    private String createName(String type) {
        CamelContext context = this.route.getRouteContext().getCamelContext();
        String name = context.getManagementName() != null ? context.getManagementName() : context.getName();
        return name + ":" + this.route.getId() + "." + type;
    }

    public void onExchangeBegin(Route route, Exchange exchange) {
        if (this.statistics != null) {
            this.statistics.onExchangeBegin(exchange);
        }
    }

    public void onExchangeDone(Route route, Exchange exchange) {
        if (this.statistics != null) {
            this.statistics.onExchangeDone(exchange);
        }
    }

    private static final class MetricsStatistics {
        private Timer responses;

        private MetricsStatistics(Timer responses) {
            this.responses = responses;
        }

        public void onExchangeBegin(Exchange exchange) {
            Timer.Context context = this.responses.time();
            exchange.setProperty("MetricsRoutePolicy", (Object)context);
        }

        public void onExchangeDone(Exchange exchange) {
            Timer.Context context = (Timer.Context)exchange.getProperty("MetricsRoutePolicy", Timer.Context.class);
            if (context != null) {
                context.stop();
            }
        }
    }
}

