/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.metrics.MetricsEndpoint;
import org.apache.camel.component.metrics.MetricsType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.StringHelper;

@org.apache.camel.spi.annotations.Component(value="metrics")
public class MetricsComponent
extends DefaultComponent {
    public static final String METRIC_REGISTRY_NAME = "metricRegistry";
    public static final MetricsType DEFAULT_METRICS_TYPE = MetricsType.METER;
    public static final long DEFAULT_REPORTING_INTERVAL_SECONDS = 60L;
    @Metadata(label="advanced")
    private MetricRegistry metricRegistry;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (this.metricRegistry == null) {
            Registry camelRegistry = this.getCamelContext().getRegistry();
            this.metricRegistry = this.getOrCreateMetricRegistry(camelRegistry, METRIC_REGISTRY_NAME);
        }
        String metricsName = this.getMetricsName(remaining);
        MetricsType metricsType = this.getMetricsType(remaining);
        this.log.debug("Metrics type: {}; name: {}", (Object)metricsType, (Object)metricsName);
        MetricsEndpoint endpoint = new MetricsEndpoint(uri, (Component)this, this.metricRegistry, metricsType, metricsName);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    String getMetricsName(String remaining) {
        String name = StringHelper.after((String)remaining, (String)":");
        return name == null ? remaining : name;
    }

    MetricsType getMetricsType(String remaining) {
        String name = StringHelper.before((String)remaining, (String)":");
        MetricsType type = name == null ? DEFAULT_METRICS_TYPE : MetricsType.getByName(name);
        if (type == null) {
            throw new RuntimeCamelException("Unknown metrics type \"" + name + "\"");
        }
        return type;
    }

    MetricRegistry getOrCreateMetricRegistry(Registry camelRegistry, String registryName) {
        this.log.debug("Looking up MetricRegistry from Camel Registry for name \"{}\"", (Object)registryName);
        MetricRegistry result = this.getMetricRegistryFromCamelRegistry(camelRegistry, registryName);
        if (result == null) {
            this.log.debug("MetricRegistry not found from Camel Registry for name \"{}\"", (Object)registryName);
            this.log.info("Creating new default MetricRegistry");
            result = this.createMetricRegistry();
        }
        return result;
    }

    MetricRegistry getMetricRegistryFromCamelRegistry(Registry camelRegistry, String registryName) {
        MetricRegistry registry = (MetricRegistry)camelRegistry.lookupByNameAndType(registryName, MetricRegistry.class);
        if (registry != null) {
            return registry;
        }
        Set registries = camelRegistry.findByType(MetricRegistry.class);
        if (registries.size() == 1) {
            return (MetricRegistry)registries.iterator().next();
        }
        return null;
    }

    MetricRegistry createMetricRegistry() {
        MetricRegistry registry = new MetricRegistry();
        Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)registry).outputTo(this.log).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).withLoggingLevel(Slf4jReporter.LoggingLevel.DEBUG).build();
        reporter.start(60L, TimeUnit.SECONDS);
        return registry;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }
}

