/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics;

import com.codahale.metrics.MetricRegistry;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.metrics.CounterProducer;
import org.apache.camel.component.metrics.GaugeProducer;
import org.apache.camel.component.metrics.HistogramProducer;
import org.apache.camel.component.metrics.MeterProducer;
import org.apache.camel.component.metrics.MetricsConstants;
import org.apache.camel.component.metrics.MetricsTimerAction;
import org.apache.camel.component.metrics.MetricsType;
import org.apache.camel.component.metrics.TimerProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.14.0", scheme="metrics", title="Metrics", syntax="metrics:metricsType:metricsName", producerOnly=true, category={Category.MONITORING}, headersClass=MetricsConstants.class)
public class MetricsEndpoint
extends DefaultEndpoint {
    protected final MetricRegistry registry;
    @UriPath(description="Type of metrics")
    @Metadata(required=true)
    protected final MetricsType metricsType;
    @UriPath(description="Name of metrics")
    @Metadata(required=true)
    protected final String metricsName;
    @UriParam(description="Action when using timer type")
    private MetricsTimerAction action;
    @UriParam(description="Mark when using meter type")
    private Long mark;
    @UriParam(description="Value value when using histogram type")
    private Long value;
    @UriParam(description="Increment value when using counter type")
    private Long increment;
    @UriParam(description="Decrement value when using counter type")
    private Long decrement;
    @UriParam(description="Subject value when using gauge type")
    private Object subject;

    public MetricsEndpoint(String uri, Component component, MetricRegistry registry, MetricsType metricsType, String metricsName) {
        super(uri, component);
        this.registry = registry;
        this.metricsType = metricsType;
        this.metricsName = metricsName;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new RuntimeCamelException("Cannot consume from " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.getEndpointUri());
    }

    public Producer createProducer() throws Exception {
        if (this.metricsType == MetricsType.COUNTER) {
            return new CounterProducer(this);
        }
        if (this.metricsType == MetricsType.HISTOGRAM) {
            return new HistogramProducer(this);
        }
        if (this.metricsType == MetricsType.METER) {
            return new MeterProducer(this);
        }
        if (this.metricsType == MetricsType.TIMER) {
            return new TimerProducer(this);
        }
        if (this.metricsType == MetricsType.GAUGE) {
            return new GaugeProducer(this);
        }
        throw new IllegalArgumentException("Metrics type " + String.valueOf((Object)this.metricsType) + " is not supported");
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public MetricsType getMetricsType() {
        return this.metricsType;
    }

    public MetricsTimerAction getAction() {
        return this.action;
    }

    public void setAction(MetricsTimerAction action) {
        this.action = action;
    }

    public Long getMark() {
        return this.mark;
    }

    public void setMark(Long mark) {
        this.mark = mark;
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public Long getIncrement() {
        return this.increment;
    }

    public void setIncrement(Long increment) {
        this.increment = increment;
    }

    public Long getDecrement() {
        return this.decrement;
    }

    public void setDecrement(Long decrement) {
        this.decrement = decrement;
    }

    public Object getSubject() {
        return this.subject;
    }

    public void setSubject(Object subject) {
        this.subject = subject;
    }
}

