/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.routepolicy;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyNamingStrategy;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyService;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class MicrometerRoutePolicy
extends RoutePolicySupport
implements NonManagedService {
    private MeterRegistry meterRegistry;
    private boolean prettyPrint;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private MetricsStatistics statistics;
    private MicrometerRoutePolicyNamingStrategy namingStrategy = MicrometerRoutePolicyNamingStrategy.DEFAULT;

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    public MicrometerRoutePolicyNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerRoutePolicyNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void onInit(Route route) {
        super.onInit(route);
        if (this.getMeterRegistry() == null) {
            this.setMeterRegistry(MicrometerUtils.getOrCreateMeterRegistry(route.getCamelContext().getRegistry(), "metricsRegistry"));
        }
        try {
            MicrometerRoutePolicyService registryService = (MicrometerRoutePolicyService)route.getCamelContext().hasService(MicrometerRoutePolicyService.class);
            if (registryService == null) {
                registryService = new MicrometerRoutePolicyService();
                registryService.setMeterRegistry(this.getMeterRegistry());
                registryService.setPrettyPrint(this.isPrettyPrint());
                registryService.setDurationUnit(this.getDurationUnit());
                registryService.setMatchingTags((Iterable<Tag>)Tags.of((String)"serviceName", (String)MicrometerRoutePolicyService.class.getSimpleName()));
                route.getCamelContext().addService((Object)registryService);
                ServiceHelper.startService((Object)registryService);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        this.statistics = new MetricsStatistics(this.getMeterRegistry(), route, this.getNamingStrategy());
    }

    public void onExchangeBegin(Route route, Exchange exchange) {
        if (this.statistics != null) {
            this.statistics.onExchangeBegin(exchange);
        }
    }

    public void onExchangeDone(Route route, Exchange exchange) {
        if (this.statistics != null) {
            this.statistics.onExchangeDone(exchange);
        }
    }

    private static final class MetricsStatistics {
        private final MeterRegistry meterRegistry;
        private final Route route;
        private final MicrometerRoutePolicyNamingStrategy namingStrategy;
        private final Counter exchangesSucceeded;
        private final Counter exchangesFailed;
        private final Counter exchangesTotal;
        private final Counter externalRedeliveries;
        private final Counter failuresHandled;

        private MetricsStatistics(MeterRegistry meterRegistry, Route route, MicrometerRoutePolicyNamingStrategy namingStrategy) {
            this.meterRegistry = (MeterRegistry)ObjectHelper.notNull((Object)meterRegistry, (String)"MeterRegistry", (Object)this);
            this.namingStrategy = (MicrometerRoutePolicyNamingStrategy)ObjectHelper.notNull((Object)namingStrategy, (String)"MicrometerRoutePolicyNamingStrategy", (Object)this);
            this.route = route;
            this.exchangesSucceeded = this.createCounter(namingStrategy.getExchangesSucceededName(route), "Number of successfully completed exchanges");
            this.exchangesFailed = this.createCounter(namingStrategy.getExchangesFailedName(route), "Number of failed exchanges");
            this.exchangesTotal = this.createCounter(namingStrategy.getExchangesTotalName(route), "Total number of processed exchanges");
            this.externalRedeliveries = this.createCounter(namingStrategy.getExternalRedeliveriesName(route), "Number of external initiated redeliveries (such as from JMS broker)");
            this.failuresHandled = this.createCounter(namingStrategy.getFailuresHandledName(route), "Number of failures handled");
        }

        public void onExchangeBegin(Exchange exchange) {
            Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
            exchange.setProperty(this.propertyName(exchange), (Object)sample);
        }

        public void onExchangeDone(Exchange exchange) {
            Timer.Sample sample = (Timer.Sample)exchange.removeProperty(this.propertyName(exchange));
            if (sample != null) {
                Timer timer = Timer.builder((String)this.namingStrategy.getName(this.route)).tags((Iterable)this.namingStrategy.getTags(this.route)).description("Route performance metrics").register(this.meterRegistry);
                sample.stop(timer);
            }
            this.exchangesTotal.increment();
            if (exchange.isFailed()) {
                this.exchangesFailed.increment();
            } else {
                this.exchangesSucceeded.increment();
                if (ExchangeHelper.isFailureHandled((Exchange)exchange)) {
                    this.failuresHandled.increment();
                }
                if (exchange.isExternalRedelivered()) {
                    this.externalRedeliveries.increment();
                }
            }
        }

        private String propertyName(Exchange exchange) {
            return String.format("%s-%s-%s", "CamelRoutePolicy", this.route.getId(), exchange.getExchangeId());
        }

        private Counter createCounter(String meterName, String description) {
            return Counter.builder((String)meterName).tags((Iterable)this.namingStrategy.getExchangeStatusTags(this.route)).description(description).register(this.meterRegistry);
        }
    }
}

