/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategyDefault;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategyLegacy;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.util.StringHelper;

public interface MicrometerExchangeEventNotifierNamingStrategy {
    public static final Predicate<Meter.Id> EVENT_NOTIFIERS = id -> "CamelExchangeEvent".equals(id.getTag("kind"));
    public static final MicrometerExchangeEventNotifierNamingStrategy DEFAULT = new MicrometerExchangeEventNotifierNamingStrategyDefault();
    public static final MicrometerExchangeEventNotifierNamingStrategy LEGACY = new MicrometerExchangeEventNotifierNamingStrategyLegacy();

    public String getName(Exchange var1, Endpoint var2);

    public boolean isBaseEndpointURI();

    default public String formatName(String name) {
        return name;
    }

    default public String getInflightExchangesName() {
        return this.formatName("camel.exchanges.inflight");
    }

    default public Tags getTags(CamelEvent.ExchangeEvent event, Endpoint endpoint) {
        String routeId;
        String uri = "";
        if (endpoint != null) {
            uri = endpoint.toString();
            if (this.isBaseEndpointURI()) {
                uri = StringHelper.before((String)uri, (String)"?", (String)uri);
            }
        }
        if ((routeId = event.getExchange().getFromRouteId()) != null) {
            return Tags.of((String[])new String[]{"camelContext", event.getExchange().getContext().getName(), "kind", "CamelExchangeEvent", "eventType", event.getClass().getSimpleName(), "routeId", routeId, "endpointName", uri, "failed", Boolean.toString(event.getExchange().isFailed())});
        }
        return Tags.of((String[])new String[]{"camelContext", event.getExchange().getContext().getName(), "kind", "CamelExchangeEvent", "eventType", event.getClass().getSimpleName(), "endpointName", uri, "failed", Boolean.toString(event.getExchange().isFailed())});
    }

    default public Tags getInflightExchangesTags(CamelContext camelContext, String routeId) {
        return Tags.of((String[])new String[]{"camelContext", camelContext.getName(), "kind", "CamelExchangeEvent", "routeId", routeId});
    }
}

