/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.routepolicy;

import io.micrometer.core.instrument.MeterRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicy;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyConfiguration;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyNamingStrategy;
import org.apache.camel.spi.UnitOfWork;

final class ContextMetricsStatistics
extends MicrometerRoutePolicy.MetricsStatistics {
    private final boolean registerKamelets;
    private final boolean registerTemplates;

    ContextMetricsStatistics(MeterRegistry meterRegistry, CamelContext camelContext, MicrometerRoutePolicyNamingStrategy namingStrategy, MicrometerRoutePolicyConfiguration configuration, boolean registerKamelets, boolean registerTemplates) {
        super(meterRegistry, camelContext, null, namingStrategy, configuration);
        this.registerKamelets = registerKamelets;
        this.registerTemplates = registerTemplates;
    }

    @Override
    public void onExchangeBegin(Exchange exchange) {
        UnitOfWork uow = exchange.getUnitOfWork();
        if (uow != null) {
            int level = uow.routeStackLevel(this.registerTemplates, this.registerKamelets);
            if (level <= 1) {
                super.onExchangeBegin(exchange);
            }
        } else {
            super.onExchangeBegin(exchange);
        }
    }

    @Override
    public void onExchangeDone(Exchange exchange) {
        UnitOfWork uow = exchange.getUnitOfWork();
        if (uow != null) {
            int level = uow.routeStackLevel(this.registerTemplates, this.registerKamelets);
            if (level <= 1) {
                super.onExchangeDone(exchange);
            }
        } else {
            super.onExchangeDone(exchange);
        }
    }
}

