/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="micrometer")
public class MicrometerConsole
extends AbstractDevConsole {
    public static final String TAGS = "tags";

    public MicrometerConsole() {
        super("camel", "micrometer", "Micrometer", "Display runtime metrics");
    }

    protected String doCallText(Map<String, Object> options) {
        Timer t;
        String name;
        boolean tags = "true".equals(options.getOrDefault(TAGS, "true"));
        StringBuilder sb = new StringBuilder();
        MeterRegistry mr = this.lookupMeterRegistry();
        sb.append(String.format("MeterRegistry: %s\n\n", mr.getClass().getName()));
        int i = 0;
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof Counter)) continue;
            Counter c = (Counter)m;
            if (i == 0) {
                sb.append("Counters:\n");
            }
            ++i;
            name = c.getId().getName();
            String cnt = String.valueOf(c.count());
            if (cnt.endsWith(".0") || cnt.endsWith(",0")) {
                cnt = cnt.substring(0, cnt.length() - 2);
            }
            sb.append(String.format("    %s: %s\n", name, cnt));
            if (!tags) continue;
            this.addTags(sb, c.getId());
        }
        i = 0;
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof Gauge)) continue;
            Gauge g = (Gauge)m;
            if (i == 0) {
                sb.append("\nGauges:\n");
            }
            ++i;
            name = g.getId().getName();
            double cnt = g.value();
            sb.append(String.format("    %s: %s\n", name, cnt));
            if (!tags) continue;
            this.addTags(sb, g.getId());
        }
        i = 0;
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof Timer)) continue;
            t = (Timer)m;
            if (i == 0) {
                sb.append("\nTimer:\n");
            }
            ++i;
            name = t.getId().getName();
            long count = t.count();
            long mean = Math.round(t.mean(TimeUnit.MILLISECONDS));
            long max = Math.round(t.max(TimeUnit.MILLISECONDS));
            long total = Math.round(t.totalTime(TimeUnit.MILLISECONDS));
            sb.append(String.format("    %s: %d (total: %dms mean: %dms max: %dms)\n", name, count, total, mean, max));
            if (!tags) continue;
            this.addTags(sb, t.getId());
        }
        i = 0;
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof LongTaskTimer)) continue;
            t = (LongTaskTimer)m;
            if (i == 0) {
                sb.append("\nLongTaskTimer:\n");
            }
            ++i;
            name = t.getId().getName();
            int tasks = t.activeTasks();
            long mean = Math.round(t.mean(TimeUnit.MILLISECONDS));
            long max = Math.round(t.max(TimeUnit.MILLISECONDS));
            long duration = Math.round(t.duration(TimeUnit.MILLISECONDS));
            sb.append(String.format("    %s: %d (duration: %dms mean: %dms max: %dms)\n", name, tasks, duration, mean, max));
            if (!tags) continue;
            this.addTags(sb, t.getId());
        }
        i = 0;
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof DistributionSummary)) continue;
            DistributionSummary d = (DistributionSummary)m;
            if (i == 0) {
                sb.append("\nDistributionSummary:\n");
            }
            ++i;
            name = d.getId().getName();
            long count = d.count();
            double mean = d.mean();
            double max = d.max();
            double total = d.totalAmount();
            sb.append(String.format("    %s: %d (total: %f mean: %f max: %f)\n", name, count, total, mean, max));
            if (!tags) continue;
            this.addTags(sb, d.getId());
        }
        return sb.toString();
    }

    protected void addTags(StringBuilder sb, Meter.Id id) {
        StringJoiner sj = new StringJoiner(" ");
        for (Tag tag : id.getTags()) {
            sj.add(tag.getKey() + "=" + tag.getValue());
        }
        if (sj.length() > 0) {
            sb.append(String.format("        %s\n", sj));
        }
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        Timer t;
        JsonObject jo;
        boolean tags = "true".equals(options.getOrDefault(TAGS, "true"));
        JsonObject root = new JsonObject();
        MeterRegistry mr = this.lookupMeterRegistry();
        root.put((Object)"meterRegistryClass", (Object)mr.getClass().getName());
        int i = 0;
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (Meter m : mr.getMeters()) {
            String cnt;
            if (!(m instanceof Counter)) continue;
            Counter c = (Counter)m;
            if (i == 0) {
                root.put((Object)"counters", list);
            }
            ++i;
            jo = new JsonObject();
            jo.put((Object)"name", (Object)c.getId().getName());
            if (c.getId().getDescription() != null) {
                jo.put((Object)"description", (Object)c.getId().getDescription());
            }
            if (tags) {
                this.addTags(m, jo);
            }
            if ((cnt = String.valueOf(c.count())).endsWith(".0") || cnt.endsWith(",0")) {
                cnt = cnt.substring(0, cnt.length() - 2);
                jo.put((Object)"count", (Object)Long.valueOf(cnt));
            } else {
                jo.put((Object)"count", (Object)c.count());
            }
            list.add(jo);
        }
        list.sort(this::sortByName);
        i = 0;
        list = new ArrayList();
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof Gauge)) continue;
            Gauge g = (Gauge)m;
            if (i == 0) {
                root.put((Object)"gauges", list);
            }
            ++i;
            jo = new JsonObject();
            jo.put((Object)"name", (Object)g.getId().getName());
            if (g.getId().getDescription() != null) {
                jo.put((Object)"description", (Object)g.getId().getDescription());
            }
            if (tags) {
                this.addTags(m, jo);
            }
            jo.put((Object)"value", (Object)g.value());
            list.add(jo);
        }
        list.sort(this::sortByName);
        i = 0;
        list = new ArrayList();
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof Timer)) continue;
            t = (Timer)m;
            if (i == 0) {
                root.put((Object)"timers", list);
            }
            ++i;
            jo = new JsonObject();
            jo.put((Object)"name", (Object)t.getId().getName());
            if (t.getId().getDescription() != null) {
                jo.put((Object)"description", (Object)t.getId().getDescription());
            }
            if (tags) {
                this.addTags(m, jo);
            }
            jo.put((Object)"count", (Object)t.count());
            jo.put((Object)"mean", (Object)Math.round(t.mean(TimeUnit.MILLISECONDS)));
            jo.put((Object)"max", (Object)Math.round(t.max(TimeUnit.MILLISECONDS)));
            jo.put((Object)"total", (Object)Math.round(t.totalTime(TimeUnit.MILLISECONDS)));
            list.add(jo);
        }
        list.sort(this::sortByName);
        i = 0;
        list = new ArrayList();
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof LongTaskTimer)) continue;
            t = (LongTaskTimer)m;
            if (i == 0) {
                root.put((Object)"longTaskTimers", list);
            }
            ++i;
            jo = new JsonObject();
            jo.put((Object)"name", (Object)t.getId().getName());
            if (t.getId().getDescription() != null) {
                jo.put((Object)"description", (Object)t.getId().getDescription());
            }
            if (tags) {
                this.addTags(m, jo);
            }
            jo.put((Object)"activeTasks", (Object)t.activeTasks());
            jo.put((Object)"mean", (Object)Math.round(t.mean(TimeUnit.MILLISECONDS)));
            jo.put((Object)"max", (Object)Math.round(t.max(TimeUnit.MILLISECONDS)));
            jo.put((Object)"duration", (Object)Math.round(t.duration(TimeUnit.MILLISECONDS)));
            list.add(jo);
        }
        list.sort(this::sortByName);
        i = 0;
        list = new ArrayList();
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof DistributionSummary)) continue;
            DistributionSummary d = (DistributionSummary)m;
            if (i == 0) {
                root.put((Object)"distribution", list);
            }
            ++i;
            jo = new JsonObject();
            jo.put((Object)"name", (Object)d.getId().getName());
            if (d.getId().getDescription() != null) {
                jo.put((Object)"description", (Object)d.getId().getDescription());
            }
            if (tags) {
                this.addTags(m, jo);
            }
            jo.put((Object)"count", (Object)d.count());
            jo.put((Object)"mean", (Object)d.mean());
            jo.put((Object)"max", (Object)d.max());
            jo.put((Object)"totalAmount", (Object)d.totalAmount());
            list.add(jo);
        }
        return root;
    }

    private void addTags(Meter m, JsonObject root) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (Tag t : m.getId().getTags()) {
            JsonObject jo = new JsonObject();
            jo.put((Object)"key", (Object)t.getKey());
            jo.put((Object)"value", (Object)t.getValue());
            list.add(jo);
        }
        if (!list.isEmpty()) {
            root.put((Object)TAGS, list);
        }
    }

    private MeterRegistry lookupMeterRegistry() {
        return MicrometerUtils.getOrCreateMeterRegistry(this.getCamelContext().getRegistry(), "metricsRegistry");
    }

    private int sortByName(JsonObject o1, JsonObject o2) {
        return o1.getString("name").compareToIgnoreCase(o2.getString("name"));
    }
}

