/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.util.function.Predicate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerEventNotifierService;
import org.apache.camel.spi.CamelEvent;

public interface MicrometerExchangeEventNotifierNamingStrategy {
    public static final Predicate<Meter.Id> EVENT_NOTIFIERS = id -> MicrometerEventNotifierService.class.getSimpleName().equals(id.getTag("serviceName"));
    public static final MicrometerExchangeEventNotifierNamingStrategy DEFAULT = (event, endpoint) -> "camel.exchange.event.notifier";
    public static final MicrometerExchangeEventNotifierNamingStrategy LEGACY = new MicrometerExchangeEventNotifierNamingStrategy(){

        @Override
        public String getName(Exchange exchange, Endpoint endpoint) {
            return this.formatName("camel.exchange.event.notifier");
        }

        @Override
        public String formatName(String name) {
            return MicrometerUtils.legacyName(name);
        }
    };

    public String getName(Exchange var1, Endpoint var2);

    default public String formatName(String name) {
        return name;
    }

    default public String getInflightExchangesName(Exchange exchange, Endpoint endpoint) {
        return this.formatName("camel.exchanges.inflight");
    }

    default public Tags getTags(CamelEvent.ExchangeEvent event, Endpoint endpoint) {
        String routeId;
        String uri = "";
        if (endpoint != null) {
            uri = endpoint.toString();
        }
        if ((routeId = event.getExchange().getFromRouteId()) != null) {
            return Tags.of((String[])new String[]{"camelContext", event.getExchange().getContext().getName(), "serviceName", MicrometerEventNotifierService.class.getSimpleName(), "eventType", event.getClass().getSimpleName(), "routeId", routeId, "endpointName", uri, "failed", Boolean.toString(event.getExchange().isFailed())});
        }
        return Tags.of((String[])new String[]{"camelContext", event.getExchange().getContext().getName(), "serviceName", MicrometerEventNotifierService.class.getSimpleName(), "eventType", event.getClass().getSimpleName(), "endpointName", uri, "failed", Boolean.toString(event.getExchange().isFailed())});
    }

    default public Tags getInflightExchangesTags(CamelEvent.ExchangeEvent event, Endpoint endpoint) {
        if (event.getExchange().getFromRouteId() != null) {
            return Tags.of((String[])new String[]{"camelContext", event.getExchange().getContext().getName(), "serviceName", MicrometerEventNotifierService.class.getSimpleName(), "routeId", event.getExchange().getFromRouteId()});
        }
        return Tags.of((String[])new String[]{"camelContext", event.getExchange().getContext().getName(), "serviceName", MicrometerEventNotifierService.class.getSimpleName()});
    }
}

