/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.config;

import java.util.Properties;
import java.util.function.Predicate;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.apache.camel.support.service.ServiceSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class CamelMicroProfilePropertiesSource
extends ServiceSupport
implements LoadablePropertiesSource {
    private Config config;

    public CamelMicroProfilePropertiesSource() {
    }

    public CamelMicroProfilePropertiesSource(Config config) {
        this.config = config;
    }

    public String getName() {
        return "CamelMicroProfilePropertiesSource";
    }

    public String getProperty(String name) {
        if (this.config == null) {
            this.config = ConfigProvider.getConfig();
        }
        return this.config.getOptionalValue(name, String.class).orElse(null);
    }

    public Properties loadProperties() {
        if (this.config == null) {
            this.config = ConfigProvider.getConfig();
        }
        Properties answer = new Properties();
        for (String key : this.config.getPropertyNames()) {
            answer.put(key, this.config.getValue(key, String.class));
        }
        return answer;
    }

    public Properties loadProperties(Predicate<String> filter) {
        if (this.config == null) {
            this.config = ConfigProvider.getConfig();
        }
        Properties answer = new Properties();
        for (String name : this.config.getPropertyNames()) {
            if (!filter.test(name)) continue;
            this.config.getOptionalValue(name, String.class).ifPresent(v -> answer.put(name, v));
        }
        return answer;
    }

    protected void doInit() throws Exception {
        if (this.config == null) {
            this.config = ConfigProvider.getConfig();
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

