/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.config;

import java.util.Properties;
import java.util.function.Predicate;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class CamelMicroProfilePropertiesSource
implements LoadablePropertiesSource {
    public String getName() {
        return "CamelMicroProfilePropertiesSource";
    }

    public String getProperty(String name) {
        return ConfigProvider.getConfig().getOptionalValue(name, String.class).orElse(null);
    }

    public Properties loadProperties() {
        Properties answer = new Properties();
        Config config = ConfigProvider.getConfig();
        for (String key : config.getPropertyNames()) {
            answer.put(key, config.getValue(key, String.class));
        }
        return answer;
    }

    public Properties loadProperties(Predicate<String> filter) {
        Properties answer = new Properties();
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            if (!filter.test(name)) continue;
            config.getOptionalValue(name, String.class).ifPresent(v -> answer.put(name, v));
        }
        return answer;
    }
}

