/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.config;

import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.apache.camel.spi.annotations.JdkService;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="properties-source-factory")
public class CamelMicroProfilePropertiesSource
implements LoadablePropertiesSource {
    private static final Logger LOG = LoggerFactory.getLogger(CamelMicroProfilePropertiesSource.class);

    public String getName() {
        return "CamelMicroProfilePropertiesSource";
    }

    public String getProperty(String name) {
        return ConfigProvider.getConfig().getOptionalValue(name, String.class).orElse(null);
    }

    public Properties loadProperties() {
        Properties answer = new Properties();
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            try {
                answer.put(name, config.getValue(name, String.class));
            }
            catch (NoSuchElementException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Failed to resolve property {} due to {}", (Object)name, (Object)e.getMessage());
            }
        }
        return answer;
    }

    public Properties loadProperties(Predicate<String> filter) {
        Properties answer = new Properties();
        Config config = ConfigProvider.getConfig();
        for (String name : config.getPropertyNames()) {
            if (!filter.test(name)) continue;
            try {
                config.getOptionalValue(name, String.class).ifPresent(value -> answer.put(name, value));
            }
            catch (NoSuchElementException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Failed to resolve property {} due to {}", (Object)name, (Object)e.getMessage());
            }
        }
        return answer;
    }

    public void reloadProperties(String location) {
    }

    public String toString() {
        return "camel-microprofile-config";
    }
}

