/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.faulttolerance;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.component.microprofile.faulttolerance.FaultToleranceProcessor;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="fault-tolerance")
public class FaultToleranceConsole
extends AbstractDevConsole {
    public FaultToleranceConsole() {
        super("camel", "fault-tolerance", "MicroProfile Fault Tolerance Circuit Breaker", "Display circuit breaker information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        ArrayList<FaultToleranceProcessor> cbs = new ArrayList<FaultToleranceProcessor>();
        for (Route route : this.getCamelContext().getRoutes()) {
            List list = route.filter("*");
            for (Processor p : list) {
                if (!(p instanceof FaultToleranceProcessor)) continue;
                cbs.add((FaultToleranceProcessor)p);
            }
        }
        cbs.sort(Comparator.comparing(FaultToleranceProcessor::getId));
        for (FaultToleranceProcessor cb : cbs) {
            String id = cb.getId();
            String rid = cb.getRouteId();
            String state = cb.getCircuitBreakerState();
            sb.append(String.format("    %s/%s: %s\n", rid, id, state));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList<FaultToleranceProcessor> cbs = new ArrayList<FaultToleranceProcessor>();
        for (Route route : this.getCamelContext().getRoutes()) {
            List list = route.filter("*");
            for (Processor p : list) {
                if (!(p instanceof FaultToleranceProcessor)) continue;
                cbs.add((FaultToleranceProcessor)p);
            }
        }
        cbs.sort(Comparator.comparing(FaultToleranceProcessor::getId));
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (FaultToleranceProcessor cb : cbs) {
            JsonObject jo = new JsonObject();
            jo.put((Object)"id", (Object)cb.getId());
            jo.put((Object)"routeId", (Object)cb.getRouteId());
            jo.put((Object)"state", (Object)cb.getCircuitBreakerState());
            list.add(jo);
        }
        root.put((Object)"circuitBreakers", list);
        return root;
    }
}

