/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.faulttolerance;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.bulkhead.FutureThreadPoolBulkhead;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.timeout.ScheduledExecutorTimeoutWatcher;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.timer.ThreadTimer;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.microprofile.faulttolerance.FaultToleranceConfiguration;
import org.apache.camel.processor.PooledExchangeTask;
import org.apache.camel.processor.PooledExchangeTaskFactory;
import org.apache.camel.processor.PooledTaskFactory;
import org.apache.camel.processor.PrototypeTaskFactory;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed FaultTolerance Processor")
public class FaultToleranceProcessor
extends AsyncProcessorSupport
implements CamelContextAware,
Navigate<Processor>,
Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(FaultToleranceProcessor.class);
    private volatile CircuitBreaker circuitBreaker;
    private CamelContext camelContext;
    private String id;
    private String routeId;
    private final FaultToleranceConfiguration config;
    private final Processor processor;
    private final Processor fallbackProcessor;
    private ScheduledExecutorService scheduledExecutorService;
    private boolean shutdownScheduledExecutorService;
    private ExecutorService executorService;
    private boolean shutdownExecutorService;
    private ExecutorService threadTimerExecutorService;
    private boolean shutdownThreadTimerExecutorService;
    private ProcessorExchangeFactory processorExchangeFactory;
    private PooledExchangeTaskFactory taskFactory;
    private PooledExchangeTaskFactory fallbackTaskFactory;

    public FaultToleranceProcessor(FaultToleranceConfiguration config, Processor processor, Processor fallbackProcessor) {
        this.config = config;
        this.processor = processor;
        this.fallbackProcessor = fallbackProcessor;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public void setCircuitBreaker(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public boolean isShutdownExecutorService() {
        return this.shutdownExecutorService;
    }

    public void setShutdownExecutorService(boolean shutdownExecutorService) {
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getTraceLabel() {
        return "faultTolerance";
    }

    @ManagedAttribute(description="Returns the current delay in milliseconds.")
    public long getDelay() {
        return this.config.getDelay();
    }

    @ManagedAttribute(description="Returns the current failure rate in percentage.")
    public float getFailureRate() {
        return this.config.getFailureRatio();
    }

    @ManagedAttribute(description="Returns the current request volume threshold.")
    public int getRequestVolumeThreshold() {
        return this.config.getRequestVolumeThreshold();
    }

    @ManagedAttribute(description="Returns the current success threshold.")
    public int getSuccessThreshold() {
        return this.config.getSuccessThreshold();
    }

    @ManagedAttribute(description="Is timeout enabled")
    public boolean isTimeoutEnabled() {
        return this.config.isTimeoutEnabled();
    }

    @ManagedAttribute(description="The timeout wait duration")
    public long getTimeoutDuration() {
        return this.config.getTimeoutDuration();
    }

    @ManagedAttribute(description="The timeout pool size for the thread pool")
    public int getTimeoutPoolSize() {
        return this.config.getTimeoutPoolSize();
    }

    @ManagedAttribute(description="Is bulkhead enabled")
    public boolean isBulkheadEnabled() {
        return this.config.isBulkheadEnabled();
    }

    @ManagedAttribute(description="The max amount of concurrent calls the bulkhead will support.")
    public int getBulkheadMaxConcurrentCalls() {
        return this.config.getBulkheadMaxConcurrentCalls();
    }

    @ManagedAttribute(description="The task queue size for holding waiting tasks to be processed by the bulkhead")
    public int getBulkheadWaitingTaskQueue() {
        return this.config.getBulkheadWaitingTaskQueue();
    }

    @ManagedAttribute(description="Returns the current state of the circuit breaker")
    public String getCircuitBreakerState() {
        if (this.circuitBreaker != null) {
            int state = this.circuitBreaker.currentState();
            if (state == 2) {
                return "HALF_OPEN";
            }
            if (state == 1) {
                return "OPEN";
            }
            return "CLOSED";
        }
        return null;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        answer.add(this.processor);
        if (this.fallbackProcessor != null) {
            answer.add(this.fallbackProcessor);
        }
        return answer;
    }

    public boolean hasNext() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        block16: {
            CircuitBreakerFallbackTask fallbackTask;
            block14: {
                exchange.setProperty(ExchangePropertyKey.TRY_ROUTE_BLOCK, (Object)true);
                fallbackTask = null;
                CircuitBreakerTask task = null;
                try {
                    task = (CircuitBreakerTask)this.taskFactory.acquire(exchange, callback);
                    CircuitBreaker target = this.circuitBreaker;
                    if (this.config.isBulkheadEnabled()) {
                        target = new FutureThreadPoolBulkhead((FaultToleranceStrategy)target, "bulkhead", this.config.getBulkheadMaxConcurrentCalls(), this.config.getBulkheadWaitingTaskQueue());
                    }
                    if (this.config.isTimeoutEnabled()) {
                        ScheduledExecutorTimeoutWatcher watcher = new ScheduledExecutorTimeoutWatcher(this.scheduledExecutorService);
                        target = new Timeout((FaultToleranceStrategy)target, "timeout", this.config.getTimeoutDuration(), (TimeoutWatcher)watcher);
                    }
                    if (this.fallbackProcessor != null) {
                        CircuitBreakerFallbackTask fFallbackTask = fallbackTask = (CircuitBreakerFallbackTask)this.fallbackTaskFactory.acquire(exchange, callback);
                        target = new Fallback((FaultToleranceStrategy)target, "fallback", fallbackContext -> {
                            exchange.setException(fallbackContext.failure);
                            return fFallbackTask.call();
                        }, ExceptionDecision.ALWAYS_FAILURE);
                    }
                    target.apply(new InvocationContext((Callable)task));
                    if (task == null) break block14;
                }
                catch (CircuitBreakerOpenException e) {
                    block15: {
                        exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SUCCESSFUL_EXECUTION, (Object)false);
                        exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_FROM_FALLBACK, (Object)false);
                        exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SHORT_CIRCUITED, (Object)true);
                        exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_REJECTED, (Object)true);
                        if (task == null) break block15;
                        this.taskFactory.release((PooledExchangeTask)task);
                    }
                    if (fallbackTask != null) {
                        this.fallbackTaskFactory.release((PooledExchangeTask)fallbackTask);
                    }
                    break block16;
                }
                catch (Exception e2) {
                    exchange.setException((Throwable)e2);
                    break block16;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (task != null) {
                        this.taskFactory.release((PooledExchangeTask)task);
                    }
                    if (fallbackTask != null) {
                        this.fallbackTaskFactory.release(fallbackTask);
                    }
                }
                this.taskFactory.release((PooledExchangeTask)task);
            }
            if (fallbackTask != null) {
                this.fallbackTaskFactory.release((PooledExchangeTask)fallbackTask);
            }
        }
        exchange.removeProperty(ExchangePropertyKey.TRY_ROUTE_BLOCK);
        callback.done(true);
        return true;
    }

    protected void doBuild() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        boolean pooled = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getExchangeFactory().isPooled();
        if (pooled) {
            int capacity = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getExchangeFactory().getCapacity();
            this.taskFactory = new PooledTaskFactory(this.getId()){

                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return new CircuitBreakerTask();
                }
            };
            this.taskFactory.setCapacity(capacity);
            this.fallbackTaskFactory = new PooledTaskFactory(this.getId()){

                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return new CircuitBreakerFallbackTask();
                }
            };
            this.fallbackTaskFactory.setCapacity(capacity);
        } else {
            this.taskFactory = new PrototypeTaskFactory(){

                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return new CircuitBreakerTask();
                }
            };
            this.fallbackTaskFactory = new PrototypeTaskFactory(){

                public PooledExchangeTask create(Exchange exchange, AsyncCallback callback) {
                    return new CircuitBreakerFallbackTask();
                }
            };
        }
        this.processorExchangeFactory = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getProcessorExchangeFactory().newProcessorExchangeFactory((Processor)this);
        this.processorExchangeFactory.setRouteId(this.getRouteId());
        this.processorExchangeFactory.setId(this.getId());
        ServiceHelper.buildService((Object[])new Object[]{this.processorExchangeFactory, this.taskFactory, this.fallbackTaskFactory, this.processor});
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        if (this.circuitBreaker == null) {
            this.threadTimerExecutorService = this.getCamelContext().getExecutorServiceManager().newCachedThreadPool((Object)this, "CircuitBreakerThreadTimer");
            this.shutdownThreadTimerExecutorService = true;
            this.circuitBreaker = new CircuitBreaker((FaultToleranceStrategy)Invocation.invocation(), this.id, ExceptionDecision.ALWAYS_FAILURE, this.config.getDelay(), this.config.getRequestVolumeThreshold(), (double)this.config.getFailureRatio(), this.config.getSuccessThreshold(), (Stopwatch)SystemStopwatch.INSTANCE, (Timer)new ThreadTimer((Executor)this.threadTimerExecutorService));
        }
        ServiceHelper.initService((Object[])new Object[]{this.processorExchangeFactory, this.taskFactory, this.fallbackTaskFactory, this.processor});
    }

    protected void doStart() throws Exception {
        if (this.config.isTimeoutEnabled() && this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this, "CircuitBreakerTimeout", this.config.getTimeoutPoolSize());
            this.shutdownScheduledExecutorService = true;
        }
        if (this.config.isBulkheadEnabled() && this.executorService == null) {
            this.executorService = this.getCamelContext().getExecutorServiceManager().newThreadPool((Object)this, "CircuitBreakerBulkhead", this.config.getBulkheadMaxConcurrentCalls(), this.config.getBulkheadMaxConcurrentCalls());
            this.shutdownExecutorService = true;
        }
        ServiceHelper.startService((Object[])new Object[]{this.processorExchangeFactory, this.taskFactory, this.fallbackTaskFactory, this.processor});
    }

    protected void doStop() throws Exception {
        if (this.shutdownScheduledExecutorService && this.scheduledExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.scheduledExecutorService);
            this.scheduledExecutorService = null;
        }
        if (this.shutdownExecutorService && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
            this.executorService = null;
        }
        if (this.shutdownThreadTimerExecutorService && this.threadTimerExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.threadTimerExecutorService);
            this.threadTimerExecutorService = null;
        }
        ServiceHelper.stopService((Object[])new Object[]{this.processorExchangeFactory, this.taskFactory, this.fallbackTaskFactory, this.processor});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.processorExchangeFactory, this.taskFactory, this.fallbackTaskFactory, this.processor});
    }

    private final class CircuitBreakerFallbackTask
    implements PooledExchangeTask,
    Callable<Exchange> {
        private Exchange exchange;

        private CircuitBreakerFallbackTask() {
        }

        public void prepare(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
        }

        public void reset() {
            this.exchange = null;
        }

        public void run() {
        }

        @Override
        public Exchange call() throws Exception {
            Exception throwable = this.exchange.getException();
            if (FaultToleranceProcessor.this.fallbackProcessor == null) {
                if (throwable instanceof TimeoutException) {
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SUCCESSFUL_EXECUTION, (Object)false);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_FROM_FALLBACK, (Object)false);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SHORT_CIRCUITED, (Object)false);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_TIMED_OUT, (Object)true);
                    this.exchange.setException((Throwable)throwable);
                    return this.exchange;
                }
                if (throwable instanceof CircuitBreakerOpenException) {
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SUCCESSFUL_EXECUTION, (Object)false);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_FROM_FALLBACK, (Object)false);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SHORT_CIRCUITED, (Object)true);
                    this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_REJECTED, (Object)true);
                    return this.exchange;
                }
                throw RuntimeExchangeException.wrapRuntimeException((Throwable)throwable);
            }
            this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SUCCESSFUL_EXECUTION, (Object)false);
            this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_FROM_FALLBACK, (Object)true);
            this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SHORT_CIRCUITED, (Object)true);
            if (this.exchange.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT) == null) {
                this.exchange.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, this.exchange.getProperty(ExchangePropertyKey.TO_ENDPOINT));
            }
            this.exchange.setProperty(ExchangePropertyKey.EXCEPTION_HANDLED, (Object)true);
            this.exchange.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)this.exchange.getException());
            this.exchange.setRouteStop(false);
            this.exchange.setException(null);
            ((ExtendedExchange)this.exchange.adapt(ExtendedExchange.class)).setRedeliveryExhausted(false);
            try {
                LOG.debug("Running fallback: {} with exchange: {}", (Object)FaultToleranceProcessor.this.fallbackProcessor, (Object)this.exchange);
                FaultToleranceProcessor.this.fallbackProcessor.process(this.exchange);
                LOG.debug("Running fallback: {} with exchange: {} done", (Object)FaultToleranceProcessor.this.fallbackProcessor, (Object)this.exchange);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            return this.exchange;
        }
    }

    private final class CircuitBreakerTask
    implements PooledExchangeTask,
    Callable<Exchange> {
        private Exchange exchange;

        private CircuitBreakerTask() {
        }

        public void prepare(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
        }

        public void reset() {
            this.exchange = null;
        }

        public void run() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exchange call() throws Exception {
            Exception cause;
            block11: {
                Exchange copy = null;
                UnitOfWork uow = null;
                ((ExtendedExchange)this.exchange.adapt(ExtendedExchange.class)).setInterruptable(false);
                try {
                    LOG.debug("Running processor: {} with exchange: {}", (Object)FaultToleranceProcessor.this.processor, (Object)this.exchange);
                    copy = FaultToleranceProcessor.this.processorExchangeFactory.createCorrelatedCopy(this.exchange, false);
                    if (copy.getUnitOfWork() != null) {
                        uow = copy.getUnitOfWork();
                    } else {
                        uow = ((ExtendedCamelContext)copy.getContext().adapt(ExtendedCamelContext.class)).getUnitOfWorkFactory().createUnitOfWork(copy);
                        ((ExtendedExchange)copy.adapt(ExtendedExchange.class)).setUnitOfWork(uow);
                        Route route = ExchangeHelper.getRoute((Exchange)this.exchange);
                        if (route != null) {
                            uow.pushRoute(route);
                        }
                    }
                    FaultToleranceProcessor.this.processor.process(copy);
                    if (copy.getException() != null) {
                        this.exchange.setException((Throwable)copy.getException());
                    } else {
                        ExchangeHelper.copyResults((Exchange)this.exchange, (Exchange)copy);
                        this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_SUCCESSFUL_EXECUTION, (Object)true);
                        this.exchange.setProperty(ExchangePropertyKey.CIRCUIT_BREAKER_RESPONSE_FROM_FALLBACK, (Object)false);
                    }
                    UnitOfWorkHelper.doneUow((UnitOfWork)uow, (Exchange)copy);
                }
                catch (Exception e) {
                    this.exchange.setException((Throwable)e);
                    break block11;
                }
                finally {
                    UnitOfWorkHelper.doneUow(uow, copy);
                    cause = this.exchange.getException();
                }
                cause = this.exchange.getException();
            }
            FaultToleranceProcessor.this.processorExchangeFactory.release(this.exchange);
            if (cause != null) {
                throw RuntimeExchangeException.wrapRuntimeException((Throwable)cause);
            }
            return this.exchange;
        }
    }
}

