/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.faulttolerance;

import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.component.microprofile.faulttolerance.FaultToleranceConfiguration;
import org.apache.camel.component.microprofile.faulttolerance.FaultToleranceProcessor;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.FaultToleranceConfigurationCommon;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.function.Suppliers;
import org.apache.camel.util.function.ThrowingSupplier;

public class FaultToleranceReifier
extends ProcessorReifier<CircuitBreakerDefinition> {
    public FaultToleranceReifier(Route route, CircuitBreakerDefinition definition) {
        super(route, (ProcessorDefinition)definition);
    }

    public Processor createProcessor() throws Exception {
        boolean fallbackViaNetwork;
        Processor processor = this.createChildProcessor(true);
        Processor fallback = null;
        if (((CircuitBreakerDefinition)this.definition).getOnFallback() != null) {
            fallback = this.createProcessor((ProcessorDefinition)((CircuitBreakerDefinition)this.definition).getOnFallback());
        }
        boolean bl = fallbackViaNetwork = ((CircuitBreakerDefinition)this.definition).getOnFallback() != null && this.parseBoolean(((CircuitBreakerDefinition)this.definition).getOnFallback().getFallbackViaNetwork(), false);
        if (fallbackViaNetwork) {
            throw new UnsupportedOperationException("camel-microprofile-fault-tolerance does not support onFallbackViaNetwork");
        }
        FaultToleranceConfigurationDefinition config = this.buildFaultToleranceConfiguration();
        FaultToleranceConfiguration configuration = new FaultToleranceConfiguration();
        this.configureCircuitBreaker((FaultToleranceConfigurationCommon)config, configuration);
        this.configureTimeLimiter((FaultToleranceConfigurationCommon)config, configuration);
        this.configureBulkhead((FaultToleranceConfigurationCommon)config, configuration);
        FaultToleranceProcessor answer = new FaultToleranceProcessor(configuration, processor, fallback);
        if (config.getCircuitBreakerRef() != null) {
            CircuitBreaker cb = (CircuitBreaker)this.mandatoryLookup(this.parseString(config.getCircuitBreakerRef()), CircuitBreaker.class);
            answer.setCircuitBreaker(cb);
        }
        this.configureBulkheadExecutorService(answer, (FaultToleranceConfigurationCommon)config);
        return answer;
    }

    private void configureCircuitBreaker(FaultToleranceConfigurationCommon config, FaultToleranceConfiguration target) {
        target.setDelay(this.parseDuration(config.getDelay(), 5000L));
        target.setSuccessThreshold(this.parseInt(config.getSuccessThreshold(), 1));
        target.setRequestVolumeThreshold(this.parseInt(config.getRequestVolumeThreshold(), 20));
        if (config.getFailureRatio() != null) {
            float num = this.parseFloat(config.getFailureRatio(), 50.0f);
            if (num < 1.0f || num > 100.0f) {
                throw new IllegalArgumentException("FailureRatio must be between 1 and 100, was: " + num);
            }
            float percent = num / 100.0f;
            target.setFailureRatio(percent);
        } else {
            target.setFailureRatio(0.5f);
        }
    }

    private void configureTimeLimiter(FaultToleranceConfigurationCommon config, FaultToleranceConfiguration target) {
        if (!this.parseBoolean(config.getTimeoutEnabled(), false)) {
            target.setTimeoutEnabled(false);
        } else {
            target.setTimeoutEnabled(true);
        }
        target.setTimeoutDuration(this.parseDuration(config.getTimeoutDuration(), 1000L));
        target.setTimeoutPoolSize(this.parseInt(config.getTimeoutPoolSize(), 10));
    }

    private void configureBulkhead(FaultToleranceConfigurationCommon config, FaultToleranceConfiguration target) {
        if (!this.parseBoolean(config.getBulkheadEnabled(), false)) {
            return;
        }
        target.setBulkheadMaxConcurrentCalls(this.parseInt(config.getBulkheadMaxConcurrentCalls(), 10));
        target.setBulkheadWaitingTaskQueue(this.parseInt(config.getBulkheadWaitingTaskQueue(), 10));
    }

    private void configureBulkheadExecutorService(FaultToleranceProcessor processor, FaultToleranceConfigurationCommon config) {
        if (!this.parseBoolean(config.getBulkheadEnabled(), false)) {
            return;
        }
        if (config.getBulkheadExecutorServiceRef() != null) {
            String ref = config.getBulkheadExecutorServiceRef();
            boolean shutdownThreadPool = false;
            ExecutorService executorService = (ExecutorService)this.lookup(ref, ExecutorService.class);
            if (executorService == null) {
                executorService = this.lookupExecutorServiceRef("CircuitBreaker", this.definition, ref);
                shutdownThreadPool = true;
            }
            processor.setExecutorService(executorService);
            processor.setShutdownExecutorService(shutdownThreadPool);
        }
    }

    FaultToleranceConfigurationDefinition buildFaultToleranceConfiguration() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        GeneratedPropertyConfigurer configurer = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(FaultToleranceConfigurationDefinition.class.getName(), this.camelContext);
        this.loadProperties(properties, Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> ((Model)this.camelContext.getExtension(Model.class)).getFaultToleranceConfiguration(null), () -> (FaultToleranceConfigurationDefinition)this.lookup("fault-tolerance-configuration", FaultToleranceConfigurationDefinition.class)}), (PropertyConfigurer)configurer);
        if (((CircuitBreakerDefinition)this.definition).getConfigurationRef() != null) {
            String ref = ((CircuitBreakerDefinition)this.definition).getConfigurationRef();
            this.loadProperties(properties, Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> ((Model)this.camelContext.getExtension(Model.class)).getFaultToleranceConfiguration(ref), () -> (FaultToleranceConfigurationDefinition)this.mandatoryLookup(ref, FaultToleranceConfigurationDefinition.class)}), (PropertyConfigurer)configurer);
        }
        this.loadProperties(properties, Optional.ofNullable(((CircuitBreakerDefinition)this.definition).getFaultToleranceConfiguration()), (PropertyConfigurer)configurer);
        FaultToleranceConfigurationDefinition config = new FaultToleranceConfigurationDefinition();
        PropertyBindingSupport.build().withCamelContext(this.camelContext).withConfigurer((PropertyConfigurer)configurer).withProperties(properties).withTarget((Object)config).bind();
        return config;
    }

    private void loadProperties(Map<String, Object> properties, Optional<?> optional, PropertyConfigurer configurer) {
        BeanIntrospection beanIntrospection = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection();
        optional.ifPresent(bean -> {
            if (configurer instanceof PropertyConfigurerGetter) {
                PropertyConfigurerGetter getter = (PropertyConfigurerGetter)configurer;
                Map types = getter.getAllOptions(bean);
                types.forEach((k, t) -> {
                    Object value = getter.getOptionValue(bean, k, true);
                    if (value != null) {
                        properties.put((String)k, value);
                    }
                });
            } else {
                beanIntrospection.getProperties(bean, properties, null, false);
            }
        });
    }
}

