/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.faulttolerance;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.bulkhead.ThreadPoolBulkhead;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.timeout.ScheduledExecutorTimeoutWatcher;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.microprofile.faulttolerance.FaultToleranceConfiguration;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed FaultTolerance Processor")
public class FaultToleranceProcessor
extends AsyncProcessorSupport
implements CamelContextAware,
Navigate<Processor>,
Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(FaultToleranceProcessor.class);
    private volatile CircuitBreaker circuitBreaker;
    private CamelContext camelContext;
    private String id;
    private final FaultToleranceConfiguration config;
    private final Processor processor;
    private final Processor fallbackProcessor;
    private ScheduledExecutorService scheduledExecutorService;
    private boolean shutdownScheduledExecutorService;
    private ExecutorService executorService;
    private boolean shutdownExecutorService;

    public FaultToleranceProcessor(FaultToleranceConfiguration config, Processor processor, Processor fallbackProcessor) {
        this.config = config;
        this.processor = processor;
        this.fallbackProcessor = fallbackProcessor;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public void setCircuitBreaker(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public boolean isShutdownExecutorService() {
        return this.shutdownExecutorService;
    }

    public void setShutdownExecutorService(boolean shutdownExecutorService) {
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getTraceLabel() {
        return "faultTolerance";
    }

    @ManagedAttribute(description="Returns the current delay in milliseconds.")
    public long getDelay() {
        return this.config.getDelay();
    }

    @ManagedAttribute(description="Returns the current failure rate in percentage.")
    public float getFailureRate() {
        return this.config.getFailureRatio();
    }

    @ManagedAttribute(description="Returns the current request volume threshold.")
    public int getRequestVolumeThreshold() {
        return this.config.getRequestVolumeThreshold();
    }

    @ManagedAttribute(description="Returns the current success threshold.")
    public int getSuccessThreshold() {
        return this.config.getSuccessThreshold();
    }

    @ManagedAttribute(description="Is timeout enabled")
    public boolean isTimeoutEnabled() {
        return this.config.isTimeoutEnabled();
    }

    @ManagedAttribute(description="The timeout wait duration")
    public long getTimeoutDuration() {
        return this.config.getTimeoutDuration();
    }

    @ManagedAttribute(description="The timeout pool size for the thread pool")
    public int getTimeoutPoolSize() {
        return this.config.getTimeoutPoolSize();
    }

    @ManagedAttribute(description="Is bulkhead enabled")
    public boolean isBulkheadEnabled() {
        return this.config.isBulkheadEnabled();
    }

    @ManagedAttribute(description="The max amount of concurrent calls the bulkhead will support.")
    public int getBulkheadMaxConcurrentCalls() {
        return this.config.getBulkheadMaxConcurrentCalls();
    }

    @ManagedAttribute(description="The task queue size for holding waiting tasks to be processed by the bulkhead")
    public int getBulkheadWaitingTaskQueue() {
        return this.config.getBulkheadWaitingTaskQueue();
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        answer.add(this.processor);
        if (this.fallbackProcessor != null) {
            answer.add(this.fallbackProcessor);
        }
        return answer;
    }

    public boolean hasNext() {
        return true;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        exchange.setProperty("TryRouteBlock", (Object)true);
        CircuitBreakerTask task = new CircuitBreakerTask(this.processor, exchange);
        CircuitBreaker target = this.circuitBreaker;
        if (this.config.isBulkheadEnabled()) {
            target = new ThreadPoolBulkhead((FaultToleranceStrategy)target, "bulkhead", this.executorService, this.config.getBulkheadMaxConcurrentCalls(), this.config.getBulkheadWaitingTaskQueue(), null);
        }
        if (this.config.isTimeoutEnabled()) {
            ScheduledExecutorTimeoutWatcher watcher = new ScheduledExecutorTimeoutWatcher(this.scheduledExecutorService);
            target = new Timeout((FaultToleranceStrategy)target, "timeout", this.config.getTimeoutDuration(), (TimeoutWatcher)watcher, null);
        }
        if (this.fallbackProcessor != null) {
            CircuitBreakerFallbackTask fallbackTask = new CircuitBreakerFallbackTask(this.fallbackProcessor, exchange);
            target = new Fallback((FaultToleranceStrategy)target, "fallback", fallbackContext -> {
                exchange.setException(fallbackContext.failure);
                return fallbackTask.call();
            }, SetOfThrowables.ALL, SetOfThrowables.EMPTY, null);
        }
        try {
            target.apply(new InvocationContext((Callable)task));
        }
        catch (CircuitBreakerOpenException e) {
            exchange.setProperty("CamelCircuitBreakerSuccessfulExecution", (Object)false);
            exchange.setProperty("CamelCircuitBreakerResponseFromFallback", (Object)false);
            exchange.setProperty("CamelCircuitBreakerResponseShortCircuited", (Object)true);
            exchange.setProperty("CamelCircuitBreakerResponseRejected", (Object)true);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        exchange.removeProperty("TryRouteBlock");
        callback.done(true);
        return true;
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        if (this.circuitBreaker == null) {
            this.circuitBreaker = new CircuitBreaker((FaultToleranceStrategy)Invocation.invocation(), this.id, SetOfThrowables.ALL, SetOfThrowables.EMPTY, this.config.getDelay(), this.config.getRequestVolumeThreshold(), (double)this.config.getFailureRatio(), this.config.getSuccessThreshold(), (Stopwatch)new SystemStopwatch(), null);
        }
    }

    protected void doStart() throws Exception {
        if (this.config.isTimeoutEnabled() && this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this, "CircuitBreakerTimeout", this.config.getTimeoutPoolSize());
            this.shutdownScheduledExecutorService = true;
        }
        if (this.config.isBulkheadEnabled() && this.executorService == null) {
            this.executorService = this.getCamelContext().getExecutorServiceManager().newThreadPool((Object)this, "CircuitBreakerBulkhead", this.config.getBulkheadMaxConcurrentCalls(), this.config.getBulkheadMaxConcurrentCalls());
            this.shutdownExecutorService = true;
        }
    }

    protected void doStop() throws Exception {
        if (this.shutdownScheduledExecutorService && this.scheduledExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.scheduledExecutorService);
            this.scheduledExecutorService = null;
        }
        if (this.shutdownExecutorService && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
            this.executorService = null;
        }
    }

    private static final class CircuitBreakerFallbackTask
    implements Callable<Exchange> {
        private final Processor processor;
        private final Exchange exchange;

        private CircuitBreakerFallbackTask(Processor processor, Exchange exchange) {
            this.processor = processor;
            this.exchange = exchange;
        }

        @Override
        public Exchange call() throws Exception {
            Exception throwable = this.exchange.getException();
            if (this.processor == null) {
                if (throwable instanceof TimeoutException) {
                    this.exchange.setProperty("CamelCircuitBreakerSuccessfulExecution", (Object)false);
                    this.exchange.setProperty("CamelCircuitBreakerResponseFromFallback", (Object)false);
                    this.exchange.setProperty("CamelCircuitBreakerResponseShortCircuited", (Object)false);
                    this.exchange.setProperty("CamelCircuitBreakerResponseTimedOut", (Object)true);
                    this.exchange.setException((Throwable)throwable);
                    return this.exchange;
                }
                if (throwable instanceof CircuitBreakerOpenException) {
                    this.exchange.setProperty("CamelCircuitBreakerSuccessfulExecution", (Object)false);
                    this.exchange.setProperty("CamelCircuitBreakerResponseFromFallback", (Object)false);
                    this.exchange.setProperty("CamelCircuitBreakerResponseShortCircuited", (Object)true);
                    this.exchange.setProperty("CamelCircuitBreakerResponseRejected", (Object)true);
                    return this.exchange;
                }
                throw RuntimeExchangeException.wrapRuntimeException((Throwable)throwable);
            }
            this.exchange.setProperty("CamelCircuitBreakerSuccessfulExecution", (Object)false);
            this.exchange.setProperty("CamelCircuitBreakerResponseFromFallback", (Object)true);
            this.exchange.setProperty("CamelCircuitBreakerResponseShortCircuited", (Object)true);
            if (this.exchange.getProperty("CamelFailureEndpoint") == null) {
                this.exchange.setProperty("CamelFailureEndpoint", this.exchange.getProperty("CamelToEndpoint"));
            }
            this.exchange.setProperty("CamelExceptionHandled", (Object)true);
            this.exchange.setProperty("CamelExceptionCaught", (Object)this.exchange.getException());
            this.exchange.setRouteStop(false);
            this.exchange.setException(null);
            ((ExtendedExchange)this.exchange.adapt(ExtendedExchange.class)).setRedeliveryExhausted(false);
            try {
                LOG.debug("Running fallback: {} with exchange: {}", (Object)this.processor, (Object)this.exchange);
                this.processor.process(this.exchange);
                LOG.debug("Running fallback: {} with exchange: {} done", (Object)this.processor, (Object)this.exchange);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
            return this.exchange;
        }
    }

    private static final class CircuitBreakerTask
    implements Callable<Exchange> {
        private final Processor processor;
        private final Exchange exchange;

        private CircuitBreakerTask(Processor processor, Exchange exchange) {
            this.processor = processor;
            this.exchange = exchange;
        }

        @Override
        public Exchange call() throws Exception {
            ((ExtendedExchange)this.exchange.adapt(ExtendedExchange.class)).setInterruptable(false);
            try {
                LOG.debug("Running processor: {} with exchange: {}", (Object)this.processor, (Object)this.exchange);
                Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)this.exchange, (boolean)false, (boolean)false);
                this.processor.process(copy);
                if (copy.getException() != null) {
                    this.exchange.setException((Throwable)copy.getException());
                } else {
                    ExchangeHelper.copyResults((Exchange)this.exchange, (Exchange)copy);
                    this.exchange.setProperty("CamelCircuitBreakerSuccessfulExecution", (Object)true);
                    this.exchange.setProperty("CamelCircuitBreakerResponseFromFallback", (Object)false);
                }
                if (copy.getUnitOfWork() == null) {
                    List synchronizations = ((ExtendedExchange)copy.adapt(ExtendedExchange.class)).handoverCompletions();
                    UnitOfWorkHelper.doneSynchronizations((Exchange)copy, (List)synchronizations, (Logger)LOG);
                } else {
                    copy.getUnitOfWork().done(this.exchange);
                }
            }
            catch (Throwable e) {
                this.exchange.setException(e);
            }
            if (this.exchange.getException() != null) {
                throw this.exchange.getException();
            }
            return this.exchange;
        }
    }
}

