/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.microprofile.health;

import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public abstract class AbstractCamelMicroProfileHealthCheck
implements HealthCheck,
CamelContextAware {
    @Inject
    protected CamelContext camelContext;

    protected abstract boolean acceptHealthCheck(AbstractHealthCheck var1);

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.builder();
        builder.name(this.getHealthCheckName());
        builder.up();
        if (this.camelContext != null) {
            Collection results = HealthCheckHelper.invoke((CamelContext)this.camelContext, check -> check.getId().equals("context") || check instanceof AbstractHealthCheck && !this.acceptHealthCheck((AbstractHealthCheck)check));
            for (HealthCheck.Result result : results) {
                Map details = result.getDetails();
                boolean enabled = true;
                if (details.containsKey("check.enabled")) {
                    enabled = (Boolean)details.get("check.enabled");
                }
                if (!enabled) continue;
                builder.withData(result.getCheck().getId(), result.getState().name());
                if (result.getState() != HealthCheck.State.DOWN) continue;
                builder.down();
            }
        }
        return builder.build();
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public boolean isReadiness() {
        return true;
    }

    public boolean isLiveness() {
        return true;
    }

    abstract String getHealthCheckName();
}

